/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.metrics.prometheus;

import com.google.common.eventbus.EventBus;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.exporter.HTTPServer;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.apache.servicecomb.config.BootStrapProperties;
import org.apache.servicecomb.foundation.common.exceptions.ServiceCombException;
import org.apache.servicecomb.foundation.metrics.MetricsBootstrapConfig;
import org.apache.servicecomb.foundation.metrics.MetricsInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;

public class PrometheusPublisher
extends Collector
implements Collector.Describable,
MetricsInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrometheusPublisher.class);
    public static final String METRICS_PROMETHEUS_ADDRESS = "servicecomb.metrics.prometheus.address";
    private HTTPServer httpServer;
    private MeterRegistry meterRegistry;
    private Environment environment;

    @Autowired
    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void init(MeterRegistry meterRegistry, EventBus eventBus, MetricsBootstrapConfig config) {
        this.meterRegistry = meterRegistry;
        String address = (String)this.environment.getProperty(METRICS_PROMETHEUS_ADDRESS, String.class, (Object)"0.0.0.0:9696");
        try {
            InetSocketAddress socketAddress = this.getSocketAddress(address);
            this.register();
            this.httpServer = new HTTPServer(socketAddress, CollectorRegistry.defaultRegistry, true);
            LOGGER.info("Prometheus httpServer listened : {}.", (Object)address);
        }
        catch (Exception e) {
            throw new ServiceCombException("create http publish server failed,may bad address : " + address, (Throwable)e);
        }
    }

    private InetSocketAddress getSocketAddress(String address) {
        String[] hostAndPort = address.split(":");
        if (hostAndPort.length == 2) {
            return new InetSocketAddress(hostAndPort[0], Integer.parseInt(hostAndPort[1]));
        }
        throw new ServiceCombException("create http publish server failed,bad address : " + address);
    }

    public List<Collector.MetricFamilySamples> describe() {
        ArrayList<Collector.MetricFamilySamples> familySamples = new ArrayList<Collector.MetricFamilySamples>();
        ArrayList samples = new ArrayList();
        for (Meter meter : this.meterRegistry.getMeters()) {
            meter.measure().forEach(measurement -> {
                Collector.MetricFamilySamples.Sample sample = this.convertMeasurementToSample(meter, (Measurement)measurement);
                samples.add(sample);
            });
        }
        familySamples.add(new Collector.MetricFamilySamples("ServiceComb_Metrics", Collector.Type.UNKNOWN, "ServiceComb Metrics", samples));
        return familySamples;
    }

    protected Collector.MetricFamilySamples.Sample convertMeasurementToSample(Meter meter, Measurement measurement) {
        String prometheusName = meter.getId().getName().replace(".", "_");
        ArrayList<String> labelNames = new ArrayList<String>();
        ArrayList<String> labelValues = new ArrayList<String>();
        labelNames.add("appId");
        labelValues.add(BootStrapProperties.readApplication((Environment)this.environment));
        for (Tag tag : meter.getId().getTags()) {
            labelNames.add(tag.getKey());
            labelValues.add(tag.getValue());
        }
        return new Collector.MetricFamilySamples.Sample(prometheusName, labelNames, labelValues, measurement.getValue());
    }

    public List<Collector.MetricFamilySamples> collect() {
        return this.describe();
    }

    public void destroy() {
        if (this.httpServer == null) {
            return;
        }
        this.httpServer.close();
        this.httpServer = null;
        LOGGER.info("Prometheus httpServer stopped.");
    }
}

