/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.provider.springmvc.reference;

import java.io.IOException;
import java.lang.reflect.Type;
import org.apache.servicecomb.foundation.common.utils.GenericsUtils;
import org.apache.servicecomb.provider.springmvc.reference.CseClientHttpRequest;
import org.apache.servicecomb.provider.springmvc.reference.CseHttpEntity;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.web.client.RequestCallback;

public class CseRequestCallback
implements RequestCallback {
    private final Object requestBody;
    private final RequestCallback targetCallback;
    private final Type responseType;

    public CseRequestCallback(Object requestBody, RequestCallback targetCallback, Type responseType) {
        this.requestBody = requestBody;
        this.targetCallback = targetCallback;
        this.responseType = responseType;
    }

    public void doWithRequest(ClientHttpRequest request) throws IOException {
        this.targetCallback.doWithRequest(request);
        CseClientHttpRequest req = (CseClientHttpRequest)request;
        req.setResponseType(this.overrideResponseType());
        if (!CseHttpEntity.class.isInstance(this.requestBody)) {
            return;
        }
        CseHttpEntity entity = (CseHttpEntity)((Object)this.requestBody);
        req.setContext(entity.getContext());
    }

    private Type overrideResponseType() {
        if (GenericsUtils.isGenericResponseType((Type)this.responseType)) {
            return null;
        }
        return this.responseType;
    }
}

