/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.registry.lightweight.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.config.BootStrapProperties;
import org.apache.servicecomb.registry.api.DataCenterInfo;
import org.apache.servicecomb.registry.api.MicroserviceInstanceStatus;
import org.apache.servicecomb.registry.lightweight.model.HealthCheck;
import org.apache.servicecomb.registry.lightweight.model.HealthCheckMode;
import org.apache.servicecomb.registry.lightweight.model.InstancePropertiesLoader;
import org.springframework.core.env.Environment;

@JsonIgnoreProperties(ignoreUnknown=true)
public class MicroserviceInstance {
    private String instanceId;
    private String serviceId;
    private List<String> endpoints = new ArrayList<String>();
    private String hostName;
    private MicroserviceInstanceStatus status = MicroserviceInstanceStatus.UP;
    private Map<String, String> properties = new HashMap<String, String>();
    private HealthCheck healthCheck;
    private String stage;
    private DataCenterInfo dataCenterInfo;
    private String timestamp;

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("instanceId=" + this.instanceId + ";");
        sb.append("serviceId=" + this.serviceId + ";");
        sb.append("status=" + this.status + ";");
        sb.append("endpoints=" + this.endpoints.toString());
        return sb.toString();
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public MicroserviceInstance instanceId(String instanceId) {
        this.instanceId = instanceId;
        return this;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public MicroserviceInstance serviceId(String serviceId) {
        this.serviceId = serviceId;
        return this;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public List<String> getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(List<String> endpoints) {
        this.endpoints = endpoints;
    }

    public MicroserviceInstanceStatus getStatus() {
        return this.status;
    }

    public void setStatus(MicroserviceInstanceStatus status) {
        this.status = status;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public HealthCheck getHealthCheck() {
        return this.healthCheck;
    }

    public void setHealthCheck(HealthCheck healthCheck) {
        this.healthCheck = healthCheck;
    }

    @Deprecated
    public String getStage() {
        return this.stage;
    }

    @Deprecated
    public void setStage(String stage) {
        this.stage = stage;
    }

    public DataCenterInfo getDataCenterInfo() {
        return this.dataCenterInfo;
    }

    public int hashCode() {
        return this.instanceId.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof MicroserviceInstance) {
            return this.instanceId.equals(((MicroserviceInstance)obj).instanceId);
        }
        return false;
    }

    public void setDataCenterInfo(DataCenterInfo dataCenterInfo) {
        this.dataCenterInfo = dataCenterInfo;
    }

    public static MicroserviceInstance createFromDefinition(Environment environment) {
        MicroserviceInstance microserviceInstance = new MicroserviceInstance();
        microserviceInstance.setStage("prod");
        microserviceInstance.setStatus(MicroserviceInstanceStatus.valueOf((String)BootStrapProperties.readServiceInstanceInitialStatus((Environment)environment)));
        HealthCheck healthCheck = new HealthCheck();
        healthCheck.setMode(HealthCheckMode.HEARTBEAT);
        microserviceInstance.setHealthCheck(healthCheck);
        Map<String, String> propertiesMap = InstancePropertiesLoader.INSTANCE.loadProperties(environment);
        microserviceInstance.setProperties(propertiesMap);
        MicroserviceInstance.loadDataCenterInfo(environment, microserviceInstance);
        return microserviceInstance;
    }

    private static void loadDataCenterInfo(Environment environment, MicroserviceInstance microserviceInstance) {
        String dataCenterName = environment.getProperty("servicecomb.datacenter.name");
        if (StringUtils.isEmpty((CharSequence)dataCenterName)) {
            return;
        }
        String region = environment.getProperty("servicecomb.datacenter.region");
        String availableZone = environment.getProperty("servicecomb.datacenter.availableZone");
        DataCenterInfo dataCenterInfo = new DataCenterInfo();
        dataCenterInfo.setName(dataCenterName);
        dataCenterInfo.setRegion(region);
        dataCenterInfo.setAvailableZone(availableZone);
        microserviceInstance.setDataCenterInfo(dataCenterInfo);
    }
}

