/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.vertx.metrics;

import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.metrics.TCPMetrics;
import org.apache.servicecomb.foundation.vertx.metrics.metric.DefaultServerEndpointMetric;
import org.apache.servicecomb.foundation.vertx.metrics.metric.DefaultTcpSocketMetric;

public class DefaultTcpServerMetrics
implements TCPMetrics<DefaultTcpSocketMetric> {
    private final DefaultServerEndpointMetric endpointMetric;

    public DefaultTcpServerMetrics(DefaultServerEndpointMetric endpointMetric) {
        this.endpointMetric = endpointMetric;
    }

    public DefaultServerEndpointMetric getEndpointMetric() {
        return this.endpointMetric;
    }

    public DefaultTcpSocketMetric connected(SocketAddress remoteAddress, String remoteName) {
        DefaultTcpSocketMetric socketMetric = new DefaultTcpSocketMetric(this.endpointMetric);
        socketMetric.onConnect();
        return socketMetric;
    }

    public void disconnected(DefaultTcpSocketMetric socketMetric, SocketAddress remoteAddress) {
        socketMetric.onDisconnect();
    }

    public void bytesRead(DefaultTcpSocketMetric socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
        socketMetric.getEndpointMetric().addBytesRead(numberOfBytes);
    }

    public void bytesWritten(DefaultTcpSocketMetric socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
        socketMetric.getEndpointMetric().addBytesWritten(numberOfBytes);
    }
}

