/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.rocketmq.remoting.protocol.body;

import java.util.Map;
import org.apache.rocketmq.remoting.protocol.DataVersion;
import org.apache.rocketmq.remoting.protocol.RemotingSerializable;

public class ClusterAclVersionInfo extends RemotingSerializable {

    private String brokerName;

    private String brokerAddr;

    @Deprecated
    private DataVersion aclConfigDataVersion;

    private Map<String, DataVersion> allAclConfigDataVersion;

    private String clusterName;

    public String getBrokerName() {
        return brokerName;
    }

    public void setBrokerName(String brokerName) {
        this.brokerName = brokerName;
    }

    public String getBrokerAddr() {
        return brokerAddr;
    }

    public void setBrokerAddr(String brokerAddr) {
        this.brokerAddr = brokerAddr;
    }

    public String getClusterName() {
        return clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public DataVersion getAclConfigDataVersion() {
        return aclConfigDataVersion;
    }

    public void setAclConfigDataVersion(DataVersion aclConfigDataVersion) {
        this.aclConfigDataVersion = aclConfigDataVersion;
    }

    public Map<String, DataVersion> getAllAclConfigDataVersion() {
        return allAclConfigDataVersion;
    }

    public void setAllAclConfigDataVersion(
        Map<String, DataVersion> allAclConfigDataVersion) {
        this.allAclConfigDataVersion = allAclConfigDataVersion;
    }
}
