/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmException;
import org.apache.olingo.commons.api.edm.EdmKeyPropertyRef;
import org.apache.olingo.commons.api.edm.EdmStructuredType;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.constants.EdmTypeKind;
import org.apache.olingo.commons.api.edm.provider.CsdlEntityType;
import org.apache.olingo.commons.api.edm.provider.CsdlPropertyRef;
import org.apache.olingo.commons.api.edm.provider.CsdlStructuralType;
import org.apache.olingo.commons.core.edm.AbstractEdmStructuredType;
import org.apache.olingo.commons.core.edm.EdmKeyPropertyRefImpl;

public class EdmEntityTypeImpl
extends AbstractEdmStructuredType
implements EdmEntityType {
    private CsdlEntityType entityType;
    private boolean baseTypeChecked = false;
    private final boolean hasStream;
    protected EdmEntityType entityBaseType;
    private final List<String> keyPredicateNames = Collections.synchronizedList(new ArrayList());
    private final Map<String, EdmKeyPropertyRef> keyPropertyRefs = Collections.synchronizedMap(new LinkedHashMap());
    private List<EdmKeyPropertyRef> keyPropertyRefsList;

    public EdmEntityTypeImpl(Edm edm, FullQualifiedName name, CsdlEntityType entityType) {
        super(edm, name, EdmTypeKind.ENTITY, (CsdlStructuralType)entityType);
        this.entityType = entityType;
        this.hasStream = entityType.hasStream();
    }

    @Override
    protected void checkBaseType() {
        if (!this.baseTypeChecked) {
            List key;
            if (this.baseTypeName != null) {
                this.baseType = this.buildBaseType(this.baseTypeName);
                this.entityBaseType = (EdmEntityType)this.baseType;
            }
            if ((this.baseType == null || this.baseType.isAbstract() && ((EdmEntityType)this.baseType).getKeyPropertyRefs().isEmpty()) && (key = this.entityType.getKey()) != null) {
                ArrayList<EdmKeyPropertyRef> edmKey = new ArrayList<EdmKeyPropertyRef>();
                for (CsdlPropertyRef ref : key) {
                    edmKey.add(new EdmKeyPropertyRefImpl(this, ref));
                }
                this.setEdmKeyPropertyRef(edmKey);
            }
            this.baseTypeChecked = true;
        }
    }

    protected void setEdmKeyPropertyRef(List<EdmKeyPropertyRef> edmKey) {
        for (EdmKeyPropertyRef ref : edmKey) {
            if (ref.getAlias() == null) {
                this.keyPredicateNames.add(ref.getName());
                this.keyPropertyRefs.put(ref.getName(), ref);
                continue;
            }
            this.keyPredicateNames.add(ref.getAlias());
            this.keyPropertyRefs.put(ref.getAlias(), ref);
        }
    }

    @Override
    protected EdmStructuredType buildBaseType(FullQualifiedName baseTypeName) {
        EdmEntityType baseType = null;
        if (baseTypeName != null && (baseType = this.edm.getEntityType(baseTypeName)) == null) {
            throw new EdmException("Cannot find base type with name: " + baseTypeName + " for entity type: " + this.getName());
        }
        return baseType;
    }

    public EdmEntityType getBaseType() {
        this.checkBaseType();
        return this.entityBaseType;
    }

    public List<String> getKeyPredicateNames() {
        this.checkBaseType();
        if (this.keyPredicateNames.isEmpty() && this.baseType != null) {
            return this.entityBaseType.getKeyPredicateNames();
        }
        return Collections.unmodifiableList(this.keyPredicateNames);
    }

    public List<EdmKeyPropertyRef> getKeyPropertyRefs() {
        this.checkBaseType();
        if (this.keyPropertyRefsList == null) {
            this.keyPropertyRefsList = new ArrayList<EdmKeyPropertyRef>(this.keyPropertyRefs.values());
        }
        if (this.keyPropertyRefsList.isEmpty() && this.entityBaseType != null) {
            return this.entityBaseType.getKeyPropertyRefs();
        }
        return Collections.unmodifiableList(this.keyPropertyRefsList);
    }

    public EdmKeyPropertyRef getKeyPropertyRef(String keyPredicateName) {
        this.checkBaseType();
        EdmKeyPropertyRef edmKeyPropertyRef = this.keyPropertyRefs.get(keyPredicateName);
        if (edmKeyPropertyRef == null && this.entityBaseType != null) {
            return this.entityBaseType.getKeyPropertyRef(keyPredicateName);
        }
        return edmKeyPropertyRef;
    }

    public boolean hasStream() {
        this.checkBaseType();
        return this.hasStream || this.entityBaseType != null && this.entityBaseType.hasStream();
    }
}

