/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/*
 * AutoupdatePanel.java
 *
 * Created on Jul 2, 2009, 6:52:07 PM
 */

package org.netbeans.modules.bugtracking.commons;

import org.openide.util.NbBundle;

/**
 *
 * @author Tomas Stupka
 */
public class AutoupdatePanel extends javax.swing.JPanel {
    private final AutoupdateSupport support;

    @NbBundle.Messages({"LBL_DontShow=Don't show this message again",
                        "# {0} - pluginName", "TXT_text="
                                               + "The {0} server you are trying to access has a higher "
                                               + "version than the one supported by NetBeans. "
                                               + "Do you want to download an update from the NetBeans Update Center?"})            
    public AutoupdatePanel(AutoupdateSupport support) {
        initComponents();
        txtTextArea.setText(Bundle.TXT_text(support.getPluginName()));
        dontShowCheckBox.setText(Bundle.LBL_DontShow());
        this.support = support;
        dontShowCheckBox.setSelected(!support.getCheckUpdates());
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jScrollPane1 = new javax.swing.JScrollPane();
        txtTextArea = new javax.swing.JTextArea();

        jScrollPane1.setBorder(null);

        txtTextArea.setEditable(false);
        txtTextArea.setBackground(javax.swing.UIManager.getDefaults().getColor("Panel.background"));
        txtTextArea.setColumns(20);
        txtTextArea.setLineWrap(true);
        txtTextArea.setRows(5);
        txtTextArea.setWrapStyleWord(true);
        jScrollPane1.setViewportView(txtTextArea);

        dontShowCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                dontShowCheckBoxActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 409, Short.MAX_VALUE)
                    .addComponent(dontShowCheckBox))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 86, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(dontShowCheckBox)
                .addContainerGap(21, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void dontShowCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_dontShowCheckBoxActionPerformed
        support.setCheckUpdates(!dontShowCheckBox.isSelected());
    }//GEN-LAST:event_dontShowCheckBoxActionPerformed


    // Variables declaration - do not modify//GEN-BEGIN:variables
    final javax.swing.JCheckBox dontShowCheckBox = new javax.swing.JCheckBox();
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTextArea txtTextArea;
    // End of variables declaration//GEN-END:variables

}
