/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.rabbitmq.view.cassandra;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.datastax.oss.driver.api.querybuilder.update.Update;
import com.google.common.annotations.VisibleForTesting;
import java.time.Instant;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.queue.rabbitmq.MailQueueName;
import reactor.core.publisher.Mono;

public class ContentStartDAO {
    private final CassandraAsyncExecutor executor;
    private final PreparedStatement selectOne;
    private final PreparedStatement insertOne;
    private final PreparedStatement updateOne;

    @Inject
    ContentStartDAO(CqlSession session) {
        this.executor = new CassandraAsyncExecutor(session);
        this.selectOne = session.prepare(((Select)QueryBuilder.selectFrom((String)"contentStart").all().whereColumn("queueName").isEqualTo((Term)QueryBuilder.bindMarker((String)"queueName"))).build());
        this.updateOne = session.prepare(((Update)QueryBuilder.update((String)"contentStart").setColumn("contentStart", (Term)QueryBuilder.bindMarker((String)"contentStart")).whereColumn("queueName").isEqualTo((Term)QueryBuilder.bindMarker((String)"queueName"))).build());
        this.insertOne = session.prepare(QueryBuilder.insertInto((String)"contentStart").value("contentStart", (Term)QueryBuilder.bindMarker((String)"contentStart")).value("queueName", (Term)QueryBuilder.bindMarker((String)"queueName")).ifNotExists().build());
    }

    Mono<Instant> findContentStart(MailQueueName queueName) {
        return this.selectOne(queueName).mapNotNull(row -> row.getInstant("contentStart"));
    }

    Mono<Void> updateContentStart(MailQueueName mailQueueName, Instant sliceStart) {
        return this.executor.executeVoid((Statement)((BoundStatement)this.updateOne.bind(new Object[0]).setInstant("contentStart", sliceStart)).setString("queueName", mailQueueName.asString()));
    }

    Mono<Void> insertInitialContentStart(MailQueueName mailQueueName, Instant sliceStart) {
        return this.executor.executeVoid((Statement)((BoundStatement)this.insertOne.bind(new Object[0]).setInstant("contentStart", sliceStart)).setString("queueName", mailQueueName.asString()));
    }

    @VisibleForTesting
    Mono<Row> selectOne(MailQueueName queueName) {
        return this.executor.executeSingleRow((Statement)this.selectOne.bind(new Object[0]).setString("queueName", queueName.asString()));
    }
}

