/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.stream.Stream;
import org.apache.james.jmap.draft.json.FilterDeserializer;
import org.apache.james.jmap.draft.model.FilterCondition;
import org.apache.james.jmap.draft.model.FilterOperator;

@JsonDeserialize(using=FilterDeserializer.class)
public interface Filter {
    public static final int MAX_FILTER_DEPTH = 10;

    public String prettyPrint(String var1);

    default public boolean inMailboxFilterOnly() {
        return false;
    }

    default public boolean inMailboxAndAfterFiltersOnly() {
        return false;
    }

    default public List<FilterCondition> breadthFirstVisit() {
        return (List)this.breadthFirstVisit(0).collect(ImmutableList.toImmutableList());
    }

    default public Stream<FilterCondition> breadthFirstVisit(int depth) {
        if (depth > 10) {
            throw new TooDeepFilterHierarchyException();
        }
        if (this instanceof FilterOperator) {
            FilterOperator operator = (FilterOperator)this;
            return operator.getConditions().stream().flatMap(filter -> filter.breadthFirstVisit(depth + 1));
        }
        if (this instanceof FilterCondition) {
            return Stream.of((FilterCondition)this);
        }
        throw new RuntimeException("Unsupported Filter implementation " + this);
    }

    public static class TooDeepFilterHierarchyException
    extends IllegalArgumentException {
        TooDeepFilterHierarchyException() {
            super("Filter depth is higher than maximum allowed value 10");
        }
    }
}

