/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.onami.lifecycle;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import org.apache.james.onami.lifecycle.AbstractBasicStageable;
import org.apache.james.onami.lifecycle.StageHandler;

final class StageableMethod
extends AbstractBasicStageable<Object> {
    private final Method stageMethod;

    StageableMethod(Method stageMethod, Object injectee) {
        super(injectee);
        this.stageMethod = stageMethod;
    }

    @Override
    public final void stage(StageHandler stageHandler) {
        try {
            AccessController.doPrivileged(() -> {
                this.stageMethod.setAccessible(true);
                return null;
            });
            this.stageMethod.invoke(this.object, new Object[0]);
        }
        catch (InvocationTargetException e) {
            stageHandler.onError(this.object, e.getCause());
            return;
        }
        catch (Throwable e) {
            stageHandler.onError(this.object, e);
            return;
        }
        stageHandler.onSuccess(this.object);
    }
}

