/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.adapter.mailbox;

import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.mailbox.Authenticator;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;

public class UserRepositoryAuthenticator
implements Authenticator {
    private final UsersRepository repos;

    @Inject
    public UserRepositoryAuthenticator(UsersRepository repos) {
        this.repos = repos;
    }

    public boolean isAuthentic(Username userid, CharSequence passwd) throws MailboxException {
        try {
            return this.repos.test(userid, passwd.toString());
        }
        catch (UsersRepositoryException e) {
            throw new MailboxException("Unable to access UsersRepository", (Throwable)e);
        }
    }
}

