/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mu;

import java.time.Instant;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.james.core.MailAddress;
import org.apache.james.core.MaybeSender;

public record MailReportEntry(Kind kind, String subject, MaybeSender sender, MailAddress recipient, Instant date) {

    static enum Kind {
        Sent("SENT"),
        Received("RECEIVED");

        private final String value;

        public static Optional<Kind> parse(String value) {
            return Stream.of(Kind.values()).filter(kind -> kind.asString().equals(value)).findFirst();
        }

        private Kind(String value) {
            this.value = value;
        }

        public String asString() {
            return this.value;
        }
    }
}

