/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.byteunits;

import com.jakewharton.byteunits.ByteUnit;
import com.jakewharton.byteunits.UnitUtil;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public enum BinaryByteUnit implements ByteUnit
{
    BYTES{

        @Override
        public long convert(long sourceCount, BinaryByteUnit sourceUnit) {
            return sourceUnit.toBytes(sourceCount);
        }

        @Override
        public long toBytes(long count) {
            return count;
        }

        @Override
        public long toKibibytes(long count) {
            return count / 1024L;
        }

        @Override
        public long toMebibytes(long count) {
            return count / 0x100000L;
        }

        @Override
        public long toGibibytes(long count) {
            return count / 0x40000000L;
        }

        @Override
        public long toTebibytes(long count) {
            return count / 0x10000000000L;
        }

        @Override
        public long toPebibytes(long count) {
            return count / 0x4000000000000L;
        }
    }
    ,
    KIBIBYTES{

        @Override
        public long convert(long sourceCount, BinaryByteUnit sourceUnit) {
            return sourceUnit.toKibibytes(sourceCount);
        }

        @Override
        public long toBytes(long count) {
            return UnitUtil.multiply(count, 1024L, 0x1FFFFFFFFFFFFFL);
        }

        @Override
        public long toKibibytes(long count) {
            return count;
        }

        @Override
        public long toMebibytes(long count) {
            return count / 1024L;
        }

        @Override
        public long toGibibytes(long count) {
            return count / 0x100000L;
        }

        @Override
        public long toTebibytes(long count) {
            return count / 0x40000000L;
        }

        @Override
        public long toPebibytes(long count) {
            return count / 0x10000000000L;
        }
    }
    ,
    MEBIBYTES{

        @Override
        public long convert(long sourceCount, BinaryByteUnit sourceUnit) {
            return sourceUnit.toMebibytes(sourceCount);
        }

        @Override
        public long toBytes(long count) {
            return UnitUtil.multiply(count, 0x100000L, 0x7FFFFFFFFFFL);
        }

        @Override
        public long toKibibytes(long count) {
            return UnitUtil.multiply(count, 1024L, 0x1FFFFFFFFFFFFFL);
        }

        @Override
        public long toMebibytes(long count) {
            return count;
        }

        @Override
        public long toGibibytes(long count) {
            return count / 1024L;
        }

        @Override
        public long toTebibytes(long count) {
            return count / 0x100000L;
        }

        @Override
        public long toPebibytes(long count) {
            return count / 0x40000000L;
        }
    }
    ,
    GIBIBYTES{

        @Override
        public long convert(long sourceCount, BinaryByteUnit sourceUnit) {
            return sourceUnit.toGibibytes(sourceCount);
        }

        @Override
        public long toBytes(long count) {
            return UnitUtil.multiply(count, 0x40000000L, 0x1FFFFFFFFL);
        }

        @Override
        public long toKibibytes(long count) {
            return UnitUtil.multiply(count, 0x100000L, 0x7FFFFFFFFFFL);
        }

        @Override
        public long toMebibytes(long count) {
            return UnitUtil.multiply(count, 1024L, 0x1FFFFFFFFFFFFFL);
        }

        @Override
        public long toGibibytes(long count) {
            return count;
        }

        @Override
        public long toTebibytes(long count) {
            return count / 1024L;
        }

        @Override
        public long toPebibytes(long count) {
            return count / 0x100000L;
        }
    }
    ,
    TEBIBYTES{

        @Override
        public long convert(long sourceCount, BinaryByteUnit sourceUnit) {
            return sourceUnit.toTebibytes(sourceCount);
        }

        @Override
        public long toBytes(long count) {
            return UnitUtil.multiply(count, 0x10000000000L, 0x7FFFFFL);
        }

        @Override
        public long toKibibytes(long count) {
            return UnitUtil.multiply(count, 0x40000000L, 0x1FFFFFFFFL);
        }

        @Override
        public long toMebibytes(long count) {
            return UnitUtil.multiply(count, 0x100000L, 0x7FFFFFFFFFFL);
        }

        @Override
        public long toGibibytes(long count) {
            return UnitUtil.multiply(count, 1024L, 0x1FFFFFFFFFFFFFL);
        }

        @Override
        public long toTebibytes(long count) {
            return count;
        }

        @Override
        public long toPebibytes(long count) {
            return count / 1024L;
        }
    }
    ,
    PEBIBYTES{

        @Override
        public long convert(long sourceCount, BinaryByteUnit sourceUnit) {
            return sourceUnit.toPebibytes(sourceCount);
        }

        @Override
        public long toBytes(long count) {
            return UnitUtil.multiply(count, 0x4000000000000L, 8191L);
        }

        @Override
        public long toKibibytes(long count) {
            return UnitUtil.multiply(count, 0x10000000000L, 0x7FFFFFL);
        }

        @Override
        public long toMebibytes(long count) {
            return UnitUtil.multiply(count, 0x40000000L, 0x1FFFFFFFFL);
        }

        @Override
        public long toGibibytes(long count) {
            return UnitUtil.multiply(count, 0x100000L, 0x7FFFFFFFFFFL);
        }

        @Override
        public long toTebibytes(long count) {
            return UnitUtil.multiply(count, 1024L, 0x1FFFFFFFFFFFFFL);
        }

        @Override
        public long toPebibytes(long count) {
            return count;
        }
    };

    private static final long B = 1L;
    private static final long KB = 1024L;
    private static final long MB = 0x100000L;
    private static final long GB = 0x40000000L;
    private static final long TB = 0x10000000000L;
    private static final long PB = 0x4000000000000L;
    private static final long MAX = Long.MAX_VALUE;
    private static final String[] UNITS;

    public long convert(long sourceCount, BinaryByteUnit sourceUnit) {
        throw new AbstractMethodError();
    }

    public long toKibibytes(long count) {
        throw new AbstractMethodError();
    }

    public long toMebibytes(long count) {
        throw new AbstractMethodError();
    }

    public long toGibibytes(long count) {
        throw new AbstractMethodError();
    }

    public long toTebibytes(long count) {
        throw new AbstractMethodError();
    }

    public long toPebibytes(long count) {
        throw new AbstractMethodError();
    }

    public static String format(long bytes) {
        return BinaryByteUnit.format(bytes, new DecimalFormat("#,##0.#"));
    }

    public static String format(long bytes, String pattern) {
        return BinaryByteUnit.format(bytes, new DecimalFormat(pattern));
    }

    public static String format(long bytes, NumberFormat format) {
        double count;
        if (bytes < 0L) {
            throw new IllegalArgumentException("bytes < 0: " + bytes);
        }
        int unitIndex = 0;
        for (count = (double)bytes; count >= 1024.0 && unitIndex < UNITS.length - 1; count /= 1024.0, ++unitIndex) {
        }
        return format.format(count) + ' ' + UNITS[unitIndex];
    }

    static {
        UNITS = new String[]{"B", "KiB", "MiB", "GiB", "TiB", "PiB"};
    }
}

