/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.events;

import java.util.Objects;
import javax.inject.Inject;
import org.apache.james.events.RegistrationKey;
import org.apache.james.mailbox.model.MailboxId;

public class MailboxIdRegistrationKey
implements RegistrationKey {
    private final MailboxId mailboxId;

    public MailboxIdRegistrationKey(MailboxId mailboxId) {
        this.mailboxId = mailboxId;
    }

    public MailboxId getMailboxId() {
        return this.mailboxId;
    }

    public String asString() {
        return this.mailboxId.serialize();
    }

    public final boolean equals(Object o) {
        if (o instanceof MailboxIdRegistrationKey) {
            MailboxIdRegistrationKey that = (MailboxIdRegistrationKey)o;
            return Objects.equals(this.mailboxId, that.mailboxId);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.mailboxId);
    }

    public static class Factory
    implements RegistrationKey.Factory {
        private final MailboxId.Factory mailboxIdFactory;

        @Inject
        public Factory(MailboxId.Factory mailboxIdFactory) {
            this.mailboxIdFactory = mailboxIdFactory;
        }

        public Class<? extends RegistrationKey> forClass() {
            return MailboxIdRegistrationKey.class;
        }

        public RegistrationKey fromString(String asString) {
            return new MailboxIdRegistrationKey(this.mailboxIdFactory.fromString(asString));
        }
    }
}

