/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.subtle;

import com.google.crypto.tink.PublicKeyVerify;
import com.google.crypto.tink.config.TinkFips;
import com.google.crypto.tink.subtle.Bytes;
import com.google.crypto.tink.subtle.EngineFactory;
import com.google.crypto.tink.subtle.Enums;
import com.google.crypto.tink.subtle.SubtleUtil;
import com.google.crypto.tink.subtle.Validators;
import com.google.errorprone.annotations.Immutable;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;

@Immutable
public final class RsaSsaPssVerifyJce
implements PublicKeyVerify {
    public static final TinkFips.AlgorithmFipsCompatibility FIPS = TinkFips.AlgorithmFipsCompatibility.ALGORITHM_REQUIRES_BORINGCRYPTO;
    private final RSAPublicKey publicKey;
    private final Enums.HashType sigHash;
    private final Enums.HashType mgf1Hash;
    private final int saltLength;

    public RsaSsaPssVerifyJce(RSAPublicKey pubKey, Enums.HashType sigHash, Enums.HashType mgf1Hash, int saltLength) throws GeneralSecurityException {
        if (!FIPS.isCompatible()) {
            throw new GeneralSecurityException("Can not use RSA PSS in FIPS-mode, as BoringCrypto module is not available.");
        }
        Validators.validateSignatureHash(sigHash);
        Validators.validateRsaModulusSize(pubKey.getModulus().bitLength());
        Validators.validateRsaPublicExponent(pubKey.getPublicExponent());
        this.publicKey = pubKey;
        this.sigHash = sigHash;
        this.mgf1Hash = mgf1Hash;
        this.saltLength = saltLength;
    }

    @Override
    public void verify(byte[] signature, byte[] data) throws GeneralSecurityException {
        BigInteger e = this.publicKey.getPublicExponent();
        BigInteger n = this.publicKey.getModulus();
        int nLengthInBytes = (n.bitLength() + 7) / 8;
        int mLen = (n.bitLength() - 1 + 7) / 8;
        if (nLengthInBytes != signature.length) {
            throw new GeneralSecurityException("invalid signature's length");
        }
        BigInteger s = SubtleUtil.bytes2Integer(signature);
        if (s.compareTo(n) >= 0) {
            throw new GeneralSecurityException("signature out of range");
        }
        BigInteger m = s.modPow(e, n);
        byte[] em = SubtleUtil.integer2Bytes(m, mLen);
        this.emsaPssVerify(data, em, n.bitLength() - 1);
    }

    private void emsaPssVerify(byte[] m, byte[] em, int emBits) throws GeneralSecurityException {
        int i;
        Validators.validateSignatureHash(this.sigHash);
        MessageDigest digest = EngineFactory.MESSAGE_DIGEST.getInstance(SubtleUtil.toDigestAlgo(this.sigHash));
        byte[] mHash = digest.digest(m);
        int hLen = digest.getDigestLength();
        int emLen = em.length;
        if (emLen < hLen + this.saltLength + 2) {
            throw new GeneralSecurityException("inconsistent");
        }
        if (em[em.length - 1] != -68) {
            throw new GeneralSecurityException("inconsistent");
        }
        byte[] maskedDb = Arrays.copyOf(em, emLen - hLen - 1);
        byte[] h = Arrays.copyOfRange(em, maskedDb.length, maskedDb.length + hLen);
        int i2 = 0;
        while ((long)i2 < (long)emLen * 8L - (long)emBits) {
            int bytePos = i2 / 8;
            int bitPos = 7 - i2 % 8;
            if ((maskedDb[bytePos] >> bitPos & 1) != 0) {
                throw new GeneralSecurityException("inconsistent");
            }
            ++i2;
        }
        byte[] dbMask = SubtleUtil.mgf1(h, emLen - hLen - 1, this.mgf1Hash);
        byte[] db = new byte[dbMask.length];
        for (i = 0; i < db.length; ++i) {
            db[i] = (byte)(dbMask[i] ^ maskedDb[i]);
        }
        i = 0;
        while ((long)i <= (long)emLen * 8L - (long)emBits) {
            int bytePos = i / 8;
            int bitPos = 7 - i % 8;
            db[bytePos] = (byte)(db[bytePos] & ~(1 << bitPos));
            ++i;
        }
        for (i = 0; i < emLen - hLen - this.saltLength - 2; ++i) {
            if (db[i] == 0) continue;
            throw new GeneralSecurityException("inconsistent");
        }
        if (db[emLen - hLen - this.saltLength - 2] != 1) {
            throw new GeneralSecurityException("inconsistent");
        }
        byte[] salt = Arrays.copyOfRange(db, db.length - this.saltLength, db.length);
        byte[] mPrime = new byte[8 + hLen + this.saltLength];
        System.arraycopy(mHash, 0, mPrime, 8, mHash.length);
        System.arraycopy(salt, 0, mPrime, 8 + hLen, salt.length);
        byte[] hPrime = digest.digest(mPrime);
        if (!Bytes.equal(hPrime, h)) {
            throw new GeneralSecurityException("inconsistent");
        }
    }
}

