/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailrepository.cassandra;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.mailrepository.api.MailKey;
import org.apache.james.mailrepository.api.MailRepositoryUrl;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CassandraMailRepositoryKeysDAO {
    private final CassandraAsyncExecutor executor;
    private final PreparedStatement insertKey;
    private final PreparedStatement deleteKey;
    private final PreparedStatement listKeys;

    @Inject
    public CassandraMailRepositoryKeysDAO(Session session) {
        this.executor = new CassandraAsyncExecutor(session);
        this.insertKey = this.prepareInsert(session);
        this.deleteKey = this.prepareDelete(session);
        this.listKeys = this.prepareList(session);
    }

    private PreparedStatement prepareList(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select((String[])new String[]{"mailKey"}).from("mailRepositoryKeys").where(QueryBuilder.eq((String)"name", (Object)QueryBuilder.bindMarker((String)"name"))));
    }

    private PreparedStatement prepareDelete(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.delete().from("mailRepositoryKeys").ifExists().where(QueryBuilder.eq((String)"name", (Object)QueryBuilder.bindMarker((String)"name"))).and(QueryBuilder.eq((String)"mailKey", (Object)QueryBuilder.bindMarker((String)"mailKey"))));
    }

    private PreparedStatement prepareInsert(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.insertInto((String)"mailRepositoryKeys").ifNotExists().value("name", (Object)QueryBuilder.bindMarker((String)"name")).value("mailKey", (Object)QueryBuilder.bindMarker((String)"mailKey")));
    }

    public Mono<Boolean> store(MailRepositoryUrl url, MailKey key) {
        return this.executor.executeReturnApplied((Statement)this.insertKey.bind().setString("name", url.asString()).setString("mailKey", key.asString()));
    }

    public Flux<MailKey> list(MailRepositoryUrl url) {
        return this.executor.executeRows((Statement)this.listKeys.bind().setString("name", url.asString())).map(row -> new MailKey(row.getString("mailKey")));
    }

    public Mono<Boolean> remove(MailRepositoryUrl url, MailKey key) {
        return this.executor.executeReturnApplied((Statement)this.deleteKey.bind().setString("name", url.asString()).setString("mailKey", key.asString()));
    }
}

