/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.consensus.iotv2.container;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.client.ClientPoolFactory;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.async.AsyncPipeConsensusServiceClient;
import org.apache.iotdb.commons.client.property.PipeConsensusClientProperty;
import org.apache.iotdb.commons.client.sync.SyncPipeConsensusServiceClient;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.conf.CommonConfig;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.pipe.agent.task.execution.PipeSubtaskExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTV2GlobalComponentContainer {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoTV2GlobalComponentContainer.class);
    private static final CommonConfig CONF = CommonDescriptor.getInstance().getConfig();
    private final PipeConsensusClientProperty config = PipeConsensusClientProperty.newBuilder().setIsRpcThriftCompressionEnabled(CONF.isRpcThriftCompressionEnabled()).setMaxClientNumForEachNode(CONF.getMaxClientNumForEachNode()).setSelectorNumOfClientManager(Math.max(3, CONF.getSelectorNumOfClientManager())).build();
    private final IClientManager<TEndPoint, AsyncPipeConsensusServiceClient> asyncClientManager = new IClientManager.Factory<TEndPoint, AsyncPipeConsensusServiceClient>().createClientManager(new ClientPoolFactory.AsyncPipeConsensusServiceClientPoolFactory(this.config));
    private final IClientManager<TEndPoint, SyncPipeConsensusServiceClient> syncClientManager = new IClientManager.Factory<TEndPoint, SyncPipeConsensusServiceClient>().createClientManager(new ClientPoolFactory.SyncPipeConsensusServiceClientPoolFactory(this.config));
    private final ScheduledExecutorService backgroundTaskService = IoTDBThreadPoolFactory.newSingleThreadScheduledExecutor(ThreadName.PIPE_CONSENSUS_BACKGROUND_TASK_EXECUTOR.getName());
    private PipeSubtaskExecutor consensusExecutor;

    private IoTV2GlobalComponentContainer() {
    }

    public IClientManager<TEndPoint, AsyncPipeConsensusServiceClient> getGlobalAsyncClientManager() {
        return this.asyncClientManager;
    }

    public IClientManager<TEndPoint, SyncPipeConsensusServiceClient> getGlobalSyncClientManager() {
        return this.syncClientManager;
    }

    public ScheduledExecutorService getBackgroundTaskService() {
        return this.backgroundTaskService;
    }

    public void stopBackgroundTaskService() {
        this.backgroundTaskService.shutdownNow();
        try {
            if (!this.backgroundTaskService.awaitTermination(30L, TimeUnit.SECONDS)) {
                LOGGER.warn("IoTV2 background service did not terminate within {}s", (Object)30);
            }
        }
        catch (InterruptedException e) {
            LOGGER.warn("IoTV2 background Thread still doesn't exit after 30s");
            Thread.currentThread().interrupt();
        }
    }

    public PipeSubtaskExecutor getConsensusExecutor() {
        return this.consensusExecutor;
    }

    public void setConsensusExecutor(PipeSubtaskExecutor consensusExecutor) {
        this.consensusExecutor = consensusExecutor;
    }

    public static IoTV2GlobalComponentContainer getInstance() {
        if (IoTV2GlobalComponentContainerHolder.INSTANCE == null) {
            IoTV2GlobalComponentContainer.build();
        }
        return IoTV2GlobalComponentContainerHolder.INSTANCE;
    }

    public static void build() {
        IoTV2GlobalComponentContainerHolder.build();
    }

    private static class IoTV2GlobalComponentContainerHolder {
        private static IoTV2GlobalComponentContainer INSTANCE;

        private IoTV2GlobalComponentContainerHolder() {
        }

        public static void build() {
            if (INSTANCE == null) {
                INSTANCE = new IoTV2GlobalComponentContainer();
            }
        }
    }
}

