/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.wal.recover.file;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.db.exception.DataRegionException;
import org.apache.iotdb.db.pipe.agent.PipeDataNodeAgent;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.DeleteDataNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowsNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.RelationalDeleteDataNode;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.TableSchema;
import org.apache.iotdb.db.schemaengine.table.DataNodeTableCache;
import org.apache.iotdb.db.storageengine.dataregion.flush.CompressionRatio;
import org.apache.iotdb.db.storageengine.dataregion.flush.MemTableFlushTask;
import org.apache.iotdb.db.storageengine.dataregion.memtable.IMemTable;
import org.apache.iotdb.db.storageengine.dataregion.memtable.IWritableMemChunk;
import org.apache.iotdb.db.storageengine.dataregion.memtable.IWritableMemChunkGroup;
import org.apache.iotdb.db.storageengine.dataregion.modification.DeletionPredicate;
import org.apache.iotdb.db.storageengine.dataregion.modification.IDPredicate;
import org.apache.iotdb.db.storageengine.dataregion.modification.ModEntry;
import org.apache.iotdb.db.storageengine.dataregion.modification.TableDeletionEntry;
import org.apache.iotdb.db.storageengine.dataregion.modification.TreeDeletionEntry;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.FileTimeIndexCacheRecorder;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.WALEntry;
import org.apache.iotdb.db.storageengine.dataregion.wal.exception.WALRecoverException;
import org.apache.iotdb.db.storageengine.dataregion.wal.recover.file.AbstractTsFileRecoverPerformer;
import org.apache.iotdb.db.storageengine.dataregion.wal.recover.file.TsFilePlanRedoer;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.listener.WALRecoverListener;
import org.apache.tsfile.file.metadata.ChunkMetadata;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.read.common.TimeRange;
import org.apache.tsfile.write.writer.RestorableTsFileIOWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnsealedTsFileRecoverPerformer
extends AbstractTsFileRecoverPerformer {
    private static final Logger logger = LoggerFactory.getLogger(UnsealedTsFileRecoverPerformer.class);
    private final boolean sequence;
    private final Consumer<UnsealedTsFileRecoverPerformer> callbackAfterUnsealedTsFileRecovered;
    private final TsFilePlanRedoer walRedoer;
    private final WALRecoverListener recoverListener;
    private final String databaseName;
    private final String dataRegionId;

    public UnsealedTsFileRecoverPerformer(TsFileResource tsFileResource, boolean sequence, Consumer<UnsealedTsFileRecoverPerformer> callbackAfterUnsealedTsFileRecovered) {
        super(tsFileResource);
        this.databaseName = tsFileResource.getDatabaseName();
        this.dataRegionId = tsFileResource.getDataRegionId();
        this.sequence = sequence;
        this.callbackAfterUnsealedTsFileRecovered = callbackAfterUnsealedTsFileRecovered;
        this.walRedoer = new TsFilePlanRedoer(tsFileResource);
        this.recoverListener = new WALRecoverListener(tsFileResource.getTsFilePath());
    }

    public void startRecovery() throws DataRegionException, IOException {
        super.recoverWithWriter();
        if (this.hasCrashed()) {
            this.constructResourceFromTsFile();
        }
    }

    private void constructResourceFromTsFile() {
        Collection<ModEntry> modificationsForResource = this.tsFileResource.getAllModEntries();
        Map deviceChunkMetaDataMap = this.writer.getDeviceChunkMetadataMap();
        for (Map.Entry entry : deviceChunkMetaDataMap.entrySet()) {
            IDeviceID deviceId = (IDeviceID)entry.getKey();
            List chunkMetadataList = (List)entry.getValue();
            HashMap<String, List> measurementToChunkMetadatas = new HashMap<String, List>();
            for (ChunkMetadata chunkMetadata : chunkMetadataList) {
                List list = measurementToChunkMetadatas.computeIfAbsent(chunkMetadata.getMeasurementUid(), n -> new ArrayList());
                list.add(chunkMetadata);
            }
            for (ChunkMetadata chunkMetaData : chunkMetadataList) {
                long startTime = chunkMetaData.getStartTime();
                long endTime = chunkMetaData.getEndTime();
                for (ModEntry modification : modificationsForResource) {
                    if (!modification.affects(deviceId, startTime, endTime) || !modification.affects(chunkMetaData.getMeasurementUid())) continue;
                    long modsStartTime = modification.getStartTime();
                    long modsEndTime = modification.getEndTime();
                    if (startTime >= modsStartTime && endTime <= modsEndTime) {
                        startTime = Long.MAX_VALUE;
                        endTime = Long.MIN_VALUE;
                        continue;
                    }
                    if (startTime >= modsStartTime && startTime <= modsEndTime) {
                        startTime = modsEndTime + 1L;
                        continue;
                    }
                    if (endTime < modsStartTime || endTime > modsEndTime) continue;
                    endTime = modsStartTime - 1L;
                }
                this.tsFileResource.updateStartTime(deviceId, startTime);
                this.tsFileResource.updateEndTime(deviceId, endTime);
            }
        }
        this.tsFileResource.updatePlanIndexes(this.writer.getMinPlanIndex());
        this.tsFileResource.updatePlanIndexes(this.writer.getMaxPlanIndex());
    }

    public void redoLog(WALEntry walEntry) {
        block16: {
            if (!this.hasCrashed()) {
                logger.info("This TsFile {} isn't crashed, no need to redo wal log.", (Object)this.tsFileResource.getTsFilePath());
                return;
            }
            try {
                switch (walEntry.getType()) {
                    case MEMORY_TABLE_SNAPSHOT: 
                    case OLD_MEMORY_TABLE_SNAPSHOT: {
                        IMemTable memTable = (IMemTable)walEntry.getValue();
                        if (!memTable.isSignalMemTable()) {
                            if (this.tsFileResource != null) {
                                for (IDeviceID device : this.tsFileResource.getDevices()) {
                                    if (device.isTableModel()) {
                                        memTable.delete(new TableDeletionEntry(new DeletionPredicate(device.getTableName(), new IDPredicate.FullExactMatch(device)), new TimeRange(this.tsFileResource.getStartTime(device).get().longValue(), this.tsFileResource.getEndTime(device).get().longValue())));
                                        continue;
                                    }
                                    memTable.delete(new TreeDeletionEntry(new MeasurementPath(device, "*"), this.tsFileResource.getStartTime(device).get(), this.tsFileResource.getEndTime(device).get()));
                                }
                            }
                            for (IDeviceID deviceID : memTable.getMemTableMap().keySet()) {
                                if (!deviceID.isTableModel()) continue;
                                this.registerToTsFile(deviceID.getTableName());
                            }
                            this.walRedoer.resetRecoveryMemTable(memTable);
                        }
                        memTable.setDatabaseAndDataRegionId(this.databaseName, this.dataRegionId);
                        break;
                    }
                    case INSERT_ROW_NODE: 
                    case INSERT_TABLET_NODE: {
                        this.registerToTsFile(((InsertNode)((Object)walEntry.getValue())).getTableName());
                        this.walRedoer.redoInsert((InsertNode)((Object)walEntry.getValue()));
                        break;
                    }
                    case INSERT_ROWS_NODE: {
                        this.registerToTsFile(((InsertRowsNode)walEntry.getValue()).getTableName());
                        this.walRedoer.redoInsertRows((InsertRowsNode)walEntry.getValue());
                        break;
                    }
                    case DELETE_DATA_NODE: {
                        this.walRedoer.redoDelete((DeleteDataNode)walEntry.getValue());
                        break;
                    }
                    case RELATIONAL_DELETE_DATA_NODE: {
                        this.walRedoer.redoDelete((RelationalDeleteDataNode)walEntry.getValue());
                        break;
                    }
                    case CONTINUOUS_SAME_SEARCH_INDEX_SEPARATOR_NODE: {
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unsupported type " + (Object)((Object)walEntry.getType()));
                    }
                }
            }
            catch (Exception e) {
                if (this.tsFileResource == null) break block16;
                logger.warn("meet error when redo wal of {}", (Object)this.tsFileResource.getTsFile(), (Object)e);
            }
        }
    }

    private void registerToTsFile(String tableName) {
        if (tableName != null) {
            this.writer.getSchema().getTableSchemaMap().computeIfAbsent(tableName, t -> TableSchema.of(DataNodeTableCache.getInstance().getTable(this.databaseName, (String)t)).toTsFileTableSchemaNoAttribute());
        }
    }

    public void endRecovery() throws WALRecoverException {
        if (this.hasCrashed()) {
            IMemTable recoveryMemTable = this.walRedoer.getRecoveryMemTable();
            Map<IDeviceID, IWritableMemChunkGroup> memTableMap = recoveryMemTable.getMemTableMap();
            for (Map.Entry<IDeviceID, IWritableMemChunkGroup> deviceEntry : memTableMap.entrySet()) {
                IDeviceID deviceId = deviceEntry.getKey();
                for (Map.Entry<String, IWritableMemChunk> measurementEntry : deviceEntry.getValue().getMemChunkMap().entrySet()) {
                    IWritableMemChunk memChunk = measurementEntry.getValue();
                    this.tsFileResource.updateStartTime(deviceId, memChunk.getFirstPoint());
                    this.tsFileResource.updateEndTime(deviceId, memChunk.getLastPoint());
                }
            }
            try {
                if (!recoveryMemTable.isEmpty() && recoveryMemTable.getSeriesNumber() != 0) {
                    MemTableFlushTask tableFlushTask = new MemTableFlushTask(recoveryMemTable, this.writer, this.databaseName + "-" + this.dataRegionId, this.dataRegionId);
                    tableFlushTask.syncFlushMemTable();
                    this.tsFileResource.updatePlanIndexes(recoveryMemTable.getMinPlanIndex());
                    this.tsFileResource.updatePlanIndexes(recoveryMemTable.getMaxPlanIndex());
                }
                PipeDataNodeAgent.runtime().assignProgressIndexForTsFileRecovery(this.tsFileResource);
                try {
                    long memTableSize = recoveryMemTable.memSize();
                    double compressionRatio = (double)memTableSize / (double)this.writer.getPos();
                    logger.info("The compression ratio of tsfile {} is {}, totalMemTableSize: {}, the file size: {}", new Object[]{this.writer.getFile().getAbsolutePath(), String.format("%.2f", compressionRatio), memTableSize, this.writer.getPos()});
                    CompressionRatio.getInstance().updateRatio(memTableSize, this.writer.getPos(), this.dataRegionId);
                }
                catch (IOException e) {
                    logger.error("{}: {} update compression ratio failed", new Object[]{this.databaseName, this.tsFileResource.getTsFile().getName(), e});
                }
                this.writer.endFile();
                this.tsFileResource.serialize();
                FileTimeIndexCacheRecorder.getInstance().logFileTimeIndex(this.tsFileResource);
            }
            catch (IOException | ExecutionException e) {
                throw new WALRecoverException(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new WALRecoverException(e);
            }
        }
        this.callbackAfterUnsealedTsFileRecovered.accept(this);
    }

    public TsFileResource getTsFileResource() {
        return this.tsFileResource;
    }

    public RestorableTsFileIOWriter getWriter() {
        return this.writer;
    }

    public boolean isSequence() {
        return this.sequence;
    }

    public WALRecoverListener getRecoverListener() {
        return this.recoverListener;
    }

    public String getTsFileAbsolutePath() {
        return this.tsFileResource.getTsFile().getAbsolutePath();
    }
}

