/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.udf.utils;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.udf.api.type.Type;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.type.BinaryType;
import org.apache.tsfile.read.common.type.BlobType;
import org.apache.tsfile.read.common.type.BooleanType;
import org.apache.tsfile.read.common.type.DateType;
import org.apache.tsfile.read.common.type.DoubleType;
import org.apache.tsfile.read.common.type.FloatType;
import org.apache.tsfile.read.common.type.IntType;
import org.apache.tsfile.read.common.type.LongType;
import org.apache.tsfile.read.common.type.StringType;
import org.apache.tsfile.read.common.type.TimestampType;

public class UDFDataTypeTransformer {
    private UDFDataTypeTransformer() {
    }

    public static TSDataType transformToTsDataType(Type type) {
        return type == null ? null : TSDataType.getTsDataType((byte)type.getType());
    }

    public static Type transformToUDFDataType(TSDataType tsDataType) {
        return tsDataType == null ? null : UDFDataTypeTransformer.getUDFDataType(tsDataType.getType());
    }

    public static List<Type> transformToUDFDataTypeList(List<TSDataType> tsDataTypeList) {
        return tsDataTypeList == null ? null : tsDataTypeList.stream().map(UDFDataTypeTransformer::transformToUDFDataType).collect(Collectors.toList());
    }

    public static Type transformReadTypeToUDFDataType(org.apache.tsfile.read.common.type.Type type) {
        if (type == null) {
            return null;
        }
        switch (type.getTypeEnum()) {
            case BOOLEAN: {
                return Type.BOOLEAN;
            }
            case INT32: {
                return Type.INT32;
            }
            case INT64: {
                return Type.INT64;
            }
            case FLOAT: {
                return Type.FLOAT;
            }
            case DOUBLE: {
                return Type.DOUBLE;
            }
            case TEXT: {
                return Type.TEXT;
            }
            case TIMESTAMP: {
                return Type.TIMESTAMP;
            }
            case DATE: {
                return Type.DATE;
            }
            case BLOB: {
                return Type.BLOB;
            }
            case STRING: {
                return Type.STRING;
            }
        }
        throw new IllegalArgumentException("Invalid input: " + type);
    }

    public static org.apache.tsfile.read.common.type.Type transformUDFDataTypeToReadType(Type type) {
        if (type == null) {
            return null;
        }
        switch (type) {
            case BOOLEAN: {
                return BooleanType.BOOLEAN;
            }
            case INT32: {
                return IntType.INT32;
            }
            case DATE: {
                return DateType.DATE;
            }
            case INT64: {
                return LongType.INT64;
            }
            case TIMESTAMP: {
                return TimestampType.TIMESTAMP;
            }
            case FLOAT: {
                return FloatType.FLOAT;
            }
            case DOUBLE: {
                return DoubleType.DOUBLE;
            }
            case TEXT: {
                return BinaryType.TEXT;
            }
            case BLOB: {
                return BlobType.BLOB;
            }
            case STRING: {
                return StringType.STRING;
            }
        }
        throw new IllegalArgumentException("Invalid input: " + type);
    }

    private static Type getUDFDataType(byte type) {
        switch (type) {
            case 0: {
                return Type.BOOLEAN;
            }
            case 1: {
                return Type.INT32;
            }
            case 2: {
                return Type.INT64;
            }
            case 3: {
                return Type.FLOAT;
            }
            case 4: {
                return Type.DOUBLE;
            }
            case 5: {
                return Type.TEXT;
            }
            case 8: {
                return Type.TIMESTAMP;
            }
            case 9: {
                return Type.DATE;
            }
            case 10: {
                return Type.BLOB;
            }
            case 11: {
                return Type.STRING;
            }
        }
        throw new IllegalArgumentException("Invalid input: " + type);
    }
}

