/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.common.header;

import com.google.common.primitives.Bytes;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.commons.schema.column.ColumnHeader;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.OutputNode;
import org.apache.tsfile.enums.TSDataType;

public class DatasetHeader {
    public static final DatasetHeader EMPTY_HEADER = new DatasetHeader(new ArrayList<ColumnHeader>(), false);
    private final List<ColumnHeader> columnHeaders;
    private final boolean isIgnoreTimestamp;
    private Map<String, Integer> columnToTsBlockIndexMap;
    private List<Integer> columnIndex2TsBlockColumnIndexList;
    private List<String> respColumns;
    private List<TSDataType> respDataTypes;
    private List<String> respDataTypeList;
    private List<Byte> respAliasColumns;
    private Map<String, Integer> columnNameIndexMap;
    private Integer outputValueColumnCount;

    public DatasetHeader(List<ColumnHeader> columnHeaders, boolean isIgnoreTimestamp) {
        this.columnHeaders = columnHeaders;
        this.isIgnoreTimestamp = isIgnoreTimestamp;
        int size = columnHeaders.size();
        this.columnIndex2TsBlockColumnIndexList = new ArrayList<Integer>(size);
        for (int i = 0; i < size; ++i) {
            this.columnIndex2TsBlockColumnIndexList.add(i);
        }
    }

    public List<ColumnHeader> getColumnHeaders() {
        return this.columnHeaders;
    }

    public boolean isIgnoreTimestamp() {
        return this.isIgnoreTimestamp;
    }

    public void setTreeColumnToTsBlockIndexMap(List<String> outputColumnNames) {
        this.columnToTsBlockIndexMap = new HashMap<String, Integer>(outputColumnNames.size());
        for (int i = 0; i < outputColumnNames.size(); ++i) {
            this.columnToTsBlockIndexMap.put(outputColumnNames.get(i), i);
        }
        this.columnIndex2TsBlockColumnIndexList = new ArrayList<Integer>(this.columnHeaders.size());
        for (ColumnHeader columnHeader : this.columnHeaders) {
            this.columnIndex2TsBlockColumnIndexList.add(this.columnToTsBlockIndexMap.get(columnHeader.getColumnName()));
        }
    }

    public void setTableColumnToTsBlockIndexMap(OutputNode outputNode) {
        int i;
        List<Symbol> childOutputSymbols = outputNode.getChild().getOutputSymbols();
        HashMap<Symbol, Integer> outputSymbolsIndexMap = new HashMap<Symbol, Integer>(childOutputSymbols.size());
        for (i = 0; i < childOutputSymbols.size(); ++i) {
            outputSymbolsIndexMap.put(childOutputSymbols.get(i), i);
        }
        this.columnToTsBlockIndexMap = new HashMap<String, Integer>();
        this.columnIndex2TsBlockColumnIndexList = new ArrayList<Integer>(outputNode.getOutputColumnNames().size());
        for (i = 0; i < outputNode.getOutputColumnNames().size(); ++i) {
            int index = (Integer)outputSymbolsIndexMap.get(outputNode.getOutputSymbols().get(i));
            this.columnToTsBlockIndexMap.put(outputNode.getOutputColumnNames().get(i), index);
            this.columnIndex2TsBlockColumnIndexList.add(index);
        }
    }

    public List<String> getRespColumns() {
        if (this.respColumns == null) {
            this.respColumns = new ArrayList<String>();
            for (ColumnHeader columnHeader : this.columnHeaders) {
                this.respColumns.add(columnHeader.getColumnNameWithAlias());
            }
        }
        return this.respColumns;
    }

    public List<TSDataType> getRespDataTypes() {
        if (this.respDataTypes == null) {
            this.respDataTypes = new ArrayList<TSDataType>();
            for (ColumnHeader columnHeader : this.columnHeaders) {
                this.respDataTypes.add(columnHeader.getColumnType());
            }
        }
        return this.respDataTypes;
    }

    public List<String> getRespDataTypeList() {
        if (this.respDataTypeList == null) {
            this.respDataTypeList = new ArrayList<String>();
            for (ColumnHeader columnHeader : this.columnHeaders) {
                this.respDataTypeList.add(columnHeader.getColumnType().toString());
            }
        }
        return this.respDataTypeList;
    }

    public List<Byte> getRespAliasColumns() {
        if (this.respAliasColumns == null) {
            BitSet aliasMap = new BitSet();
            for (int i = 0; i < this.columnHeaders.size(); ++i) {
                if (!this.columnHeaders.get(i).hasAlias()) continue;
                aliasMap.set(i);
            }
            this.respAliasColumns = new ArrayList<Byte>(Bytes.asList((byte[])aliasMap.toByteArray()));
        }
        return this.respAliasColumns;
    }

    public Map<String, Integer> getColumnNameIndexMap() {
        if (this.columnToTsBlockIndexMap == null || this.columnToTsBlockIndexMap.isEmpty()) {
            return this.columnToTsBlockIndexMap;
        }
        if (this.columnNameIndexMap == null) {
            this.columnNameIndexMap = new HashMap<String, Integer>();
            for (ColumnHeader columnHeader : this.columnHeaders) {
                this.columnNameIndexMap.put(columnHeader.getColumnNameWithAlias(), this.columnToTsBlockIndexMap.get(columnHeader.getColumnName()));
            }
        }
        return this.columnNameIndexMap;
    }

    public int getOutputValueColumnCount() {
        if (this.outputValueColumnCount == null) {
            HashSet<String> columnNameSet = new HashSet<String>();
            for (ColumnHeader columnHeader : this.columnHeaders) {
                columnNameSet.add(columnHeader.getColumnName());
            }
            this.outputValueColumnCount = columnNameSet.size();
        }
        return this.outputValueColumnCount;
    }

    public List<Integer> getColumnIndex2TsBlockColumnIndexList() {
        return this.columnIndex2TsBlockColumnIndexList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatasetHeader that = (DatasetHeader)o;
        return this.isIgnoreTimestamp == that.isIgnoreTimestamp && this.columnHeaders.equals(that.columnHeaders);
    }

    public int hashCode() {
        return Objects.hash(this.columnHeaders, this.isIgnoreTimestamp);
    }
}

