/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.rescon.disk.strategy;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.commons.utils.JVMCommonUtils;
import org.apache.iotdb.db.exception.DiskSpaceInsufficientException;
import org.apache.iotdb.db.storageengine.rescon.disk.strategy.DirectoryStrategy;
import org.apache.tsfile.fileSystem.FSFactoryProducer;

public class SequenceStrategy
extends DirectoryStrategy {
    private static final long PRINT_INTERVAL_MS = 3600000L;
    private int currentIndex;
    private Map<Integer, Long> dirLastPrintTimeMap = new ConcurrentHashMap<Integer, Long>();

    @Override
    public void setFolders(List<String> folders) throws DiskSpaceInsufficientException {
        super.setFolders(folders);
        this.currentIndex = -1;
        for (int i = 0; i < folders.size(); ++i) {
            if (!JVMCommonUtils.hasSpace((String)folders.get(i))) continue;
            this.currentIndex = i;
            break;
        }
    }

    @Override
    public int nextFolderIndex() throws DiskSpaceInsufficientException {
        int index = this.currentIndex;
        this.currentIndex = this.tryGetNextIndex(index);
        return index;
    }

    private int tryGetNextIndex(int start) throws DiskSpaceInsufficientException {
        int index = (start + 1) % this.folders.size();
        String dir = (String)this.folders.get(index);
        while (this.isUnavailableFolder(dir) || !JVMCommonUtils.hasSpace((String)dir)) {
            File dirFile = FSFactoryProducer.getFSFactory().getFile(dir);
            Long lastPrintTime = this.dirLastPrintTimeMap.computeIfAbsent(index, i -> -1L);
            if (System.currentTimeMillis() - lastPrintTime > 3600000L) {
                long freeSpace = dirFile.getFreeSpace();
                long totalSpace = dirFile.getTotalSpace();
                LOGGER.warn("{} is above the warning threshold, or not accessible, free space {}, total space {}", new Object[]{dir, freeSpace, totalSpace});
                this.dirLastPrintTimeMap.put(index, System.currentTimeMillis());
            }
            if (index == start) {
                throw new DiskSpaceInsufficientException(this.folders);
            }
            index = (index + 1) % this.folders.size();
            dir = (String)this.folders.get(index);
        }
        return index;
    }
}

