/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.QualifiedName;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Statement;

public class ShowIndex
extends Statement {
    private final QualifiedName tableName;

    public ShowIndex(QualifiedName tableName) {
        super(null);
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
    }

    public ShowIndex(NodeLocation location, QualifiedName tableName) {
        super(Objects.requireNonNull(location, "location is null"));
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
    }

    public QualifiedName getTableName() {
        return this.tableName;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitShowIndex(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShowIndex showIndex = (ShowIndex)o;
        return Objects.equals(this.tableName, showIndex.tableName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.tableName);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("tableName", (Object)this.tableName).toString();
    }
}

