/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.node.write;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnCategory;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.pipe.resource.memory.InsertNodeMemoryEstimator;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.DataNodeDevicePathCache;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.SearchNode;
import org.apache.iotdb.db.storageengine.dataregion.memtable.DeviceIDFactory;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.IWALByteBufferView;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.WALWriteUtils;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.exception.NotImplementedException;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.apache.tsfile.write.schema.MeasurementSchema;

public abstract class InsertNode
extends SearchNode {
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    protected PartialPath targetPath;
    protected boolean isAligned;
    protected MeasurementSchema[] measurementSchemas;
    protected String[] measurements;
    protected TSDataType[] dataTypes;
    protected TsTableColumnCategory[] columnCategories;
    protected List<Integer> idColumnIndices;
    protected int measurementColumnCnt = -1;
    protected int failedMeasurementNumber = 0;
    protected IDeviceID deviceID;
    protected boolean isGeneratedByRemoteConsensusLeader = false;
    protected TRegionReplicaSet dataRegionReplicaSet;
    protected ProgressIndex progressIndex;
    protected long memorySize;
    private static final DeviceIDFactory deviceIDFactory = DeviceIDFactory.getInstance();

    protected InsertNode(PlanNodeId id) {
        super(id);
    }

    @Override
    public final SearchNode merge(List<SearchNode> searchNodes) {
        if (searchNodes.isEmpty()) {
            throw new IllegalArgumentException("insertNodes should never be empty");
        }
        if (searchNodes.size() == 1) {
            return searchNodes.get(0);
        }
        List<InsertNode> insertNodes = searchNodes.stream().map(searchNode -> (InsertNode)searchNode).collect(Collectors.toList());
        InsertNode result = this.mergeInsertNode(insertNodes);
        result.setSearchIndex(insertNodes.get(0).getSearchIndex());
        result.setTargetPath(insertNodes.get(0).getTargetPath());
        return result;
    }

    public abstract InsertNode mergeInsertNode(List<InsertNode> var1);

    protected InsertNode(PlanNodeId id, PartialPath devicePath, boolean isAligned, String[] measurements, TSDataType[] dataTypes) {
        this(id, devicePath, isAligned, measurements, dataTypes, null);
    }

    protected InsertNode(PlanNodeId id, PartialPath devicePath, boolean isAligned, String[] measurements, TSDataType[] dataTypes, TsTableColumnCategory[] columnCategories) {
        super(id);
        this.targetPath = devicePath;
        this.isAligned = isAligned;
        this.measurements = measurements;
        this.dataTypes = dataTypes;
        this.setColumnCategories(columnCategories);
    }

    public TRegionReplicaSet getDataRegionReplicaSet() {
        return this.dataRegionReplicaSet;
    }

    public void setDataRegionReplicaSet(TRegionReplicaSet dataRegionReplicaSet) {
        this.dataRegionReplicaSet = dataRegionReplicaSet;
    }

    public PartialPath getTargetPath() {
        return this.targetPath;
    }

    public void setTargetPath(PartialPath targetPath) {
        this.targetPath = targetPath;
    }

    public boolean isAligned() {
        return this.isAligned;
    }

    public void setAligned(boolean aligned) {
        this.isAligned = aligned;
    }

    public MeasurementSchema[] getMeasurementSchemas() {
        return this.measurementSchemas;
    }

    public void setMeasurementSchemas(MeasurementSchema[] measurementSchemas) {
        this.measurementSchemas = measurementSchemas;
    }

    public String[] getMeasurements() {
        return this.measurements;
    }

    public int measureColumnCnt() {
        if (this.columnCategories == null) {
            return this.measurements.length;
        }
        return (int)Arrays.stream(this.columnCategories).filter(col -> col == TsTableColumnCategory.FIELD).count();
    }

    public boolean isValidMeasurement(int i) {
        return this.measurementSchemas != null && this.measurementSchemas[i] != null && (this.columnCategories == null || this.columnCategories[i] == TsTableColumnCategory.FIELD);
    }

    public void setMeasurements(String[] measurements) {
        this.measurements = measurements;
    }

    public TSDataType[] getDataTypes() {
        return this.dataTypes;
    }

    public int getMeasurementColumnCnt() {
        if (this.measurementColumnCnt == -1) {
            this.measurementColumnCnt = 0;
            if (this.measurementSchemas != null) {
                for (int i = 0; i < this.measurementSchemas.length; ++i) {
                    if (!this.isValidMeasurement(i)) continue;
                    ++this.measurementColumnCnt;
                }
            }
        }
        return this.measurementColumnCnt;
    }

    public TSDataType getDataType(int index) {
        return this.dataTypes[index];
    }

    public void setDataTypes(TSDataType[] dataTypes) {
        this.dataTypes = dataTypes;
    }

    public IDeviceID getDeviceID() {
        if (this.deviceID == null) {
            this.deviceID = deviceIDFactory.getDeviceID(this.targetPath);
        }
        return this.deviceID;
    }

    public void setDeviceID(IDeviceID deviceID) {
        this.deviceID = deviceID;
    }

    public boolean isDeviceIDExists() {
        return this.deviceID != null;
    }

    public boolean isGeneratedByRemoteConsensusLeader() {
        switch (config.getDataRegionConsensusProtocolClass()) {
            case "org.apache.iotdb.consensus.iot.IoTConsensus": 
            case "org.apache.iotdb.consensus.iot.IoTConsensusV2": 
            case "org.apache.iotdb.consensus.ratis.RatisConsensus": {
                return this.isGeneratedByRemoteConsensusLeader;
            }
            case "org.apache.iotdb.consensus.simple.SimpleConsensus": {
                return false;
            }
        }
        return false;
    }

    public void markAsGeneratedByRemoteConsensusLeader() {
        this.isGeneratedByRemoteConsensusLeader = true;
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        throw new NotImplementedException("serializeAttributes of InsertNode is not implemented");
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        throw new NotImplementedException("serializeAttributes of InsertNode is not implemented");
    }

    protected int serializeMeasurementSchemasSize() {
        int byteLen = 0;
        for (int i = 0; i < this.measurements.length; ++i) {
            if (this.measurements[i] == null) continue;
            byteLen += WALWriteUtils.sizeToWrite(this.measurementSchemas[i]);
        }
        return byteLen;
    }

    protected void serializeMeasurementSchemasToWAL(IWALByteBufferView buffer) {
        for (int i = 0; i < this.measurements.length; ++i) {
            if (this.measurements[i] == null) continue;
            WALWriteUtils.write(this.measurementSchemas[i], buffer);
        }
    }

    protected void deserializeMeasurementSchemas(DataInputStream stream) throws IOException {
        for (int i = 0; i < this.measurements.length; ++i) {
            this.measurementSchemas[i] = MeasurementSchema.deserializeFrom((InputStream)stream);
            this.measurements[i] = this.measurementSchemas[i].getMeasurementName();
            this.dataTypes[i] = this.measurementSchemas[i].getType();
        }
    }

    protected void deserializeMeasurementSchemas(ByteBuffer buffer) {
        for (int i = 0; i < this.measurements.length; ++i) {
            this.measurementSchemas[i] = MeasurementSchema.deserializeFrom((ByteBuffer)buffer);
            this.measurements[i] = this.measurementSchemas[i].getMeasurementName();
        }
    }

    @Override
    public TRegionReplicaSet getRegionReplicaSet() {
        return this.dataRegionReplicaSet;
    }

    public abstract long getMinTime();

    public void markFailedMeasurement(int index) {
        throw new UnsupportedOperationException();
    }

    public boolean hasValidMeasurements() {
        for (String o : this.measurements) {
            if (o == null) continue;
            return true;
        }
        return false;
    }

    public void setFailedMeasurementNumber(int failedMeasurementNumber) {
        this.failedMeasurementNumber = failedMeasurementNumber;
    }

    public int getFailedMeasurementNumber() {
        return this.failedMeasurementNumber;
    }

    public boolean allMeasurementFailed() {
        if (this.measurements != null) {
            return this.failedMeasurementNumber >= this.measurements.length - (this.idColumnIndices == null ? 0 : this.idColumnIndices.size());
        }
        return true;
    }

    public ProgressIndex getProgressIndex() {
        return this.progressIndex;
    }

    public void setProgressIndex(ProgressIndex progressIndex) {
        this.progressIndex = progressIndex;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InsertNode that = (InsertNode)o;
        return this.isAligned == that.isAligned && Objects.equals(this.targetPath, that.targetPath) && Arrays.equals(this.measurementSchemas, that.measurementSchemas) && Arrays.equals(this.measurements, that.measurements) && Arrays.equals(this.dataTypes, that.dataTypes) && Objects.equals(this.deviceID, that.deviceID) && Objects.equals(this.dataRegionReplicaSet, that.dataRegionReplicaSet);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(super.hashCode(), this.targetPath, this.isAligned, this.deviceID, this.dataRegionReplicaSet);
        result = 31 * result + Arrays.hashCode(this.measurementSchemas);
        result = 31 * result + Arrays.hashCode(this.measurements);
        result = 31 * result + Arrays.hashCode(this.dataTypes);
        return result;
    }

    public TsTableColumnCategory[] getColumnCategories() {
        return this.columnCategories;
    }

    public void setColumnCategories(TsTableColumnCategory[] columnCategories) {
        this.columnCategories = columnCategories;
        if (columnCategories != null) {
            this.idColumnIndices = new ArrayList<Integer>();
            for (int i = 0; i < columnCategories.length; ++i) {
                if (!columnCategories[i].equals((Object)TsTableColumnCategory.TAG)) continue;
                this.idColumnIndices.add(i);
            }
        }
    }

    public String getTableName() {
        return null;
    }

    @Override
    public List<PlanNode> getChildren() {
        return Collections.emptyList();
    }

    public String[] getRawMeasurements() {
        String[] measurements = this.getMeasurements();
        MeasurementSchema[] measurementSchemas = this.getMeasurementSchemas();
        String[] rawMeasurements = new String[measurements.length];
        for (int i = 0; i < measurements.length; ++i) {
            rawMeasurements[i] = measurementSchemas[i] != null ? measurementSchemas[i].getMeasurementName() : measurements[i];
        }
        return rawMeasurements;
    }

    protected PartialPath readTargetPath(ByteBuffer buffer) throws IllegalPathException {
        return DataNodeDevicePathCache.getInstance().getPartialPath(ReadWriteIOUtils.readString((ByteBuffer)buffer));
    }

    protected PartialPath readTargetPath(DataInputStream stream) throws IllegalPathException, IOException {
        return DataNodeDevicePathCache.getInstance().getPartialPath(ReadWriteIOUtils.readString((InputStream)stream));
    }

    public long getMemorySize() {
        if (this.memorySize == 0L) {
            this.memorySize = InsertNodeMemoryEstimator.sizeOf(this);
        }
        return this.memorySize;
    }
}

