/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.execution.config.metadata.relational;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.schema.column.ColumnHeader;
import org.apache.iotdb.commons.schema.column.ColumnHeaderConstant;
import org.apache.iotdb.commons.schema.table.TreeViewSchema;
import org.apache.iotdb.commons.schema.table.TsTable;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnSchema;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeader;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeaderFactory;
import org.apache.iotdb.db.queryengine.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.queryengine.plan.execution.config.executor.IConfigTaskExecutor;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.relational.AbstractTableTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.relational.ShowCreateTableTask;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.utils.Binary;

public class ShowCreateViewTask
extends AbstractTableTask {
    public ShowCreateViewTask(String database, String tableName) {
        super(database, tableName);
    }

    @Override
    public ListenableFuture<ConfigTaskResult> execute(IConfigTaskExecutor configTaskExecutor) throws InterruptedException {
        return configTaskExecutor.describeTable(this.database, this.tableName, false, true);
    }

    public static void buildTsBlock(TsTable table, SettableFuture<ConfigTaskResult> future) {
        if (!TreeViewSchema.isTreeViewTable((TsTable)table)) {
            throw new SemanticException("The table " + table.getTableName() + " is a base table, does not support show create view.");
        }
        List outputDataTypes = ColumnHeaderConstant.showCreateViewColumnHeaders.stream().map(ColumnHeader::getColumnType).collect(Collectors.toList());
        TsBlockBuilder builder = new TsBlockBuilder(outputDataTypes);
        builder.getTimeColumnBuilder().writeLong(0L);
        builder.getColumnBuilder(0).writeBinary(new Binary(table.getTableName(), TSFileConfig.STRING_CHARSET));
        builder.getColumnBuilder(1).writeBinary(new Binary(ShowCreateViewTask.getShowCreateViewSQL(table), TSFileConfig.STRING_CHARSET));
        builder.declarePosition();
        DatasetHeader datasetHeader = DatasetHeaderFactory.getShowCreateViewColumnHeader();
        future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS, builder.build(), datasetHeader));
    }

    public static String getShowCreateViewSQL(TsTable table) {
        StringBuilder builder = new StringBuilder("CREATE VIEW ").append(ShowCreateTableTask.getIdentifier(table.getTableName())).append(" (");
        block5: for (TsTableColumnSchema schema : table.getColumnList()) {
            switch (schema.getColumnCategory()) {
                case TAG: {
                    builder.append(ShowCreateTableTask.getIdentifier(schema.getColumnName())).append(" ").append(schema.getDataType()).append(" ").append("TAG");
                    break;
                }
                case TIME: {
                    continue block5;
                }
                case FIELD: {
                    builder.append(ShowCreateTableTask.getIdentifier(schema.getColumnName())).append(" ").append(schema.getDataType()).append(" ").append("FIELD");
                    if (!Objects.nonNull(TreeViewSchema.getOriginalName((TsTableColumnSchema)schema))) break;
                    builder.append(" FROM ").append(ShowCreateTableTask.getIdentifier(TreeViewSchema.getOriginalName((TsTableColumnSchema)schema)));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported column type: " + schema.getColumnCategory());
                }
            }
            if (Objects.nonNull(schema.getProps().get("__comment"))) {
                builder.append(" COMMENT ").append(ShowCreateTableTask.getString((String)schema.getProps().get("__comment")));
            }
            builder.append(",");
        }
        if (table.getColumnList().size() > 1) {
            builder.deleteCharAt(builder.length() - 1);
        }
        builder.append(")");
        if (table.getPropValue("__comment").isPresent()) {
            builder.append(" COMMENT ").append(ShowCreateTableTask.getString((String)table.getPropValue("__comment").get()));
        }
        if (TreeViewSchema.isRestrict((TsTable)table)) {
            builder.append(" RESTRICT");
        }
        builder.append(" WITH (ttl=").append(table.getPropValue("ttl").orElse("'INF'")).append(")");
        builder.append(" AS ");
        String[] pathNodes = TreeViewSchema.getPrefixPattern((TsTable)table).getNodes();
        builder.append(pathNodes[0]);
        for (int i = 1; i < pathNodes.length - 1; ++i) {
            builder.append(".\"").append(pathNodes[i]).append("\"");
        }
        builder.append(".").append(pathNodes[pathNodes.length - 1]);
        return builder.toString();
    }
}

