/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.hash;

import com.google.common.base.Verify;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.grouped.hash.FlatHash;
import org.apache.tsfile.utils.RamUsageEstimator;

public final class VariableWidthData {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(VariableWidthData.class);
    public static final int MIN_CHUNK_SIZE = 1024;
    public static final int MAX_CHUNK_SIZE = 0x800000;
    public static final int POINTER_SIZE = 12;
    public static final byte[] EMPTY_CHUNK = new byte[0];
    private final List<byte[]> chunks = new ArrayList<byte[]>();
    private int openChunkOffset;
    private long chunksRetainedSizeInBytes;
    private long allocatedBytes;
    private long freeBytes;

    public VariableWidthData() {
    }

    public VariableWidthData(VariableWidthData variableWidthData) {
        for (byte[] chunk : variableWidthData.chunks) {
            this.chunks.add(Arrays.copyOf(chunk, chunk.length));
        }
        this.openChunkOffset = variableWidthData.openChunkOffset;
        this.chunksRetainedSizeInBytes = variableWidthData.chunksRetainedSizeInBytes;
        this.allocatedBytes = variableWidthData.allocatedBytes;
        this.freeBytes = variableWidthData.freeBytes;
    }

    public VariableWidthData(List<byte[]> chunks, int openChunkOffset) {
        this.chunks.addAll(chunks);
        this.openChunkOffset = openChunkOffset;
        this.chunksRetainedSizeInBytes = chunks.stream().mapToLong(RamUsageEstimator::sizeOf).reduce(0L, Math::addExact);
        this.allocatedBytes = chunks.stream().mapToLong(chunk -> ((byte[])chunk).length).sum();
        this.freeBytes = 0L;
    }

    public long getRetainedSizeBytes() {
        return FlatHash.sumExact(INSTANCE_SIZE, this.chunksRetainedSizeInBytes, RamUsageEstimator.sizeOfObjectArray((int)this.chunks.size()));
    }

    public List<byte[]> getAllChunks() {
        return this.chunks;
    }

    public long getAllocatedBytes() {
        return this.allocatedBytes;
    }

    public long getFreeBytes() {
        return this.freeBytes;
    }

    public byte[] allocate(byte[] pointer, int pointerOffset, int size) {
        byte[] openChunk;
        if (size == 0) {
            VariableWidthData.writePointer(pointer, pointerOffset, 0, 0, 0);
            return EMPTY_CHUNK;
        }
        byte[] byArray = openChunk = this.chunks.isEmpty() ? EMPTY_CHUNK : this.chunks.get(this.chunks.size() - 1);
        if (openChunk.length - this.openChunkOffset < size) {
            this.freeBytes += (long)(openChunk.length - this.openChunkOffset);
            int newSize = Ints.saturatedCast((long)Math.max((long)size * 32L, (long)openChunk.length * 2L));
            newSize = VariableWidthData.clamp(newSize, 1024, 0x800000);
            newSize = Math.max(newSize, size);
            openChunk = new byte[newSize];
            this.chunks.add(openChunk);
            this.allocatedBytes += (long)newSize;
            this.chunksRetainedSizeInBytes = Math.addExact(this.chunksRetainedSizeInBytes, RamUsageEstimator.sizeOf((byte[])openChunk));
            this.openChunkOffset = 0;
        }
        VariableWidthData.writePointer(pointer, pointerOffset, this.chunks.size() - 1, this.openChunkOffset, size);
        this.openChunkOffset += size;
        return openChunk;
    }

    public static int clamp(long value, int min, int max) {
        if (min > max) {
            throw new IllegalArgumentException(min + " > " + max);
        }
        return (int)Math.min((long)max, Math.max(value, (long)min));
    }

    public void free(byte[] pointer, int pointerOffset) {
        int valueOffset;
        int valueLength = VariableWidthData.getValueLength(pointer, pointerOffset);
        if (valueLength == 0) {
            return;
        }
        int valueChunkIndex = VariableWidthData.getChunkIndex(pointer, pointerOffset);
        byte[] valueChunk = this.chunks.get(valueChunkIndex);
        if (valueChunkIndex == this.chunks.size() - 1 && this.openChunkOffset - valueLength == (valueOffset = VariableWidthData.getChunkOffset(pointer, pointerOffset))) {
            this.openChunkOffset = valueOffset;
            return;
        }
        if (valueLength == valueChunk.length) {
            this.chunks.set(valueChunkIndex, EMPTY_CHUNK);
            this.chunksRetainedSizeInBytes = Math.subtractExact(this.chunksRetainedSizeInBytes, RamUsageEstimator.sizeOf((byte[])valueChunk));
            this.allocatedBytes -= (long)valueChunk.length;
            return;
        }
        this.freeBytes += (long)valueLength;
    }

    public byte[] getChunk(byte[] pointer, int pointerOffset) {
        int chunkIndex = VariableWidthData.getChunkIndex(pointer, pointerOffset);
        if (this.chunks.isEmpty()) {
            Verify.verify((chunkIndex == 0 ? 1 : 0) != 0);
            return EMPTY_CHUNK;
        }
        this.checkIndex(chunkIndex, this.chunks.size());
        return this.chunks.get(chunkIndex);
    }

    private void checkIndex(int index, int length) {
        if (index < 0 || index >= length) {
            throw new IndexOutOfBoundsException();
        }
    }

    private static int getChunkIndex(byte[] pointer, int pointerOffset) {
        return FlatHash.bytesToInt(pointer, pointerOffset);
    }

    public static int getChunkOffset(byte[] pointer, int pointerOffset) {
        return FlatHash.bytesToInt(pointer, pointerOffset + 4);
    }

    public static int getValueLength(byte[] pointer, int pointerOffset) {
        return FlatHash.bytesToInt(pointer, pointerOffset + 8);
    }

    public static void writePointer(byte[] pointer, int pointerOffset, int chunkIndex, int chunkOffset, int valueLength) {
        FlatHash.intToBytes(pointer, pointerOffset, chunkIndex);
        FlatHash.intToBytes(pointer, pointerOffset + 4, chunkOffset);
        FlatHash.intToBytes(pointer, pointerOffset + 8, valueLength);
    }
}

