/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source.relational;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.path.AlignedFullPath;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnCategory;
import org.apache.iotdb.db.queryengine.execution.aggregation.timerangeiterator.ITableTimeRangeIterator;
import org.apache.iotdb.db.queryengine.execution.operator.AggregationUtil;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.source.AbstractDataSourceOperator;
import org.apache.iotdb.db.queryengine.execution.operator.source.AlignedSeriesScanUtil;
import org.apache.iotdb.db.queryengine.execution.operator.source.SeriesScanUtil;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.TableScanOperator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.TableAggregator;
import org.apache.iotdb.db.queryengine.execution.operator.window.TimeWindow;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.SeriesScanOptions;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.AlignedDeviceEntry;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.ColumnSchema;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.DeviceEntry;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.iotdb.db.storageengine.dataregion.read.IQueryDataSource;
import org.apache.iotdb.db.storageengine.dataregion.read.QueryDataSource;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.file.metadata.statistics.StringStatistics;
import org.apache.tsfile.read.common.TimeRange;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.read.common.block.TsBlockUtil;
import org.apache.tsfile.read.common.block.column.BinaryColumn;
import org.apache.tsfile.read.common.block.column.RunLengthEncodedColumn;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.write.schema.IMeasurementSchema;

public abstract class AbstractAggTableScanOperator
extends AbstractDataSourceOperator {
    private boolean finished = false;
    private TsBlock inputTsBlock;
    protected List<TableAggregator> tableAggregators;
    protected final List<ColumnSchema> groupingKeySchemas;
    protected final int[] groupingKeyIndex;
    protected final int groupingKeySize;
    protected final int dateBinSize;
    protected final List<DeviceEntry> deviceEntries;
    protected final int deviceCount;
    protected int currentDeviceIndex;
    protected List<String> measurementColumnNames;
    protected Set<String> allSensors;
    protected List<IMeasurementSchema> measurementSchemas;
    protected List<TSDataType> measurementColumnTSDataTypes;
    protected int measurementCount;
    protected List<ColumnSchema> aggColumnSchemas;
    protected int[] aggColumnsIndexArray;
    protected SeriesScanOptions seriesScanOptions;
    private final boolean ascending;
    private final Ordering scanOrder;
    protected final boolean canUseStatistics;
    private final long cachedRawDataSize;
    protected List<Integer> aggregatorInputChannels;
    private QueryDataSource queryDataSource;
    protected ITableTimeRangeIterator timeIterator;
    private boolean allAggregatorsHasFinalResult = false;
    long leftRuntimeOfOneNextCall = Long.MAX_VALUE;

    protected AbstractAggTableScanOperator(AbstractAggTableScanOperatorParameter parameter) {
        this.sourceId = parameter.sourceId;
        this.operatorContext = parameter.context;
        this.canUseStatistics = parameter.canUseStatistics;
        this.tableAggregators = parameter.tableAggregators;
        this.groupingKeySchemas = parameter.groupingKeySchemas;
        this.groupingKeyIndex = parameter.groupingKeyIndex;
        this.groupingKeySize = parameter.groupingKeySchemas == null ? 0 : parameter.groupingKeySchemas.size();
        this.aggColumnSchemas = parameter.aggColumnSchemas;
        this.aggColumnsIndexArray = parameter.aggColumnsIndexArray;
        this.deviceEntries = parameter.deviceEntries;
        this.deviceCount = parameter.deviceCount;
        this.operatorContext.recordSpecifiedInfo("DeviceNumber", Integer.toString(this.deviceCount));
        this.ascending = parameter.ascending;
        this.scanOrder = parameter.ascending ? Ordering.ASC : Ordering.DESC;
        this.seriesScanOptions = parameter.seriesScanOptions;
        this.measurementColumnNames = parameter.measurementColumnNames;
        this.measurementCount = this.measurementColumnNames.size();
        this.cachedRawDataSize = (1L + (long)this.measurementCount) * (long)TSFileDescriptor.getInstance().getConfig().getPageSizeInByte();
        this.allSensors = parameter.allSensors;
        this.measurementSchemas = parameter.measurementSchemas;
        this.measurementColumnTSDataTypes = parameter.measurementSchemas.stream().map(IMeasurementSchema::getType).collect(Collectors.toList());
        this.currentDeviceIndex = 0;
        this.operatorContext.recordSpecifiedInfo("CurrentDeviceIndex", Integer.toString(0));
        this.aggregatorInputChannels = parameter.aggregatorInputChannels;
        this.timeIterator = parameter.tableTimeRangeIterator;
        this.dateBinSize = this.timeIterator.getType() == ITableTimeRangeIterator.TimeIteratorType.DATE_BIN_TIME_ITERATOR ? 1 : 0;
        this.constructAlignedSeriesScanUtil();
    }

    @Override
    public boolean isFinished() throws Exception {
        if (!this.finished) {
            this.finished = !this.hasNextWithTimer();
        }
        return this.finished;
    }

    protected abstract void updateResultTsBlock();

    protected void buildResultTsBlock() {
        this.resultTsBlock = this.resultTsBlockBuilder.build((Column)new RunLengthEncodedColumn((Column)TableScanOperator.TIME_COLUMN_TEMPLATE, this.resultTsBlockBuilder.getPositionCount()));
        this.resultTsBlockBuilder.reset();
    }

    protected void constructAlignedSeriesScanUtil() {
        DeviceEntry deviceEntry = this.deviceEntries.isEmpty() || this.deviceEntries.get(this.currentDeviceIndex) == null ? new AlignedDeviceEntry((IDeviceID)SeriesScanUtil.EMPTY_DEVICE_ID, new Binary[0]) : this.deviceEntries.get(this.currentDeviceIndex);
        AlignedFullPath alignedPath = TableScanOperator.constructAlignedPath(deviceEntry, this.measurementColumnNames, this.measurementSchemas, this.allSensors);
        this.seriesScanUtil = new AlignedSeriesScanUtil(alignedPath, this.scanOrder, this.seriesScanOptions, this.operatorContext.getInstanceContext(), true, this.measurementColumnTSDataTypes);
    }

    protected Optional<Boolean> calculateAggregationResultForCurrentTimeRange() {
        try {
            Optional<Boolean> b;
            if (this.calcFromCachedData()) {
                this.updateResultTsBlock();
                this.checkIfAllAggregatorHasFinalResult();
                return Optional.of(true);
            }
            if (this.readAndCalcFromPage()) {
                this.updateResultTsBlock();
                this.checkIfAllAggregatorHasFinalResult();
                return Optional.of(true);
            }
            if (!this.seriesScanUtil.hasNextPage() && this.readAndCalcFromChunk()) {
                this.updateResultTsBlock();
                this.checkIfAllAggregatorHasFinalResult();
                return Optional.of(true);
            }
            if (!this.seriesScanUtil.hasNextPage()) {
                b = this.seriesScanUtil.hasNextChunk();
                if (!b.isPresent()) {
                    return b;
                }
                if (!b.get().booleanValue() && this.readAndCalcFromFile()) {
                    this.updateResultTsBlock();
                    this.checkIfAllAggregatorHasFinalResult();
                    return Optional.of(true);
                }
            }
            if (this.seriesScanUtil.hasNextPage()) {
                return Optional.of(false);
            }
            b = this.seriesScanUtil.hasNextChunk();
            if (!b.isPresent()) {
                return b;
            }
            if (b.get().booleanValue()) {
                return Optional.of(false);
            }
            b = this.seriesScanUtil.hasNextFile();
            if (!b.isPresent()) {
                return b;
            }
            if (b.get().booleanValue()) {
                return Optional.of(false);
            }
            this.updateResultTsBlock();
            this.timeIterator.resetCurTimeRange();
            this.nextDevice();
            if (this.currentDeviceIndex < this.deviceCount) {
                this.constructAlignedSeriesScanUtil();
                this.queryDataSource.reset();
                this.seriesScanUtil.initQueryDataSource(this.queryDataSource);
            }
            if (this.currentDeviceIndex >= this.deviceCount) {
                this.timeIterator.setFinished();
                return Optional.of(true);
            }
            return Optional.of(false);
        }
        catch (IOException e) {
            throw new RuntimeException("Error while scanning the file", e);
        }
    }

    protected boolean calcFromCachedData() {
        return this.calcUsingRawData(this.inputTsBlock);
    }

    protected boolean calcUsingRawData(TsBlock tsBlock) {
        Pair<Boolean, TsBlock> calcResult = this.calculateAggregationFromRawData(tsBlock, this.ascending);
        this.inputTsBlock = (TsBlock)calcResult.getRight();
        return (Boolean)calcResult.getLeft();
    }

    public Pair<Boolean, TsBlock> calculateAggregationFromRawData(TsBlock inputTsBlock, boolean ascending) {
        if (inputTsBlock == null || inputTsBlock.isEmpty()) {
            return new Pair((Object)false, (Object)inputTsBlock);
        }
        this.updateCurTimeRange(inputTsBlock.getStartTime());
        TimeRange curTimeRange = this.timeIterator.getCurTimeRange();
        if (AggregationUtil.satisfiedTimeRange(inputTsBlock, curTimeRange, ascending)) {
            if (ascending && inputTsBlock.getStartTime() < curTimeRange.getMin() || !ascending && inputTsBlock.getStartTime() > curTimeRange.getMax()) {
                inputTsBlock = TsBlockUtil.skipPointsOutOfTimeRange((TsBlock)inputTsBlock, (TimeRange)curTimeRange, (boolean)ascending);
            }
            inputTsBlock = this.process(inputTsBlock, curTimeRange);
        }
        boolean isTsBlockOutOfBound = inputTsBlock != null && (ascending ? inputTsBlock.getEndTime() > curTimeRange.getMax() : inputTsBlock.getEndTime() < curTimeRange.getMin());
        return new Pair((Object)(this.isAllAggregatorsHasFinalResult(this.tableAggregators) || isTsBlockOutOfBound ? 1 : 0), (Object)inputTsBlock);
    }

    private TsBlock process(TsBlock inputTsBlock, TimeRange curTimeRange) {
        TimeWindow curWindow = new TimeWindow(curTimeRange);
        Column timeColumn = inputTsBlock.getTimeColumn();
        int lastIndexToProcess = 0;
        int i = 0;
        while (i < inputTsBlock.getPositionCount() && curWindow.satisfy(timeColumn, i)) {
            lastIndexToProcess = i++;
        }
        TsBlock inputRegion = inputTsBlock.getRegion(0, lastIndexToProcess + 1);
        Column[] valueColumns = new Column[this.aggregatorInputChannels.size()];
        for (int idx : this.aggregatorInputChannels) {
            if (valueColumns[idx] != null) continue;
            valueColumns[idx] = this.buildValueColumn(this.aggColumnSchemas.get(idx).getColumnCategory(), inputRegion, idx);
        }
        TsBlock tsBlock = new TsBlock(inputRegion.getPositionCount(), (Column)new RunLengthEncodedColumn((Column)TableScanOperator.TIME_COLUMN_TEMPLATE, inputRegion.getPositionCount()), valueColumns);
        for (TableAggregator aggregator : this.tableAggregators) {
            if (aggregator.hasFinalResult()) continue;
            aggregator.processBlock(tsBlock);
        }
        int lastReadRowIndex = lastIndexToProcess + 1;
        if (lastReadRowIndex >= inputTsBlock.getPositionCount()) {
            return null;
        }
        return inputTsBlock.subTsBlock(lastReadRowIndex);
    }

    private Column buildValueColumn(TsTableColumnCategory columnSchemaCategory, TsBlock inputRegion, int columnIdx) {
        switch (columnSchemaCategory) {
            case TIME: {
                return inputRegion.getTimeColumn();
            }
            case TAG: {
                String id = this.getNthIdColumnValue(this.deviceEntries.get(this.currentDeviceIndex), this.aggColumnsIndexArray[columnIdx]);
                return this.getIdOrAttrColumn(inputRegion.getTimeColumn().getPositionCount(), id == null ? null : new Binary(id, TSFileConfig.STRING_CHARSET));
            }
            case ATTRIBUTE: {
                Binary attr = this.deviceEntries.get(this.currentDeviceIndex).getAttributeColumnValues()[this.aggColumnsIndexArray[columnIdx]];
                return this.getIdOrAttrColumn(inputRegion.getTimeColumn().getPositionCount(), attr);
            }
            case FIELD: {
                return inputRegion.getColumn(this.aggColumnsIndexArray[columnIdx]);
            }
        }
        throw new IllegalStateException("Unsupported column type: " + columnSchemaCategory);
    }

    private Column getIdOrAttrColumn(int positionCount, Binary columnName) {
        if (columnName == null) {
            return new RunLengthEncodedColumn((Column)new BinaryColumn(1, Optional.of(new boolean[]{true}), new Binary[]{null}), positionCount);
        }
        return new RunLengthEncodedColumn((Column)new BinaryColumn(1, Optional.of(new boolean[]{false}), new Binary[]{columnName}), positionCount);
    }

    protected void calcFromStatistics(Statistics timeStatistics, Statistics[] valueStatistics) {
        int idx = -1;
        for (TableAggregator aggregator : this.tableAggregators) {
            if (aggregator.hasFinalResult()) {
                idx += aggregator.getChannelCount();
                continue;
            }
            Statistics[] statisticsArray = new Statistics[aggregator.getChannelCount()];
            for (int i = 0; i < aggregator.getChannelCount(); ++i) {
                TsTableColumnCategory columnSchemaCategory = this.aggColumnSchemas.get(this.aggregatorInputChannels.get(++idx)).getColumnCategory();
                statisticsArray[i] = this.buildStatistics(columnSchemaCategory, timeStatistics, valueStatistics, this.aggregatorInputChannels.get(idx));
            }
            aggregator.processStatistics(statisticsArray);
        }
    }

    private Statistics buildStatistics(TsTableColumnCategory columnSchemaCategory, Statistics timeStatistics, Statistics[] valueStatistics, int columnIdx) {
        switch (columnSchemaCategory) {
            case TIME: {
                return timeStatistics;
            }
            case TAG: {
                String id = this.getNthIdColumnValue(this.deviceEntries.get(this.currentDeviceIndex), this.aggColumnsIndexArray[columnIdx]);
                return this.getStatistics(timeStatistics, id == null ? null : new Binary(id, TSFileConfig.STRING_CHARSET));
            }
            case ATTRIBUTE: {
                Binary attr = this.deviceEntries.get(this.currentDeviceIndex).getAttributeColumnValues()[this.aggColumnsIndexArray[columnIdx]];
                return this.getStatistics(timeStatistics, attr);
            }
            case FIELD: {
                return valueStatistics[this.aggColumnsIndexArray[columnIdx]];
            }
        }
        throw new IllegalStateException("Unsupported column type: " + columnSchemaCategory);
    }

    private Statistics getStatistics(Statistics timeStatistics, Binary columnName) {
        if (columnName == null) {
            return null;
        }
        StringStatistics stringStatics = new StringStatistics();
        stringStatics.setCount(timeStatistics.getCount());
        stringStatics.setStartTime(timeStatistics.getStartTime());
        stringStatics.setEndTime(timeStatistics.getEndTime());
        stringStatics.initializeStats(columnName, columnName, columnName, columnName);
        return stringStatics;
    }

    public boolean readAndCalcFromFile() throws IOException {
        long start = System.nanoTime();
        while (System.nanoTime() - start < this.leftRuntimeOfOneNextCall) {
            Optional<Boolean> b = this.seriesScanUtil.hasNextFile();
            if (!b.isPresent()) continue;
            if (!b.get().booleanValue()) break;
            if (this.canUseStatistics && this.seriesScanUtil.canUseCurrentFileStatistics()) {
                Statistics fileTimeStatistics = this.seriesScanUtil.currentFileTimeStatistics();
                this.updateCurTimeRange(fileTimeStatistics.getStartTime());
                if (fileTimeStatistics.getStartTime() > this.timeIterator.getCurTimeRange().getMax()) {
                    if (this.ascending) {
                        return true;
                    }
                    this.seriesScanUtil.skipCurrentFile();
                    continue;
                }
                if (this.timeIterator.getCurTimeRange().contains(fileTimeStatistics.getStartTime(), fileTimeStatistics.getEndTime())) {
                    Statistics[] statisticsList = new Statistics[this.measurementCount];
                    for (int i = 0; i < this.measurementCount; ++i) {
                        statisticsList[i] = this.seriesScanUtil.currentFileStatistics(i);
                    }
                    this.calcFromStatistics(fileTimeStatistics, statisticsList);
                    this.seriesScanUtil.skipCurrentFile();
                    if (!this.isAllAggregatorsHasFinalResult(this.tableAggregators)) continue;
                    return true;
                }
            }
            if (!this.readAndCalcFromChunk()) continue;
            return true;
        }
        return false;
    }

    protected boolean readAndCalcFromChunk() throws IOException {
        long start = System.nanoTime();
        while (System.nanoTime() - start < this.leftRuntimeOfOneNextCall) {
            Optional<Boolean> b = this.seriesScanUtil.hasNextChunk();
            if (!b.isPresent()) continue;
            if (!b.get().booleanValue()) break;
            if (this.canUseStatistics && this.seriesScanUtil.canUseCurrentChunkStatistics()) {
                Statistics chunkTimeStatistics = this.seriesScanUtil.currentChunkTimeStatistics();
                this.updateCurTimeRange(chunkTimeStatistics.getStartTime());
                if (chunkTimeStatistics.getStartTime() > this.timeIterator.getCurTimeRange().getMax()) {
                    if (this.ascending) {
                        return true;
                    }
                    this.seriesScanUtil.skipCurrentChunk();
                    continue;
                }
                if (this.timeIterator.getCurTimeRange().contains(chunkTimeStatistics.getStartTime(), chunkTimeStatistics.getEndTime())) {
                    Statistics[] statisticsList = new Statistics[this.measurementCount];
                    for (int i = 0; i < this.measurementCount; ++i) {
                        statisticsList[i] = this.seriesScanUtil.currentChunkStatistics(i);
                    }
                    this.calcFromStatistics(chunkTimeStatistics, statisticsList);
                    this.seriesScanUtil.skipCurrentChunk();
                    if (!this.isAllAggregatorsHasFinalResult(this.tableAggregators)) continue;
                    return true;
                }
            }
            if (!this.readAndCalcFromPage()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean readAndCalcFromPage() throws IOException {
        long start = System.nanoTime();
        try {
            while (System.nanoTime() - start < this.leftRuntimeOfOneNextCall && this.seriesScanUtil.hasNextPage()) {
                TsBlock originalTsBlock;
                if (this.canUseStatistics && this.seriesScanUtil.canUseCurrentPageStatistics()) {
                    Statistics pageTimeStatistics = this.seriesScanUtil.currentPageTimeStatistics();
                    this.updateCurTimeRange(pageTimeStatistics.getStartTime());
                    if (pageTimeStatistics.getStartTime() > this.timeIterator.getCurTimeRange().getMax()) {
                        if (this.ascending) {
                            boolean bl = true;
                            return bl;
                        }
                        this.seriesScanUtil.skipCurrentPage();
                        continue;
                    }
                    if (this.timeIterator.getCurTimeRange().contains(pageTimeStatistics.getStartTime(), pageTimeStatistics.getEndTime())) {
                        Statistics[] statisticsList = new Statistics[this.measurementCount];
                        for (int i = 0; i < this.measurementCount; ++i) {
                            statisticsList[i] = this.seriesScanUtil.currentPageStatistics(i);
                        }
                        this.calcFromStatistics(pageTimeStatistics, statisticsList);
                        this.seriesScanUtil.skipCurrentPage();
                        if (!this.isAllAggregatorsHasFinalResult(this.tableAggregators)) continue;
                        boolean bl = true;
                        return bl;
                    }
                }
                if ((originalTsBlock = this.seriesScanUtil.nextPage()) == null) continue;
                if (!this.calcUsingRawData(originalTsBlock)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.leftRuntimeOfOneNextCall -= System.nanoTime() - start;
        }
    }

    private void updateCurTimeRange(long startTime) {
        if (this.timeIterator.getType() == ITableTimeRangeIterator.TimeIteratorType.SINGLE_TIME_ITERATOR) {
            this.timeIterator.updateCurTimeRange(startTime);
            return;
        }
        if (!this.timeIterator.hasCachedTimeRange()) {
            this.timeIterator.updateCurTimeRange(startTime);
        } else if (this.timeIterator.canFinishCurrentTimeRange(startTime)) {
            this.updateResultTsBlock();
            this.timeIterator.resetCurTimeRange();
            this.timeIterator.updateCurTimeRange(startTime);
            this.resetTableAggregators();
        }
    }

    protected void appendAggregationResult() {
        if (!this.timeIterator.hasCachedTimeRange()) {
            return;
        }
        this.appendGroupKeysToResult(this.deviceEntries, this.currentDeviceIndex);
        if (this.dateBinSize > 0) {
            this.resultTsBlockBuilder.getValueColumnBuilders()[this.groupingKeySize].writeLong(this.timeIterator.getCurTimeRange().getMin());
        }
        for (int i = 0; i < this.tableAggregators.size(); ++i) {
            this.tableAggregators.get(i).evaluate(this.resultTsBlockBuilder.getValueColumnBuilders()[this.groupingKeySize + this.dateBinSize + i]);
        }
        this.resultTsBlockBuilder.declarePosition();
    }

    protected void appendGroupKeysToResult(List<DeviceEntry> deviceEntries, int deviceIndex) {
        ColumnBuilder[] columnBuilders = this.resultTsBlockBuilder.getValueColumnBuilders();
        for (int i = 0; i < this.groupingKeySize; ++i) {
            if (TsTableColumnCategory.TAG == this.groupingKeySchemas.get(i).getColumnCategory()) {
                String id = this.getNthIdColumnValue(deviceEntries.get(deviceIndex), this.groupingKeyIndex[i]);
                if (id == null) {
                    columnBuilders[i].appendNull();
                    continue;
                }
                columnBuilders[i].writeBinary(new Binary(id, TSFileConfig.STRING_CHARSET));
                continue;
            }
            Binary attribute = deviceEntries.get(deviceIndex).getAttributeColumnValues()[this.groupingKeyIndex[i]];
            if (attribute == null) {
                columnBuilders[i].appendNull();
                continue;
            }
            columnBuilders[i].writeBinary(attribute);
        }
    }

    public boolean isAllAggregatorsHasFinalResult(List<TableAggregator> aggregators) {
        if (this.timeIterator.getType() == ITableTimeRangeIterator.TimeIteratorType.DATE_BIN_TIME_ITERATOR) {
            return false;
        }
        for (TableAggregator aggregator : aggregators) {
            if (aggregator.hasFinalResult()) continue;
            return false;
        }
        this.allAggregatorsHasFinalResult = true;
        return true;
    }

    private void checkIfAllAggregatorHasFinalResult() {
        if (this.allAggregatorsHasFinalResult && (this.timeIterator.getType() == ITableTimeRangeIterator.TimeIteratorType.SINGLE_TIME_ITERATOR || this.tableAggregators.isEmpty())) {
            this.nextDevice();
            this.inputTsBlock = null;
            if (this.currentDeviceIndex < this.deviceCount) {
                this.constructAlignedSeriesScanUtil();
                this.queryDataSource.reset();
                this.seriesScanUtil.initQueryDataSource(this.queryDataSource);
            }
            if (this.currentDeviceIndex >= this.deviceCount) {
                this.timeIterator.setFinished();
            }
            this.allAggregatorsHasFinalResult = false;
        }
    }

    private void nextDevice() {
        ++this.currentDeviceIndex;
        this.operatorContext.recordSpecifiedInfo("CurrentDeviceIndex", Integer.toString(this.currentDeviceIndex));
    }

    protected void resetTableAggregators() {
        this.tableAggregators.forEach(TableAggregator::reset);
    }

    @Override
    public List<TSDataType> getResultDataTypes() {
        ArrayList<TSDataType> resultDataTypes = new ArrayList<TSDataType>(this.groupingKeySize + this.dateBinSize + this.tableAggregators.size());
        if (this.groupingKeySchemas != null) {
            for (int i = 0; i < this.groupingKeySchemas.size(); ++i) {
                resultDataTypes.add(TSDataType.STRING);
            }
        }
        if (this.dateBinSize > 0) {
            resultDataTypes.add(TSDataType.TIMESTAMP);
        }
        for (TableAggregator aggregator : this.tableAggregators) {
            resultDataTypes.add(aggregator.getType());
        }
        return resultDataTypes;
    }

    @Override
    public void initQueryDataSource(IQueryDataSource dataSource) {
        this.queryDataSource = (QueryDataSource)dataSource;
        this.seriesScanUtil.initQueryDataSource(this.queryDataSource);
        this.resultTsBlockBuilder = new TsBlockBuilder(this.getResultDataTypes());
    }

    @Override
    public long calculateMaxPeekMemory() {
        return this.cachedRawDataSize + this.maxReturnSize;
    }

    @Override
    public long calculateMaxReturnSize() {
        return this.maxReturnSize;
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return this.timeIterator.getType() == ITableTimeRangeIterator.TimeIteratorType.DATE_BIN_TIME_ITERATOR ? this.cachedRawDataSize : 0L;
    }

    @Override
    public void close() throws Exception {
        super.close();
        this.tableAggregators.forEach(TableAggregator::close);
    }

    abstract String getNthIdColumnValue(DeviceEntry var1, int var2);

    public static class AbstractAggTableScanOperatorParameter {
        private final String timeColumnName;
        protected final PlanNodeId sourceId;
        protected final OperatorContext context;
        protected final List<ColumnSchema> aggColumnSchemas;
        protected final int[] aggColumnsIndexArray;
        protected final SeriesScanOptions seriesScanOptions;
        protected final List<String> measurementColumnNames;
        protected final Set<String> allSensors;
        protected final List<IMeasurementSchema> measurementSchemas;
        protected final List<TableAggregator> tableAggregators;
        protected final List<ColumnSchema> groupingKeySchemas;
        protected final int[] groupingKeyIndex;
        protected final ITableTimeRangeIterator tableTimeRangeIterator;
        protected final boolean ascending;
        protected final boolean canUseStatistics;
        protected final List<Integer> aggregatorInputChannels;
        protected List<DeviceEntry> deviceEntries;
        protected int deviceCount;

        public AbstractAggTableScanOperatorParameter(PlanNodeId sourceId, OperatorContext context, List<ColumnSchema> aggColumnSchemas, int[] aggColumnsIndexArray, List<DeviceEntry> deviceEntries, int deviceCount, SeriesScanOptions seriesScanOptions, List<String> measurementColumnNames, Set<String> allSensors, List<IMeasurementSchema> measurementSchemas, List<TableAggregator> tableAggregators, List<ColumnSchema> groupingKeySchemas, int[] groupingKeyIndex, ITableTimeRangeIterator tableTimeRangeIterator, boolean ascending, boolean canUseStatistics, List<Integer> aggregatorInputChannels, String timeColumnName) {
            this.sourceId = sourceId;
            this.context = context;
            this.aggColumnSchemas = aggColumnSchemas;
            this.aggColumnsIndexArray = aggColumnsIndexArray;
            this.deviceEntries = deviceEntries;
            this.deviceCount = deviceCount;
            this.seriesScanOptions = seriesScanOptions;
            this.measurementColumnNames = measurementColumnNames;
            this.allSensors = allSensors;
            this.measurementSchemas = measurementSchemas;
            this.tableAggregators = tableAggregators;
            this.groupingKeySchemas = groupingKeySchemas;
            this.groupingKeyIndex = groupingKeyIndex;
            this.tableTimeRangeIterator = tableTimeRangeIterator;
            this.ascending = ascending;
            this.canUseStatistics = canUseStatistics;
            this.aggregatorInputChannels = aggregatorInputChannels;
            this.timeColumnName = timeColumnName;
        }

        public OperatorContext getOperatorContext() {
            return this.context;
        }

        public List<TableAggregator> getTableAggregators() {
            return this.tableAggregators;
        }

        public SeriesScanOptions getSeriesScanOptions() {
            return this.seriesScanOptions;
        }

        public Set<String> getAllSensors() {
            return this.allSensors;
        }

        public List<String> getMeasurementColumnNames() {
            return this.measurementColumnNames;
        }

        public List<IMeasurementSchema> getMeasurementSchemas() {
            return this.measurementSchemas;
        }

        public String getTimeColumnName() {
            return this.timeColumnName;
        }

        public void setDeviceEntries(List<DeviceEntry> deviceEntries) {
            this.deviceEntries = deviceEntries;
            this.deviceCount = deviceEntries.size();
        }
    }
}

