/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.selector.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PatternTreeMap;
import org.apache.iotdb.commons.utils.CommonDateTimeUtils;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.DataNodeTTLCache;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.ICompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.SettleCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.CompactionUtils;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.ISettleSelector;
import org.apache.iotdb.db.storageengine.dataregion.modification.Deletion;
import org.apache.iotdb.db.storageengine.dataregion.modification.Modification;
import org.apache.iotdb.db.storageengine.dataregion.modification.ModificationFile;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResourceStatus;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.DeviceTimeIndex;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.FileTimeIndex;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.ITimeIndex;
import org.apache.iotdb.db.utils.datastructure.PatternTreeMapFactory;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.PlainDeviceID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SettleSelectorImpl
implements ISettleSelector {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"COMPACTION");
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private final boolean heavySelect;
    private final String storageGroupName;
    private final String dataRegionId;
    private final long timePartition;
    private final TsFileManager tsFileManager;
    private boolean isSeq;

    public SettleSelectorImpl(boolean heavySelect, String storageGroupName, String dataRegionId, long timePartition, TsFileManager tsFileManager) {
        this.heavySelect = heavySelect;
        this.storageGroupName = storageGroupName;
        this.dataRegionId = dataRegionId;
        this.timePartition = timePartition;
        this.tsFileManager = tsFileManager;
    }

    @Override
    public List<SettleCompactionTask> selectSettleTask(List<TsFileResource> tsFileResources) {
        if (tsFileResources.isEmpty()) {
            return Collections.emptyList();
        }
        this.isSeq = tsFileResources.get(0).isSeq();
        return this.selectTasks(tsFileResources);
    }

    private List<SettleCompactionTask> selectTasks(List<TsFileResource> resources) {
        ArrayList<SettleTaskResource> partiallyDirtyResourceList = new ArrayList<SettleTaskResource>();
        SettleTaskResource settleTaskResource = new SettleTaskResource();
        try {
            for (TsFileResource resource : resources) {
                boolean shouldStop = false;
                FileDirtyInfo fileDirtyInfo = resource.getStatus() != TsFileResourceStatus.NORMAL ? new FileDirtyInfo(DirtyStatus.NOT_SATISFIED) : (!this.heavySelect ? this.selectFileBaseOnModSize(resource) : this.selectFileBaseOnDirtyData(resource));
                switch (fileDirtyInfo.status) {
                    case FULLY_DIRTY: {
                        settleTaskResource.addFullyDirtyResource(resource);
                        break;
                    }
                    case PARTIALLY_DIRTY: {
                        shouldStop = settleTaskResource.addPartiallyDirtyResource(resource, fileDirtyInfo.dirtyDataSize);
                        break;
                    }
                    case NOT_SATISFIED: {
                        shouldStop = !settleTaskResource.getPartiallyDirtyResources().isEmpty();
                        break;
                    }
                }
                if (!shouldStop) continue;
                partiallyDirtyResourceList.add(settleTaskResource);
                settleTaskResource = new SettleTaskResource();
                if (this.heavySelect) continue;
                break;
            }
            partiallyDirtyResourceList.add(settleTaskResource);
            return this.createTask(partiallyDirtyResourceList);
        }
        catch (Exception e) {
            LOGGER.error("{}-{} cannot select file for settle compaction", new Object[]{this.storageGroupName, this.dataRegionId, e});
            return Collections.emptyList();
        }
    }

    private FileDirtyInfo selectFileBaseOnModSize(TsFileResource resource) {
        ModificationFile modFile = resource.getModFile();
        if (modFile == null || !modFile.exists()) {
            return new FileDirtyInfo(DirtyStatus.NOT_SATISFIED);
        }
        return modFile.getSize() > config.getInnerCompactionTaskSelectionModsFileThreshold() || !CompactionUtils.isDiskHasSpace(config.getInnerCompactionTaskSelectionDiskRedundancy()) ? new FileDirtyInfo(DirtyStatus.PARTIALLY_DIRTY) : new FileDirtyInfo(DirtyStatus.NOT_SATISFIED);
    }

    private FileDirtyInfo selectFileBaseOnDirtyData(TsFileResource resource) throws IOException, IllegalPathException {
        ITimeIndex timeIndex = resource.getTimeIndex();
        if (timeIndex instanceof FileTimeIndex) {
            timeIndex = CompactionUtils.buildDeviceTimeIndex(resource);
        }
        HashSet<IDeviceID> deletedDevices = new HashSet<IDeviceID>();
        boolean hasExpiredTooLong = false;
        long currentTime = CommonDateTimeUtils.currentTime();
        PatternTreeMap<Modification, PatternTreeMapFactory.ModsSerializer> modifications = CompactionUtils.buildModEntryPatternTreeMap(resource);
        for (IDeviceID device : ((DeviceTimeIndex)timeIndex).getDevices()) {
            boolean isDeleted;
            long deviceTTL = DataNodeTTLCache.getInstance().getTTL(((PlainDeviceID)device).toStringID());
            boolean hasSetTTL = deviceTTL != Long.MAX_VALUE;
            long endTime = timeIndex.getEndTime(device).get();
            boolean bl = isDeleted = !timeIndex.isDeviceAlive(device, deviceTTL) || this.isDeviceDeletedByMods(modifications, device, timeIndex.getStartTime(device).get(), endTime);
            if (hasSetTTL) {
                if (!isDeleted) {
                    return new FileDirtyInfo(DirtyStatus.NOT_SATISFIED);
                }
                if (currentTime > endTime) {
                    long outdatedTimeDiff = currentTime - endTime;
                    if (endTime < 0L && outdatedTimeDiff < currentTime) {
                        outdatedTimeDiff = Long.MAX_VALUE;
                    }
                    long ttlThreshold = 3L * deviceTTL > deviceTTL ? deviceTTL : Long.MAX_VALUE;
                    boolean bl2 = hasExpiredTooLong = hasExpiredTooLong || outdatedTimeDiff > Math.min(config.getMaxExpiredTime(), ttlThreshold);
                }
            }
            if (!isDeleted) continue;
            deletedDevices.add(device);
        }
        double deletedDeviceRatio = (double)deletedDevices.size() / (double)((DeviceTimeIndex)timeIndex).getDevices().size();
        if (deletedDeviceRatio == 1.0) {
            return new FileDirtyInfo(DirtyStatus.FULLY_DIRTY);
        }
        boolean bl = hasExpiredTooLong = config.getMaxExpiredTime() != Long.MAX_VALUE && hasExpiredTooLong;
        if (hasExpiredTooLong || deletedDeviceRatio >= (double)config.getExpiredDataRatio()) {
            return new FileDirtyInfo(DirtyStatus.PARTIALLY_DIRTY, (long)(deletedDeviceRatio * (double)resource.getTsFileSize()));
        }
        return new FileDirtyInfo(DirtyStatus.NOT_SATISFIED);
    }

    private boolean isDeviceDeletedByMods(PatternTreeMap<Modification, PatternTreeMapFactory.ModsSerializer> modifications, IDeviceID device, long startTime, long endTime) throws IllegalPathException {
        List<Modification> deviceModifications = CompactionUtils.getMatchedModifications(modifications, device, "", null);
        for (Modification modification : deviceModifications) {
            if (!((Deletion)modification).getTimeRange().contains(startTime, endTime)) continue;
            return true;
        }
        return false;
    }

    private List<SettleCompactionTask> createTask(List<SettleTaskResource> settleTaskResourceList) {
        ArrayList<SettleCompactionTask> tasks = new ArrayList<SettleCompactionTask>();
        for (SettleTaskResource settleTaskResource : settleTaskResourceList) {
            if (settleTaskResource.isEmpty()) continue;
            SettleCompactionTask task = new SettleCompactionTask(this.timePartition, this.tsFileManager, settleTaskResource.getFullyDirtyResources(), settleTaskResource.getPartiallyDirtyResources(), this.isSeq, this.createCompactionPerformer(), this.tsFileManager.getNextCompactionTaskId());
            tasks.add(task);
        }
        return tasks;
    }

    private ICompactionPerformer createCompactionPerformer() {
        return this.isSeq ? IoTDBDescriptor.getInstance().getConfig().getInnerSeqCompactionPerformer().createInstance() : IoTDBDescriptor.getInstance().getConfig().getInnerUnseqCompactionPerformer().createInstance();
    }

    static class SettleTaskResource {
        List<TsFileResource> fullyDirtyResources = new ArrayList<TsFileResource>();
        List<TsFileResource> partiallyDirtyResources = new ArrayList<TsFileResource>();
        long totalPartiallyDirtyFileSize = 0L;

        SettleTaskResource() {
        }

        public void addFullyDirtyResource(TsFileResource resource) {
            this.fullyDirtyResources.add(resource);
        }

        public boolean addPartiallyDirtyResource(TsFileResource resource, long dirtyDataSize) {
            this.partiallyDirtyResources.add(resource);
            this.totalPartiallyDirtyFileSize += resource.getTsFileSize();
            this.totalPartiallyDirtyFileSize -= dirtyDataSize;
            return this.checkHasReachedThreshold();
        }

        public List<TsFileResource> getFullyDirtyResources() {
            return this.fullyDirtyResources;
        }

        public List<TsFileResource> getPartiallyDirtyResources() {
            return this.partiallyDirtyResources;
        }

        public boolean checkHasReachedThreshold() {
            return this.partiallyDirtyResources.size() >= config.getInnerCompactionCandidateFileNum() || this.totalPartiallyDirtyFileSize >= config.getTargetCompactionFileSize();
        }

        public boolean isEmpty() {
            return this.fullyDirtyResources.isEmpty() && this.partiallyDirtyResources.isEmpty();
        }
    }

    static class FileDirtyInfo {
        DirtyStatus status;
        long dirtyDataSize = 0L;

        public FileDirtyInfo(DirtyStatus status) {
            this.status = status;
        }

        public FileDirtyInfo(DirtyStatus status, long dirtyDataSize) {
            this.status = status;
            this.dirtyDataSize = dirtyDataSize;
        }
    }

    static enum DirtyStatus {
        FULLY_DIRTY,
        PARTIALLY_DIRTY,
        NOT_SATISFIED;

    }
}

