/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class StatusResult
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=299");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=300");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=301");
    private final StatusCode statusCode;
    private final DiagnosticInfo diagnosticInfo;

    public StatusResult(StatusCode statusCode, DiagnosticInfo diagnosticInfo) {
        this.statusCode = statusCode;
        this.diagnosticInfo = diagnosticInfo;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public DiagnosticInfo getDiagnosticInfo() {
        return this.diagnosticInfo;
    }

    protected StatusResult(StatusResultBuilder<?, ?> b) {
        super(b);
        this.statusCode = ((StatusResultBuilder)b).statusCode;
        this.diagnosticInfo = ((StatusResultBuilder)b).diagnosticInfo;
    }

    public static StatusResultBuilder<?, ?> builder() {
        return new StatusResultBuilderImpl();
    }

    public StatusResultBuilder<?, ?> toBuilder() {
        return new StatusResultBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StatusResult)) {
            return false;
        }
        StatusResult other = (StatusResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        StatusCode this$statusCode = this.getStatusCode();
        StatusCode other$statusCode = other.getStatusCode();
        if (this$statusCode == null ? other$statusCode != null : !((Object)this$statusCode).equals(other$statusCode)) {
            return false;
        }
        DiagnosticInfo this$diagnosticInfo = this.getDiagnosticInfo();
        DiagnosticInfo other$diagnosticInfo = other.getDiagnosticInfo();
        return !(this$diagnosticInfo == null ? other$diagnosticInfo != null : !((Object)this$diagnosticInfo).equals(other$diagnosticInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StatusResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        StatusCode $statusCode = this.getStatusCode();
        result = result * 59 + ($statusCode == null ? 43 : ((Object)$statusCode).hashCode());
        DiagnosticInfo $diagnosticInfo = this.getDiagnosticInfo();
        result = result * 59 + ($diagnosticInfo == null ? 43 : ((Object)$diagnosticInfo).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "StatusResult(statusCode=" + this.getStatusCode() + ", diagnosticInfo=" + this.getDiagnosticInfo() + ")";
    }

    private static final class StatusResultBuilderImpl
    extends StatusResultBuilder<StatusResult, StatusResultBuilderImpl> {
        private StatusResultBuilderImpl() {
        }

        @Override
        protected StatusResultBuilderImpl self() {
            return this;
        }

        @Override
        public StatusResult build() {
            return new StatusResult(this);
        }
    }

    public static abstract class StatusResultBuilder<C extends StatusResult, B extends StatusResultBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private StatusCode statusCode;
        private DiagnosticInfo diagnosticInfo;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            StatusResultBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(StatusResult instance, StatusResultBuilder<?, ?> b) {
            b.statusCode(instance.statusCode);
            b.diagnosticInfo(instance.diagnosticInfo);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B statusCode(StatusCode statusCode) {
            this.statusCode = statusCode;
            return (B)this.self();
        }

        public B diagnosticInfo(DiagnosticInfo diagnosticInfo) {
            this.diagnosticInfo = diagnosticInfo;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "StatusResult.StatusResultBuilder(super=" + super.toString() + ", statusCode=" + this.statusCode + ", diagnosticInfo=" + this.diagnosticInfo + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<StatusResult> {
        @Override
        public Class<StatusResult> getType() {
            return StatusResult.class;
        }

        @Override
        public StatusResult decode(SerializationContext context, UaDecoder decoder) {
            StatusCode statusCode = decoder.readStatusCode("StatusCode");
            DiagnosticInfo diagnosticInfo = decoder.readDiagnosticInfo("DiagnosticInfo");
            return new StatusResult(statusCode, diagnosticInfo);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, StatusResult value) {
            encoder.writeStatusCode("StatusCode", value.getStatusCode());
            encoder.writeDiagnosticInfo("DiagnosticInfo", value.getDiagnosticInfo());
        }
    }
}

