/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.statistics;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.db.queryengine.statistics.SpecifiedInfoMergerFactory;
import org.apache.iotdb.mpp.rpc.thrift.TOperatorStatistics;

public class StatisticsMergeUtil {
    private StatisticsMergeUtil() {
    }

    public static void mergeOperatorStatisticsIfDuplicate(Map<String, TOperatorStatistics> operatorStatisticsMap) {
        ArrayList<String> keysToRemove = new ArrayList<String>();
        HashMap<String, TOperatorStatistics> entriesToAdd = new HashMap<String, TOperatorStatistics>();
        for (Map.Entry<String, TOperatorStatistics> entry : operatorStatisticsMap.entrySet()) {
            String key = entry.getKey();
            if (!key.contains("-")) continue;
            String[] keys = key.split("-");
            String planNodeId = keys[0];
            if (entriesToAdd.containsKey(planNodeId)) {
                StatisticsMergeUtil.merge((TOperatorStatistics)entriesToAdd.get(planNodeId), entry.getValue());
                keysToRemove.add(key);
                continue;
            }
            entriesToAdd.put(planNodeId, entry.getValue());
            keysToRemove.add(key);
        }
        for (String key : keysToRemove) {
            operatorStatisticsMap.remove(key);
        }
        operatorStatisticsMap.putAll(entriesToAdd);
    }

    public static void mergeAllOperatorStatistics(Map<String, TOperatorStatistics> operatorStatisticsMap, Map<String, String> leadOverloadOperators) {
        for (Map.Entry<String, TOperatorStatistics> entry : operatorStatisticsMap.entrySet()) {
            if (leadOverloadOperators.containsKey(entry.getValue().getOperatorType())) {
                StatisticsMergeUtil.merge(operatorStatisticsMap.get(leadOverloadOperators.get(entry.getValue().getOperatorType())), entry.getValue());
                continue;
            }
            TOperatorStatistics operatorStatistics = entry.getValue();
            operatorStatistics.setCount(1L);
            operatorStatistics.getSpecifiedInfo().clear();
            leadOverloadOperators.put(operatorStatistics.getOperatorType(), operatorStatistics.getPlanNodeId());
        }
    }

    public static void merge(TOperatorStatistics first, TOperatorStatistics second) {
        first.setTotalExecutionTimeInNanos(first.getTotalExecutionTimeInNanos() + second.getTotalExecutionTimeInNanos());
        first.setNextCalledCount(first.getNextCalledCount() + second.getNextCalledCount());
        first.setHasNextCalledCount(first.getHasNextCalledCount() + second.getHasNextCalledCount());
        first.setOutputRows(first.getOutputRows() + second.getOutputRows());
        first.setMemoryUsage(first.getMemoryUsage() + second.getMemoryUsage());
        first.setCount(first.getCount() + 1L);
        first.setSpecifiedInfo(SpecifiedInfoMergerFactory.getMerger(first.getOperatorType()).merge(first.getSpecifiedInfo(), second.getSpecifiedInfo()));
    }
}

