/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.encoding.encoder;

import java.io.ByteArrayOutputStream;
import org.apache.iotdb.tsfile.encoding.encoder.GorillaEncoderV1;

public class SinglePrecisionEncoderV1
extends GorillaEncoderV1 {
    private int preValue;

    @Override
    public void encode(float value, ByteArrayOutputStream out) {
        if (!this.flag) {
            this.flag = true;
            this.preValue = Float.floatToIntBits(value);
            this.leadingZeroNum = Integer.numberOfLeadingZeros(this.preValue);
            this.tailingZeroNum = Integer.numberOfTrailingZeros(this.preValue);
            out.write(this.preValue & 0xFF);
            out.write(this.preValue >> 8 & 0xFF);
            out.write(this.preValue >> 16 & 0xFF);
            out.write(this.preValue >> 24 & 0xFF);
        } else {
            int nextValue = Float.floatToIntBits(value);
            int tmp = nextValue ^ this.preValue;
            if (tmp == 0) {
                this.writeBit(false, out);
            } else {
                int leadingZeroNumTmp = Integer.numberOfLeadingZeros(tmp);
                int tailingZeroNumTmp = Integer.numberOfTrailingZeros(tmp);
                if (leadingZeroNumTmp >= this.leadingZeroNum && tailingZeroNumTmp >= this.tailingZeroNum) {
                    this.writeBit(true, out);
                    this.writeBit(false, out);
                    this.writeBits(tmp, out, 31 - this.leadingZeroNum, this.tailingZeroNum);
                } else {
                    this.writeBit(true, out);
                    this.writeBit(true, out);
                    this.writeBits(leadingZeroNumTmp, out, 4, 0);
                    this.writeBits(32 - leadingZeroNumTmp - tailingZeroNumTmp, out, 5, 0);
                    this.writeBits(tmp, out, 31 - leadingZeroNumTmp, tailingZeroNumTmp);
                }
            }
            this.preValue = nextValue;
            this.leadingZeroNum = Integer.numberOfLeadingZeros(this.preValue);
            this.tailingZeroNum = Integer.numberOfTrailingZeros(this.preValue);
        }
    }

    @Override
    public void flush(ByteArrayOutputStream out) {
        this.encode(Float.NaN, out);
        this.clearBuffer(out);
        this.reset();
    }

    private void writeBits(int num, ByteArrayOutputStream out, int start, int end) {
        for (int i = start; i >= end; --i) {
            int bit = num & 1 << i;
            this.writeBit(bit, out);
        }
    }

    @Override
    public int getOneItemMaxSize() {
        return 6;
    }

    @Override
    public long getMaxByteSize() {
        return 12L;
    }
}

