/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence;

import java.util.Collection;
import org.apache.ignite.DataRegionMetrics;
import org.apache.ignite.internal.pagemem.wal.IgniteWriteAheadLogManager;
import org.apache.ignite.internal.processors.metric.GridMetricManager;
import org.apache.ignite.internal.processors.metric.MetricRegistryImpl;
import org.apache.ignite.internal.processors.metric.impl.AtomicLongMetric;
import org.apache.ignite.internal.processors.metric.impl.HistogramMetricImpl;
import org.apache.ignite.internal.processors.metric.impl.HitRateMetric;
import org.apache.ignite.internal.processors.metric.impl.LongAdderMetric;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteOutClosure;
import org.jetbrains.annotations.Nullable;

public class DataStorageMetricsImpl {
    public static final String DATASTORAGE_METRIC_PREFIX = "io.datastorage";
    private final HitRateMetric walLoggingRate;
    private final HitRateMetric walWritingRate;
    private final HitRateMetric walFsyncTimeDuration;
    private final HitRateMetric walFsyncTimeNum;
    private final HitRateMetric walBuffPollSpinsNum;
    private final AtomicLongMetric lastCpBeforeLockDuration;
    private final AtomicLongMetric lastCpLockWaitDuration;
    private final AtomicLongMetric lastCpListenersExecuteDuration;
    private final AtomicLongMetric lastCpMarkDuration;
    private final AtomicLongMetric lastCpLockHoldDuration;
    private final AtomicLongMetric lastCpPagesWriteDuration;
    private final AtomicLongMetric lastCpDuration;
    private final AtomicLongMetric lastCpStart;
    private final AtomicLongMetric lastCpFsyncDuration;
    private final AtomicLongMetric lastCpWalRecordFsyncDuration;
    private final AtomicLongMetric lastCpWriteEntryDuration;
    private final AtomicLongMetric lastCpSplitAndSortPagesDuration;
    private final AtomicLongMetric lastCpTotalPages;
    private final AtomicLongMetric lastCpDataPages;
    private final AtomicLongMetric lastCpCowPages;
    @Deprecated
    private final boolean metricsEnabled;
    @Nullable
    private volatile IgniteWriteAheadLogManager wal;
    private volatile IgniteOutClosure<Long> walSizeProvider;
    private final AtomicLongMetric lastWalSegmentRollOverTime;
    private final AtomicLongMetric totalCheckpointTime;
    private volatile Collection<DataRegionMetrics> regionMetrics;
    private final AtomicLongMetric storageSize;
    private final AtomicLongMetric sparseStorageSize;
    private final HistogramMetricImpl cpBeforeLockHistogram;
    private final HistogramMetricImpl cpLockWaitHistogram;
    private final HistogramMetricImpl cpListenersExecuteHistogram;
    private final HistogramMetricImpl cpMarkHistogram;
    private final HistogramMetricImpl cpLockHoldHistogram;
    private final HistogramMetricImpl cpPagesWriteHistogram;
    private final HistogramMetricImpl cpFsyncHistogram;
    private final HistogramMetricImpl cpWalRecordFsyncHistogram;
    private final HistogramMetricImpl cpWriteEntryHistogram;
    private final HistogramMetricImpl cpSplitAndSortPagesHistogram;
    private final HistogramMetricImpl cpHistogram;
    private final LongAdderMetric walWrittenBytes;
    private final LongAdderMetric walCompressedBytes;

    public DataStorageMetricsImpl(GridMetricManager mmgr, boolean metricsEnabled, long rateTimeInterval, int subInts) {
        this.metricsEnabled = metricsEnabled;
        MetricRegistryImpl mreg = mmgr.registry(DATASTORAGE_METRIC_PREFIX);
        this.walLoggingRate = mreg.hitRateMetric("WalLoggingRate", "Average number of WAL records per second written during the last time interval.", rateTimeInterval, subInts);
        this.walWritingRate = mreg.hitRateMetric("WalWritingRate", "Average number of bytes per second written during the last time interval.", rateTimeInterval, subInts);
        this.walFsyncTimeDuration = mreg.hitRateMetric("WalFsyncTimeDuration", "Total duration of fsync", rateTimeInterval, subInts);
        this.walFsyncTimeNum = mreg.hitRateMetric("WalFsyncTimeNum", "Total count of fsync", rateTimeInterval, subInts);
        this.walBuffPollSpinsNum = mreg.hitRateMetric("WalBuffPollSpinsRate", "WAL buffer poll spins number over the last time interval.", rateTimeInterval, subInts);
        this.lastCpBeforeLockDuration = mreg.longMetric("LastCheckpointBeforeLockDuration", "Duration of the checkpoint action before taken write lock in milliseconds.");
        this.lastCpLockWaitDuration = mreg.longMetric("LastCheckpointLockWaitDuration", "Duration of the checkpoint lock wait in milliseconds.");
        this.lastCpListenersExecuteDuration = mreg.longMetric("LastCheckpointListenersExecuteDuration", "Duration of the checkpoint execution listeners under write lock in milliseconds.");
        this.lastCpMarkDuration = mreg.longMetric("LastCheckpointMarkDuration", "Duration of the checkpoint mark in milliseconds.");
        this.lastCpLockHoldDuration = mreg.longMetric("LastCheckpointLockHoldDuration", "Duration of the checkpoint lock hold in milliseconds.");
        this.lastCpPagesWriteDuration = mreg.longMetric("LastCheckpointPagesWriteDuration", "Duration of the checkpoint pages write in milliseconds.");
        this.lastCpDuration = mreg.longMetric("LastCheckpointDuration", "Duration of the last checkpoint in milliseconds.");
        this.lastCpStart = mreg.longMetric("LastCheckpointStart", "Start timestamp of the last checkpoint.");
        this.lastCpFsyncDuration = mreg.longMetric("LastCheckpointFsyncDuration", "Duration of the sync phase of the last checkpoint in milliseconds.");
        this.lastCpWalRecordFsyncDuration = mreg.longMetric("LastCheckpointWalRecordFsyncDuration", "Duration of the WAL fsync after logging CheckpointRecord on the start of the last checkpoint in milliseconds.");
        this.lastCpWriteEntryDuration = mreg.longMetric("LastCheckpointWriteEntryDuration", "Duration of entry buffer writing to file of the last checkpoint in milliseconds.");
        this.lastCpSplitAndSortPagesDuration = mreg.longMetric("LastCheckpointSplitAndSortPagesDuration", "Duration of splitting and sorting checkpoint pages of the last checkpoint in milliseconds.");
        this.lastCpTotalPages = mreg.longMetric("LastCheckpointTotalPagesNumber", "Total number of pages written during the last checkpoint.");
        this.lastCpDataPages = mreg.longMetric("LastCheckpointDataPagesNumber", "Total number of data pages written during the last checkpoint.");
        this.lastCpCowPages = mreg.longMetric("LastCheckpointCopiedOnWritePagesNumber", "Number of pages copied to a temporary checkpoint buffer during the last checkpoint.");
        this.lastWalSegmentRollOverTime = mreg.longMetric("WalLastRollOverTime", "Time of the last WAL segment rollover.");
        this.totalCheckpointTime = mreg.longMetric("CheckpointTotalTime", "Total duration of checkpoint");
        this.storageSize = mreg.longMetric("StorageSize", "Storage space allocated, in bytes.");
        this.sparseStorageSize = mreg.longMetric("SparseStorageSize", "Storage space allocated adjusted for possible sparsity, in bytes.");
        mreg.register("WalArchiveSegments", this::walArchiveSegments, "Current number of WAL segments in the WAL archive.");
        mreg.register("WalTotalSize", this::walTotalSize, "Total size in bytes for storage wal files.");
        long[] cpBounds = new long[]{100L, 500L, 1000L, 5000L, 30000L};
        this.cpBeforeLockHistogram = mreg.histogram("CheckpointBeforeLockHistogram", cpBounds, "Histogram of checkpoint action before taken write lock duration in milliseconds.");
        this.cpLockWaitHistogram = mreg.histogram("CheckpointLockWaitHistogram", cpBounds, "Histogram of checkpoint lock wait duration in milliseconds.");
        this.cpListenersExecuteHistogram = mreg.histogram("CheckpointListenersExecuteHistogram", cpBounds, "Histogram of checkpoint execution listeners under write lock duration in milliseconds.");
        this.cpMarkHistogram = mreg.histogram("CheckpointMarkHistogram", cpBounds, "Histogram of checkpoint mark duration in milliseconds.");
        this.cpLockHoldHistogram = mreg.histogram("CheckpointLockHoldHistogram", cpBounds, "Histogram of checkpoint lock hold duration in milliseconds.");
        this.cpPagesWriteHistogram = mreg.histogram("CheckpointPagesWriteHistogram", cpBounds, "Histogram of checkpoint pages write duration in milliseconds.");
        this.cpFsyncHistogram = mreg.histogram("CheckpointFsyncHistogram", cpBounds, "Histogram of checkpoint fsync duration in milliseconds.");
        this.cpWalRecordFsyncHistogram = mreg.histogram("CheckpointWalRecordFsyncHistogram", cpBounds, "Histogram of the WAL fsync after logging CheckpointRecord on begin of checkpoint duration in milliseconds.");
        this.cpWriteEntryHistogram = mreg.histogram("CheckpointWriteEntryHistogram", cpBounds, "Histogram of entry buffer writing to file duration in milliseconds.");
        this.cpSplitAndSortPagesHistogram = mreg.histogram("CheckpointSplitAndSortPagesHistogram", cpBounds, "Histogram of splitting and sorting checkpoint pages duration in milliseconds.");
        this.cpHistogram = mreg.histogram("CheckpointHistogram", cpBounds, "Histogram of checkpoint duration in milliseconds.");
        this.walWrittenBytes = mreg.longAdderMetric("WalWrittenBytes", "Total number of logged bytes into the WAL.");
        this.walCompressedBytes = mreg.longAdderMetric("WalCompressedBytes", "Total size of the compressed segments in bytes.");
        mreg.register("walFsyncTimeAverage", this::walFsyncTimeAverage, "Average WAL fsync duration in microseconds over the last time interval.");
        mreg.register("DirtyPages", this::dirtyPages, "Total dirty pages for the next checkpoint.");
        mreg.register("PagesRead", this::pagesRead, "The number of read pages from last restart.");
        mreg.register("PagesWritten", this::pagesWritten, "The number of written pages from last restart.");
        mreg.register("PagesReplaced", this::pagesReplaced, "The number of replaced pages from last restart.");
        mreg.register("OffHeapSize", this::offHeapSize, "Total offheap size in bytes.");
        mreg.register("OffheapUsedSize", this::offheapUsedSize, "Total used offheap size in bytes.");
        mreg.register("TotalAllocatedSize", this::totalAllocatedSize, "Total size of memory allocated in bytes.");
        mreg.register("UsedCheckpointBufferPages", this::usedCheckpointBufferPages, "Used checkpoint buffer size in pages.");
        mreg.register("UsedCheckpointBufferSize", this::usedCheckpointBufferSize, "Used checkpoint buffer size in bytes.");
        mreg.register("CheckpointBufferSize", this::checkpointBufferSize, "Checkpoint buffer size in bytes.");
    }

    private int walArchiveSegments() {
        if (!this.metricsEnabled) {
            return 0;
        }
        IgniteWriteAheadLogManager walMgr = this.wal;
        return walMgr == null ? 0 : walMgr.walArchiveSegments();
    }

    private float walFsyncTimeAverage() {
        if (!this.metricsEnabled) {
            return 0.0f;
        }
        long numRate = this.walFsyncTimeNum.value();
        if (numRate == 0L) {
            return 0.0f;
        }
        return (float)this.walFsyncTimeDuration.value() / (float)numRate;
    }

    private long walTotalSize() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        IgniteOutClosure<Long> walSize = this.walSizeProvider;
        return walSize != null ? walSize.apply() : 0L;
    }

    private long dirtyPages() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        Collection<DataRegionMetrics> regionMetrics0 = this.regionMetrics;
        if (F.isEmpty(regionMetrics0)) {
            return 0L;
        }
        long dirtyPages = 0L;
        for (DataRegionMetrics rm : regionMetrics0) {
            dirtyPages += rm.getDirtyPages();
        }
        return dirtyPages;
    }

    private long pagesRead() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        Collection<DataRegionMetrics> regionMetrics0 = this.regionMetrics;
        if (F.isEmpty(regionMetrics0)) {
            return 0L;
        }
        long readPages = 0L;
        for (DataRegionMetrics rm : regionMetrics0) {
            readPages += rm.getPagesRead();
        }
        return readPages;
    }

    private long pagesWritten() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        Collection<DataRegionMetrics> regionMetrics0 = this.regionMetrics;
        if (F.isEmpty(regionMetrics0)) {
            return 0L;
        }
        long writtenPages = 0L;
        for (DataRegionMetrics rm : regionMetrics0) {
            writtenPages += rm.getPagesWritten();
        }
        return writtenPages;
    }

    private long pagesReplaced() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        Collection<DataRegionMetrics> regionMetrics0 = this.regionMetrics;
        if (F.isEmpty(regionMetrics0)) {
            return 0L;
        }
        long replacedPages = 0L;
        for (DataRegionMetrics rm : regionMetrics0) {
            replacedPages += rm.getPagesReplaced();
        }
        return replacedPages;
    }

    private long offHeapSize() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        Collection<DataRegionMetrics> regionMetrics0 = this.regionMetrics;
        if (F.isEmpty(regionMetrics0)) {
            return 0L;
        }
        long offHeapSize = 0L;
        for (DataRegionMetrics rm : regionMetrics0) {
            offHeapSize += rm.getOffHeapSize();
        }
        return offHeapSize;
    }

    private long offheapUsedSize() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        Collection<DataRegionMetrics> regionMetrics0 = this.regionMetrics;
        if (F.isEmpty(regionMetrics0)) {
            return 0L;
        }
        long offHeapUsedSize = 0L;
        for (DataRegionMetrics rm : regionMetrics0) {
            offHeapUsedSize += rm.getOffheapUsedSize();
        }
        return offHeapUsedSize;
    }

    private long totalAllocatedSize() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        Collection<DataRegionMetrics> regionMetrics0 = this.regionMetrics;
        if (F.isEmpty(regionMetrics0)) {
            return 0L;
        }
        long totalAllocatedSize = 0L;
        for (DataRegionMetrics rm : regionMetrics0) {
            totalAllocatedSize += rm.getTotalAllocatedSize();
        }
        return totalAllocatedSize;
    }

    private long usedCheckpointBufferPages() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        Collection<DataRegionMetrics> regionMetrics0 = this.regionMetrics;
        if (F.isEmpty(regionMetrics0)) {
            return 0L;
        }
        long usedCheckpointBufPages = 0L;
        for (DataRegionMetrics rm : regionMetrics0) {
            usedCheckpointBufPages += rm.getUsedCheckpointBufferPages();
        }
        return usedCheckpointBufPages;
    }

    private long usedCheckpointBufferSize() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        Collection<DataRegionMetrics> regionMetrics0 = this.regionMetrics;
        if (F.isEmpty(regionMetrics0)) {
            return 0L;
        }
        long usedCheckpointBufSize = 0L;
        for (DataRegionMetrics rm : regionMetrics0) {
            usedCheckpointBufSize += rm.getUsedCheckpointBufferSize();
        }
        return usedCheckpointBufSize;
    }

    private long checkpointBufferSize() {
        if (!this.metricsEnabled) {
            return 0L;
        }
        Collection<DataRegionMetrics> regionMetrics0 = this.regionMetrics;
        if (F.isEmpty(regionMetrics0)) {
            return 0L;
        }
        long checkpointBufSize = 0L;
        for (DataRegionMetrics rm : regionMetrics0) {
            checkpointBufSize += rm.getCheckpointBufferSize();
        }
        return checkpointBufSize;
    }

    public void wal(IgniteWriteAheadLogManager wal) {
        this.wal = wal;
    }

    public void setWalSizeProvider(IgniteOutClosure<Long> walSizeProvider) {
        this.walSizeProvider = walSizeProvider;
    }

    public void onWallRollOver() {
        if (!this.metricsEnabled) {
            return;
        }
        this.lastWalSegmentRollOverTime.value(U.currentTimeMillis());
    }

    public void regionMetrics(Collection<DataRegionMetrics> regionMetrics) {
        this.regionMetrics = regionMetrics;
    }

    @Deprecated
    public boolean metricsEnabled() {
        return this.metricsEnabled;
    }

    public void onCheckpoint(long beforeLockDuration, long lockWaitDuration, long listenersExecuteDuration, long markDuration, long lockHoldDuration, long pagesWriteDuration, long fsyncDuration, long walRecordFsyncDuration, long writeEntryDuration, long splitAndSortPagesDuration, long duration, long start, long totalPages, long dataPages, long cowPages, long storageSize, long sparseStorageSize) {
        if (!this.metricsEnabled) {
            return;
        }
        this.lastCpBeforeLockDuration.value(beforeLockDuration);
        this.lastCpLockWaitDuration.value(lockWaitDuration);
        this.lastCpListenersExecuteDuration.value(listenersExecuteDuration);
        this.lastCpMarkDuration.value(markDuration);
        this.lastCpLockHoldDuration.value(lockHoldDuration);
        this.lastCpPagesWriteDuration.value(pagesWriteDuration);
        this.lastCpFsyncDuration.value(fsyncDuration);
        this.lastCpWalRecordFsyncDuration.value(walRecordFsyncDuration);
        this.lastCpWriteEntryDuration.value(writeEntryDuration);
        this.lastCpSplitAndSortPagesDuration.value(splitAndSortPagesDuration);
        this.lastCpDuration.value(duration);
        this.lastCpStart.value(start);
        this.lastCpTotalPages.value(totalPages);
        this.lastCpDataPages.value(dataPages);
        this.lastCpCowPages.value(cowPages);
        this.storageSize.value(storageSize);
        this.sparseStorageSize.value(sparseStorageSize);
        this.totalCheckpointTime.add(duration);
        this.cpBeforeLockHistogram.value(beforeLockDuration);
        this.cpLockWaitHistogram.value(lockWaitDuration);
        this.cpListenersExecuteHistogram.value(listenersExecuteDuration);
        this.cpMarkHistogram.value(markDuration);
        this.cpLockHoldHistogram.value(lockHoldDuration);
        this.cpPagesWriteHistogram.value(pagesWriteDuration);
        this.cpFsyncHistogram.value(fsyncDuration);
        this.cpWalRecordFsyncHistogram.value(walRecordFsyncDuration);
        this.cpWriteEntryHistogram.value(writeEntryDuration);
        this.cpSplitAndSortPagesHistogram.value(splitAndSortPagesDuration);
        this.cpHistogram.value(duration);
    }

    public void onWalRecordLogged(long size) {
        if (!this.metricsEnabled) {
            return;
        }
        this.walLoggingRate.increment();
        this.walWrittenBytes.add(size);
        this.walWritingRate.add(size);
    }

    public void onFsync(long nanoTime) {
        if (!this.metricsEnabled) {
            return;
        }
        long microseconds = nanoTime / 1000L;
        this.walFsyncTimeDuration.add(microseconds);
        this.walFsyncTimeNum.increment();
    }

    public void onBuffPollSpin(int num) {
        if (!this.metricsEnabled) {
            return;
        }
        this.walBuffPollSpinsNum.add(num);
    }

    public void onWalSegmentCompressed(long size) {
        if (!this.metricsEnabled) {
            return;
        }
        this.walCompressedBytes.add(size);
    }
}

