/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.internal.GridDirectCollection;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.UnregisteredBinaryTypeException;
import org.apache.ignite.internal.UnregisteredClassException;
import org.apache.ignite.internal.processors.cache.CacheInvokeDirectResult;
import org.apache.ignite.internal.processors.cache.CacheInvokeResult;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.Nullable;

public class GridCacheReturn
implements Externalizable,
Message {
    private static final long serialVersionUID = 0L;
    @GridToStringInclude(sensitive=true)
    @GridDirectTransient
    private volatile Object v;
    private CacheObject cacheObj;
    @GridDirectCollection(value=CacheInvokeDirectResult.class)
    private Collection<CacheInvokeDirectResult> invokeResCol;
    private volatile boolean success;
    private volatile boolean invokeRes;
    @GridDirectTransient
    private transient boolean loc;
    private int cacheId;

    public GridCacheReturn() {
        this.loc = true;
    }

    public GridCacheReturn(boolean loc) {
        this.loc = loc;
    }

    public GridCacheReturn(boolean loc, boolean success) {
        this.loc = loc;
        this.success = success;
    }

    public GridCacheReturn(GridCacheContext cctx, boolean loc, boolean keepBinary, @Nullable ClassLoader ldr, Object v, boolean success) {
        this.loc = loc;
        this.success = success;
        if (v != null) {
            if (v instanceof CacheObject) {
                this.initValue(cctx, (CacheObject)v, keepBinary, ldr);
            } else {
                assert (loc);
                this.v = v;
            }
        }
    }

    @Nullable
    public <V> V value() {
        return (V)this.v;
    }

    public boolean emptyResult() {
        return !this.invokeRes && this.v == null && this.cacheObj == null && this.success;
    }

    public boolean invokeResult() {
        return this.invokeRes;
    }

    public void invokeResult(boolean invokeRes) {
        this.invokeRes = invokeRes;
    }

    public GridCacheReturn value(GridCacheContext cctx, CacheObject v, boolean keepBinary, @Nullable ClassLoader ldr) {
        this.initValue(cctx, v, keepBinary, ldr);
        return this;
    }

    public boolean success() {
        return this.success;
    }

    public GridCacheReturn set(GridCacheContext cctx, @Nullable CacheObject cacheObj, boolean success, boolean keepBinary, @Nullable ClassLoader ldr) {
        this.success = success;
        this.initValue(cctx, cacheObj, keepBinary, ldr);
        return this;
    }

    private void initValue(GridCacheContext cctx, @Nullable CacheObject cacheObj, boolean keepBinary, @Nullable ClassLoader ldr) {
        if (this.loc) {
            this.v = cctx.cacheObjectContext().unwrapBinaryIfNeeded(cacheObj, keepBinary, true, ldr);
        } else {
            assert (this.cacheId == 0 || this.cacheId == cctx.cacheId());
            this.cacheId = cctx.cacheId();
            this.cacheObj = cacheObj;
        }
    }

    public GridCacheReturn success(boolean success) {
        this.success = success;
        return this;
    }

    public synchronized void addEntryProcessResult(GridCacheContext cctx, KeyCacheObject key, @Nullable Object key0, @Nullable Object res, @Nullable Exception err, boolean keepBinary) {
        assert (this.v == null || this.v instanceof Map) : this.v;
        assert (key != null);
        assert (res != null || err != null);
        this.invokeRes = true;
        if (this.loc) {
            CacheInvokeResult<Object> res0;
            HashMap<Object, CacheInvokeResult<Object>> resMap = (HashMap<Object, CacheInvokeResult<Object>>)this.v;
            if (resMap == null) {
                this.v = resMap = new HashMap<Object, CacheInvokeResult<Object>>();
            }
            if (err != null) {
                if (err instanceof UnregisteredClassException) {
                    throw (UnregisteredClassException)err;
                }
                if (err instanceof UnregisteredBinaryTypeException) {
                    throw (UnregisteredBinaryTypeException)err;
                }
            }
            CacheInvokeResult<Object> cacheInvokeResult = res0 = err == null ? CacheInvokeResult.fromResult(res) : CacheInvokeResult.fromError(err);
            Object resKey = key0 != null ? key0 : (keepBinary && key instanceof BinaryObject ? key : CU.value(key, cctx, true));
            resMap.put(resKey, res0);
        } else {
            assert (this.v == null);
            assert (this.cacheId == 0 || this.cacheId == cctx.cacheId());
            this.cacheId = cctx.cacheId();
            if (this.invokeResCol == null) {
                this.invokeResCol = new ArrayList<CacheInvokeDirectResult>();
            }
            CacheInvokeDirectResult res0 = err == null ? (cctx.transactional() ? new CacheInvokeDirectResult(key, cctx.toCacheObject(res)) : CacheInvokeDirectResult.lazyResult(key, res)) : new CacheInvokeDirectResult(key, err);
            this.invokeResCol.add(res0);
        }
    }

    public int cacheId() {
        return this.cacheId;
    }

    public synchronized void mergeEntryProcessResults(GridCacheReturn other) {
        assert (this.invokeRes || this.v == null) : "Invalid state to merge: " + this;
        assert (other.invokeRes);
        assert (this.loc == other.loc) : this.loc;
        if (other.v == null) {
            return;
        }
        this.invokeRes = true;
        HashMap resMap = (HashMap)this.v;
        if (resMap == null) {
            this.v = resMap = new HashMap();
        }
        resMap.putAll((Map)other.v);
    }

    public void marshalResult(GridCacheContext ctx) {
        if (this.invokeRes && this.invokeResCol != null) {
            for (CacheInvokeDirectResult directRes : this.invokeResCol) {
                directRes.marshalResult(ctx);
            }
        }
    }

    public void prepareMarshal(GridCacheContext ctx) throws IgniteCheckedException {
        assert (!this.loc);
        if (this.cacheObj != null) {
            this.cacheObj.prepareMarshal(ctx.cacheObjectContext());
        }
        if (this.invokeRes && this.invokeResCol != null) {
            for (CacheInvokeDirectResult res : this.invokeResCol) {
                res.prepareMarshal(ctx);
            }
        }
    }

    public void finishUnmarshal(GridCacheContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        this.loc = true;
        if (this.cacheObj != null) {
            this.cacheObj.finishUnmarshal(ctx.cacheObjectContext(), ldr);
            this.v = ctx.cacheObjectContext().unwrapBinaryIfNeeded(this.cacheObj, true, false, ldr);
        }
        if (this.invokeRes && this.invokeResCol != null) {
            for (CacheInvokeDirectResult res : this.invokeResCol) {
                res.finishUnmarshal(ctx, ldr);
            }
            HashMap map0 = U.newHashMap(this.invokeResCol.size());
            for (CacheInvokeDirectResult res : this.invokeResCol) {
                CacheInvokeResult res0 = res.error() == null ? CacheInvokeResult.fromResult(ctx.cacheObjectContext().unwrapBinaryIfNeeded(res.result(), true, false, null)) : CacheInvokeResult.fromError(res.error());
                map0.put(ctx.cacheObjectContext().unwrapBinaryIfNeeded(res.key(), true, false, null), res0);
            }
            this.v = map0;
        }
    }

    @Override
    public void onAckReceived() {
    }

    @Override
    public short directType() {
        return 88;
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeInt("cacheId", this.cacheId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeMessage("cacheObj", this.cacheObj)) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                if (!writer.writeBoolean("invokeRes", this.invokeRes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                if (!writer.writeCollection("invokeResCol", this.invokeResCol, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                if (!writer.writeBoolean("success", this.success)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.cacheId = reader.readInt("cacheId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.cacheObj = (CacheObject)reader.readMessage("cacheObj");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.invokeRes = reader.readBoolean("invokeRes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 3: {
                this.invokeResCol = reader.readCollection("invokeResCol", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 4: {
                this.success = reader.readBoolean("success");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridCacheReturn.class);
    }

    @Override
    public byte fieldsCount() {
        return 5;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        assert (false);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        assert (false);
    }

    public String toString() {
        return S.toString(GridCacheReturn.class, this);
    }
}

