/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.rel;

import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.Pair;
import org.apache.ignite3.internal.sql.engine.rel.IgniteConvention;
import org.apache.ignite3.internal.sql.engine.rel.IgniteRel;
import org.apache.ignite3.internal.sql.engine.rel.IgniteRelVisitor;
import org.apache.ignite3.internal.sql.engine.rel.explain.IgniteRelWriter;
import org.apache.ignite3.internal.sql.engine.trait.TraitUtils;
import org.apache.ignite3.internal.sql.engine.trait.TraitsAwareIgniteRel;

public class IgniteFilter
extends Filter
implements TraitsAwareIgniteRel {
    private static final String REL_TYPE_NAME = "Filter";

    public IgniteFilter(RelOptCluster cluster, RelTraitSet traits, RelNode input, RexNode condition) {
        super(cluster, traits, input, condition);
    }

    public IgniteFilter(RelInput input) {
        super(TraitUtils.changeTraits(input, new RelTrait[]{IgniteConvention.INSTANCE}));
    }

    public Filter copy(RelTraitSet traitSet, RelNode input, RexNode condition) {
        return new IgniteFilter(this.getCluster(), traitSet, input, condition);
    }

    @Override
    public <T> T accept(IgniteRelVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public List<Pair<RelTraitSet, List<RelTraitSet>>> deriveDistribution(RelTraitSet nodeTraits, List<RelTraitSet> inTraits) {
        return List.of(Pair.of((Object)nodeTraits.replace((RelTrait)TraitUtils.distribution(inTraits.get(0))), inTraits));
    }

    @Override
    public List<Pair<RelTraitSet, List<RelTraitSet>>> deriveCollation(RelTraitSet nodeTraits, List<RelTraitSet> inTraits) {
        return List.of(Pair.of((Object)nodeTraits.replace((RelTrait)TraitUtils.collation(inTraits.get(0))), inTraits));
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double rowCount = mq.getRowCount(this.getInput());
        return planner.getCostFactory().makeCost(rowCount, rowCount * 4.0, 0.0);
    }

    @Override
    public IgniteRel clone(RelOptCluster cluster, List<IgniteRel> inputs) {
        return new IgniteFilter(cluster, this.getTraitSet(), (RelNode)IgniteFilter.sole(inputs), this.getCondition());
    }

    public String getRelTypeName() {
        return REL_TYPE_NAME;
    }

    @Override
    public IgniteRelWriter explain(IgniteRelWriter writer) {
        return writer.addPredicate(this.condition, this.getInput().getRowType());
    }
}

