/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.ignite3.internal.catalog.Catalog;
import org.apache.ignite3.internal.catalog.CatalogCommand;
import org.apache.ignite3.internal.catalog.CatalogValidationException;
import org.apache.ignite3.internal.catalog.UpdateContext;
import org.apache.ignite3.internal.catalog.commands.AbstractTableCommand;
import org.apache.ignite3.internal.catalog.commands.CatalogUtils;
import org.apache.ignite3.internal.catalog.commands.DropTableCommandBuilder;
import org.apache.ignite3.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite3.internal.catalog.storage.DropTableEntry;
import org.apache.ignite3.internal.catalog.storage.RemoveIndexEntry;
import org.apache.ignite3.internal.catalog.storage.UpdateEntry;

public class DropTableCommand
extends AbstractTableCommand {
    public static DropTableCommandBuilder builder() {
        return new Builder();
    }

    private DropTableCommand(String schemaName, String tableName, boolean ifExists) throws CatalogValidationException {
        super(schemaName, tableName, ifExists, true);
    }

    @Override
    public List<UpdateEntry> get(UpdateContext updateContext) {
        Catalog catalog = updateContext.catalog();
        CatalogSchemaDescriptor schema = CatalogUtils.schema(catalog, this.schemaName, !this.ifTableExists);
        if (schema == null) {
            return List.of();
        }
        CatalogTableDescriptor table = CatalogUtils.table(schema, this.tableName, !this.ifTableExists);
        if (table == null) {
            return List.of();
        }
        ArrayList<UpdateEntry> updateEntries = new ArrayList<UpdateEntry>();
        Arrays.stream(schema.indexes()).filter(index -> index.tableId() == table.id()).forEach(index -> updateEntries.add(new RemoveIndexEntry(index.id())));
        updateEntries.add(new DropTableEntry(table.id()));
        return updateEntries;
    }

    private static class Builder
    implements DropTableCommandBuilder {
        private String schemaName;
        private String tableName;
        private boolean ifExists;

        private Builder() {
        }

        @Override
        public DropTableCommandBuilder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        @Override
        public DropTableCommandBuilder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        @Override
        public DropTableCommandBuilder ifTableExists(boolean ifTableExists) {
            this.ifExists = ifTableExists;
            return this;
        }

        @Override
        public CatalogCommand build() {
            return new DropTableCommand(this.schemaName, this.tableName, this.ifExists);
        }
    }
}

