/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.fun;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlBasicFunction;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.fun.LibraryOperator;
import org.apache.calcite.sql.fun.SqlBasicAggFunction;
import org.apache.calcite.sql.fun.SqlBitOpAggFunction;
import org.apache.calcite.sql.fun.SqlCastFunction;
import org.apache.calcite.sql.fun.SqlCastOperator;
import org.apache.calcite.sql.fun.SqlExtractFunction;
import org.apache.calcite.sql.fun.SqlFloorFunction;
import org.apache.calcite.sql.fun.SqlItemOperator;
import org.apache.calcite.sql.fun.SqlJsonDepthFunction;
import org.apache.calcite.sql.fun.SqlJsonKeysFunction;
import org.apache.calcite.sql.fun.SqlJsonLengthFunction;
import org.apache.calcite.sql.fun.SqlJsonModifyFunction;
import org.apache.calcite.sql.fun.SqlJsonPrettyFunction;
import org.apache.calcite.sql.fun.SqlJsonRemoveFunction;
import org.apache.calcite.sql.fun.SqlJsonStorageSizeFunction;
import org.apache.calcite.sql.fun.SqlJsonTypeFunction;
import org.apache.calcite.sql.fun.SqlLibrary;
import org.apache.calcite.sql.fun.SqlLikeOperator;
import org.apache.calcite.sql.fun.SqlMinMaxAggFunction;
import org.apache.calcite.sql.fun.SqlPositionFunction;
import org.apache.calcite.sql.fun.SqlRegexpReplaceFunction;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.fun.SqlTimestampAddFunction;
import org.apache.calcite.sql.fun.SqlTimestampDiffFunction;
import org.apache.calcite.sql.fun.SqlTranslate3Function;
import org.apache.calcite.sql.type.InferTypes;
import org.apache.calcite.sql.type.OperandHandlers;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeTransforms;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.util.Litmus;
import org.apache.calcite.util.Optionality;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Static;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class SqlLibraryOperators {
    @LibraryOperator(libraries={SqlLibrary.CALCITE})
    public static final SqlFunction AGGREGATE = SqlBasicAggFunction.create("AGGREGATE", SqlKind.AGGREGATE_FN, ReturnTypes.ARG0, OperandTypes.MEASURE);
    @LibraryOperator(libraries={SqlLibrary.POSTGRESQL})
    public static final SqlFunction CONVERT_TIMEZONE = SqlBasicFunction.create("CONVERT_TIMEZONE", ReturnTypes.DATE_NULLABLE, OperandTypes.CHARACTER_CHARACTER_DATETIME, SqlFunctionCategory.TIMEDATE);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction DATE_ADD = SqlBasicFunction.create(SqlKind.DATE_ADD, ReturnTypes.ARG0_NULLABLE, (SqlOperandTypeChecker)OperandTypes.DATE_INTERVAL).withFunctionType(SqlFunctionCategory.TIMEDATE);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction DATE_DIFF = new SqlTimestampDiffFunction("DATE_DIFF", OperandTypes.family(SqlTypeFamily.DATE, SqlTypeFamily.DATE, SqlTypeFamily.ANY));
    @LibraryOperator(libraries={SqlLibrary.MSSQL, SqlLibrary.POSTGRESQL})
    public static final SqlFunction DATEADD = new SqlTimestampAddFunction("DATEADD");
    @LibraryOperator(libraries={SqlLibrary.MSSQL, SqlLibrary.POSTGRESQL})
    public static final SqlFunction DATEDIFF = new SqlTimestampDiffFunction("DATEDIFF", OperandTypes.family(SqlTypeFamily.ANY, SqlTypeFamily.DATE, SqlTypeFamily.DATE));
    @LibraryOperator(libraries={SqlLibrary.MSSQL})
    public static final SqlFunction MSSQL_CONVERT = SqlBasicFunction.create(SqlKind.CAST, ReturnTypes.andThen(SqlLibraryOperators::transformConvert, SqlCastFunction.returnTypeInference(false)), OperandTypes.repeat(SqlOperandCountRanges.between(2, 3), OperandTypes.ANY)).withName("CONVERT").withFunctionType(SqlFunctionCategory.SYSTEM).withOperandTypeInference(InferTypes.FIRST_KNOWN).withOperandHandler(OperandHandlers.of(SqlLibraryOperators::transformConvert));
    @LibraryOperator(libraries={SqlLibrary.POSTGRESQL})
    public static final SqlFunction DATE_PART = new SqlExtractFunction("DATE_PART"){

        @Override
        public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
            this.getSyntax().unparse(writer, this, call, leftPrec, rightPrec);
        }
    };
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction DATE_SUB = SqlBasicFunction.create(SqlKind.DATE_SUB, ReturnTypes.ARG0_NULLABLE, (SqlOperandTypeChecker)OperandTypes.DATE_INTERVAL).withFunctionType(SqlFunctionCategory.TIMEDATE);
    @LibraryOperator(libraries={SqlLibrary.MSSQL})
    public static final SqlFunction DATEPART = new SqlExtractFunction("DATEPART"){

        @Override
        public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
            this.getSyntax().unparse(writer, this, call, leftPrec, rightPrec);
        }
    };
    private static final SqlReturnTypeInference DECODE_RETURN_TYPE = opBinding -> {
        ArrayList<RelDataType> list = new ArrayList<RelDataType>();
        int n = opBinding.getOperandCount();
        for (int i = 1; i < n; ++i) {
            if (i < n - 1) {
                ++i;
            }
            list.add(opBinding.getOperandType(i));
        }
        RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
        RelDataType type = typeFactory.leastRestrictive(list);
        if (type != null && opBinding.getOperandCount() % 2 == 1) {
            type = typeFactory.createTypeWithNullability(type, true);
        }
        return type;
    };
    @LibraryOperator(libraries={SqlLibrary.ORACLE, SqlLibrary.SPARK})
    public static final SqlFunction DECODE = SqlBasicFunction.create(SqlKind.DECODE, DECODE_RETURN_TYPE, OperandTypes.VARIADIC);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY, SqlLibrary.HIVE, SqlLibrary.SPARK})
    public static final SqlFunction IF = new SqlFunction("IF", SqlKind.IF, SqlLibraryOperators::inferIfReturnType, null, OperandTypes.family(SqlTypeFamily.BOOLEAN, SqlTypeFamily.ANY, SqlTypeFamily.ANY).and(OperandTypes.same(3, 1, 2)), SqlFunctionCategory.SYSTEM){

        @Override
        public boolean validRexOperands(int count, Litmus litmus) {
            return litmus.fail("not a rex operator", new Object[0]);
        }
    };
    @LibraryOperator(libraries={SqlLibrary.ORACLE, SqlLibrary.SPARK})
    public static final SqlBasicFunction NVL = SqlBasicFunction.create(SqlKind.NVL, ReturnTypes.LEAST_RESTRICTIVE.andThen(SqlTypeTransforms.TO_NULLABLE_ALL), (SqlOperandTypeChecker)OperandTypes.SAME_SAME);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY, SqlLibrary.SPARK})
    public static final SqlFunction IFNULL = NVL.withName("IFNULL");
    @LibraryOperator(libraries={SqlLibrary.SNOWFLAKE, SqlLibrary.SPARK})
    public static final SqlFunction LEN = SqlStdOperatorTable.CHAR_LENGTH.withName("LEN");
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY, SqlLibrary.SNOWFLAKE, SqlLibrary.SPARK})
    public static final SqlFunction LENGTH = SqlStdOperatorTable.CHAR_LENGTH.withName("LENGTH");
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY, SqlLibrary.ORACLE, SqlLibrary.SPARK})
    public static final SqlFunction LPAD = SqlBasicFunction.create("LPAD", ReturnTypes.ARG0.andThen(SqlLibraryOperators::deriveTypePad), OperandTypes.STRING_NUMERIC_OPTIONAL_STRING, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY, SqlLibrary.ORACLE, SqlLibrary.SPARK})
    public static final SqlFunction RPAD = SqlBasicFunction.create("RPAD", ReturnTypes.ARG0.andThen(SqlLibraryOperators::deriveTypePad), OperandTypes.STRING_NUMERIC_OPTIONAL_STRING, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY, SqlLibrary.ORACLE, SqlLibrary.SPARK})
    public static final SqlFunction LTRIM = SqlBasicFunction.create(SqlKind.LTRIM, ReturnTypes.ARG0.andThen(SqlTypeTransforms.TO_NULLABLE).andThen(SqlTypeTransforms.TO_VARYING), (SqlOperandTypeChecker)OperandTypes.STRING).withFunctionType(SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY, SqlLibrary.ORACLE, SqlLibrary.SPARK})
    public static final SqlFunction RTRIM = SqlBasicFunction.create(SqlKind.RTRIM, ReturnTypes.ARG0.andThen(SqlTypeTransforms.TO_NULLABLE).andThen(SqlTypeTransforms.TO_VARYING), (SqlOperandTypeChecker)OperandTypes.STRING).withFunctionType(SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction SPLIT = SqlBasicFunction.create("SPLIT", ReturnTypes.ARG0.andThen(SqlLibraryOperators::deriveTypeSplit).andThen(SqlTypeTransforms.TO_ARRAY_NULLABLE), OperandTypes.or(OperandTypes.CHARACTER_CHARACTER, OperandTypes.CHARACTER, OperandTypes.BINARY_BINARY, OperandTypes.BINARY), SqlFunctionCategory.STRING).withValidation(3);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY, SqlLibrary.POSTGRESQL})
    public static final SqlFunction STRPOS = new SqlPositionFunction("STRPOS");
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY, SqlLibrary.MYSQL, SqlLibrary.ORACLE})
    public static final SqlFunction INSTR = new SqlPositionFunction("INSTR");
    private static final SqlBasicFunction SUBSTR = SqlBasicFunction.create("SUBSTR", ReturnTypes.ARG0_NULLABLE_VARYING, OperandTypes.STRING_INTEGER_OPTIONAL_INTEGER, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY, SqlLibrary.POSTGRESQL})
    public static final SqlBasicFunction ENDS_WITH = SqlBasicFunction.create(SqlKind.ENDS_WITH, ReturnTypes.BOOLEAN_NULLABLE, (SqlOperandTypeChecker)OperandTypes.STRING_SAME_SAME);
    @LibraryOperator(libraries={SqlLibrary.SNOWFLAKE, SqlLibrary.SPARK})
    public static final SqlFunction ENDSWITH = ENDS_WITH.withName("ENDSWITH");
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY, SqlLibrary.POSTGRESQL})
    public static final SqlBasicFunction STARTS_WITH = SqlBasicFunction.create(SqlKind.STARTS_WITH, ReturnTypes.BOOLEAN_NULLABLE, (SqlOperandTypeChecker)OperandTypes.STRING_SAME_SAME);
    @LibraryOperator(libraries={SqlLibrary.SNOWFLAKE, SqlLibrary.SPARK})
    public static final SqlFunction STARTSWITH = STARTS_WITH.withName("STARTSWITH");
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction SUBSTR_BIG_QUERY = SUBSTR.withKind(SqlKind.SUBSTR_BIG_QUERY);
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlFunction SUBSTR_MYSQL = SUBSTR.withKind(SqlKind.SUBSTR_MYSQL);
    @LibraryOperator(libraries={SqlLibrary.ORACLE})
    public static final SqlFunction SUBSTR_ORACLE = SUBSTR.withKind(SqlKind.SUBSTR_ORACLE);
    @LibraryOperator(libraries={SqlLibrary.POSTGRESQL})
    public static final SqlFunction SUBSTR_POSTGRESQL = SUBSTR.withKind(SqlKind.SUBSTR_POSTGRESQL);
    @LibraryOperator(libraries={SqlLibrary.HIVE, SqlLibrary.SPARK})
    public static final SqlFunction PARSE_URL = SqlBasicFunction.create("PARSE_URL", ReturnTypes.VARCHAR_NULLABLE, OperandTypes.STRING_STRING_OPTIONAL_STRING, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.HIVE, SqlLibrary.SPARK})
    public static final SqlFunction FIND_IN_SET = SqlBasicFunction.create("FIND_IN_SET", ReturnTypes.INTEGER_NULLABLE, OperandTypes.STRING_STRING, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY, SqlLibrary.ORACLE, SqlLibrary.SPARK})
    public static final SqlFunction GREATEST = SqlBasicFunction.create(SqlKind.GREATEST, ReturnTypes.LEAST_RESTRICTIVE.andThen(SqlTypeTransforms.TO_NULLABLE), OperandTypes.SAME_VARIADIC);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY, SqlLibrary.ORACLE, SqlLibrary.SPARK})
    public static final SqlFunction LEAST = SqlBasicFunction.create(SqlKind.LEAST, ReturnTypes.LEAST_RESTRICTIVE.andThen(SqlTypeTransforms.TO_NULLABLE), OperandTypes.SAME_VARIADIC);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction CEIL_BIG_QUERY = new SqlFloorFunction(SqlKind.CEIL).withName("CEIL_BIG_QUERY").withReturnTypeInference(ReturnTypes.ARG0_EXCEPT_INTEGER_NULLABLE);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction FLOOR_BIG_QUERY = new SqlFloorFunction(SqlKind.FLOOR).withName("FLOOR_BIG_QUERY").withReturnTypeInference(ReturnTypes.ARG0_EXCEPT_INTEGER_NULLABLE);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY, SqlLibrary.ORACLE, SqlLibrary.POSTGRESQL, SqlLibrary.SPARK})
    public static final SqlFunction TRANSLATE3 = new SqlTranslate3Function();
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlFunction JSON_TYPE = new SqlJsonTypeFunction();
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlFunction JSON_DEPTH = new SqlJsonDepthFunction();
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlFunction JSON_LENGTH = new SqlJsonLengthFunction();
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlFunction JSON_KEYS = new SqlJsonKeysFunction();
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlFunction JSON_PRETTY = new SqlJsonPrettyFunction();
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlFunction JSON_REMOVE = new SqlJsonRemoveFunction();
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlFunction JSON_STORAGE_SIZE = new SqlJsonStorageSizeFunction();
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlFunction JSON_INSERT = new SqlJsonModifyFunction("JSON_INSERT");
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlFunction JSON_REPLACE = new SqlJsonModifyFunction("JSON_REPLACE");
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlFunction JSON_SET = new SqlJsonModifyFunction("JSON_SET");
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction REGEXP_CONTAINS = SqlBasicFunction.create("REGEXP_CONTAINS", ReturnTypes.BOOLEAN_NULLABLE, OperandTypes.STRING_STRING, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlBasicFunction REGEXP_EXTRACT = SqlBasicFunction.create("REGEXP_EXTRACT", ReturnTypes.VARCHAR_NULLABLE, OperandTypes.STRING_STRING_OPTIONAL_INTEGER_OPTIONAL_INTEGER, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlBasicFunction REGEXP_EXTRACT_ALL = SqlBasicFunction.create("REGEXP_EXTRACT_ALL", ReturnTypes.ARG0_NULLABLE.andThen(SqlTypeTransforms.TO_ARRAY), OperandTypes.STRING_STRING, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlBasicFunction REGEXP_INSTR = SqlBasicFunction.create("REGEXP_INSTR", ReturnTypes.INTEGER_NULLABLE, OperandTypes.STRING_STRING_OPTIONAL_INTEGER_OPTIONAL_INTEGER_OPTIONAL_INTEGER, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY, SqlLibrary.MYSQL, SqlLibrary.ORACLE})
    public static final SqlFunction REGEXP_REPLACE = new SqlRegexpReplaceFunction();
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction REGEXP_SUBSTR = REGEXP_EXTRACT.withName("REGEXP_SUBSTR");
    @LibraryOperator(libraries={SqlLibrary.SPARK})
    public static final SqlFunction REGEXP = SqlBasicFunction.create("REGEXP", ReturnTypes.BOOLEAN_NULLABLE, OperandTypes.STRING_STRING, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.SPARK, SqlLibrary.MYSQL, SqlLibrary.POSTGRESQL, SqlLibrary.ORACLE})
    public static final SqlFunction REGEXP_LIKE = SqlBasicFunction.create("REGEXP_LIKE", ReturnTypes.BOOLEAN_NULLABLE, OperandTypes.STRING_STRING_OPTIONAL_STRING, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlFunction COMPRESS = SqlBasicFunction.create("COMPRESS", ReturnTypes.VARBINARY_NULLABLE, OperandTypes.STRING, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.SPARK})
    public static final SqlFunction URL_DECODE = SqlBasicFunction.create("URL_DECODE", ReturnTypes.VARCHAR_NULLABLE, OperandTypes.STRING, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.SPARK})
    public static final SqlFunction URL_ENCODE = SqlBasicFunction.create("URL_ENCODE", ReturnTypes.VARCHAR_NULLABLE, OperandTypes.STRING, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlFunction EXTRACT_VALUE = SqlBasicFunction.create("EXTRACTVALUE", ReturnTypes.VARCHAR_2000.andThen(SqlTypeTransforms.FORCE_NULLABLE), OperandTypes.STRING_STRING, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.ORACLE})
    public static final SqlFunction XML_TRANSFORM = SqlBasicFunction.create("XMLTRANSFORM", ReturnTypes.VARCHAR.andThen(SqlTypeTransforms.FORCE_NULLABLE), OperandTypes.STRING_STRING, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.ORACLE})
    public static final SqlFunction EXTRACT_XML = SqlBasicFunction.create("EXTRACT", ReturnTypes.VARCHAR.andThen(SqlTypeTransforms.FORCE_NULLABLE), OperandTypes.STRING_STRING_OPTIONAL_STRING, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.ORACLE})
    public static final SqlFunction EXISTS_NODE = SqlBasicFunction.create("EXISTSNODE", ReturnTypes.INTEGER_NULLABLE.andThen(SqlTypeTransforms.FORCE_NULLABLE), OperandTypes.STRING_STRING_OPTIONAL_STRING, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.POSTGRESQL, SqlLibrary.SPARK})
    public static final SqlAggFunction BOOL_AND = new SqlMinMaxAggFunction("BOOL_AND", SqlKind.MIN, OperandTypes.BOOLEAN);
    @LibraryOperator(libraries={SqlLibrary.POSTGRESQL, SqlLibrary.SPARK})
    public static final SqlAggFunction BOOL_OR = new SqlMinMaxAggFunction("BOOL_OR", SqlKind.MAX, OperandTypes.BOOLEAN);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlAggFunction LOGICAL_AND = new SqlMinMaxAggFunction("LOGICAL_AND", SqlKind.MIN, OperandTypes.BOOLEAN);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlAggFunction LOGICAL_OR = new SqlMinMaxAggFunction("LOGICAL_OR", SqlKind.MAX, OperandTypes.BOOLEAN);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlAggFunction COUNTIF = SqlBasicAggFunction.create(SqlKind.COUNTIF, ReturnTypes.BIGINT, OperandTypes.BOOLEAN).withDistinct(Optionality.FORBIDDEN);
    @LibraryOperator(libraries={SqlLibrary.POSTGRESQL, SqlLibrary.BIG_QUERY})
    public static final SqlAggFunction ARRAY_AGG = SqlBasicAggFunction.create(SqlKind.ARRAY_AGG, ReturnTypes.andThen(ReturnTypes::stripOrderBy, ReturnTypes.TO_ARRAY), OperandTypes.ANY).withFunctionType(SqlFunctionCategory.SYSTEM).withSyntax(SqlSyntax.ORDERED_FUNCTION).withAllowsNullTreatment(true);
    @LibraryOperator(libraries={SqlLibrary.POSTGRESQL, SqlLibrary.BIG_QUERY})
    public static final SqlAggFunction ARRAY_CONCAT_AGG = SqlBasicAggFunction.create(SqlKind.ARRAY_CONCAT_AGG, ReturnTypes.ARG0, OperandTypes.ARRAY).withFunctionType(SqlFunctionCategory.SYSTEM).withSyntax(SqlSyntax.ORDERED_FUNCTION);
    @LibraryOperator(libraries={SqlLibrary.POSTGRESQL, SqlLibrary.BIG_QUERY})
    public static final SqlAggFunction STRING_AGG = SqlBasicAggFunction.create(SqlKind.STRING_AGG, ReturnTypes.ARG0_NULLABLE, OperandTypes.STRING.or(OperandTypes.STRING_STRING)).withFunctionType(SqlFunctionCategory.SYSTEM).withSyntax(SqlSyntax.ORDERED_FUNCTION);
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlAggFunction GROUP_CONCAT = SqlBasicAggFunction.create(SqlKind.GROUP_CONCAT, ReturnTypes.andThen(ReturnTypes::stripOrderBy, ReturnTypes.ARG0_NULLABLE), OperandTypes.STRING.or(OperandTypes.STRING_STRING)).withFunctionType(SqlFunctionCategory.SYSTEM).withAllowsNullTreatment(false).withAllowsSeparator(true).withSyntax(SqlSyntax.ORDERED_FUNCTION);
    @LibraryOperator(libraries={SqlLibrary.SPARK})
    public static final SqlAggFunction MAX_BY = SqlStdOperatorTable.ARG_MAX.withName("MAX_BY");
    @LibraryOperator(libraries={SqlLibrary.SPARK})
    public static final SqlAggFunction MIN_BY = SqlStdOperatorTable.ARG_MIN.withName("MIN_BY");
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlAggFunction PERCENTILE_CONT2 = SqlBasicAggFunction.create("PERCENTILE_CONT", SqlKind.PERCENTILE_CONT, ReturnTypes.DOUBLE, OperandTypes.NUMERIC_UNIT_INTERVAL_NUMERIC_LITERAL).withFunctionType(SqlFunctionCategory.SYSTEM).withOver(true).withPercentile(true).withAllowsNullTreatment(true).withAllowsFraming(false);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlAggFunction PERCENTILE_DISC2 = SqlBasicAggFunction.create("PERCENTILE_DISC", SqlKind.PERCENTILE_DISC, ReturnTypes.ARG0, OperandTypes.NUMERIC_UNIT_INTERVAL_NUMERIC_LITERAL).withFunctionType(SqlFunctionCategory.SYSTEM).withOver(true).withPercentile(true).withAllowsNullTreatment(true).withAllowsFraming(false);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction DATE = SqlBasicFunction.create("DATE", ReturnTypes.DATE_NULLABLE, OperandTypes.or(OperandTypes.STRING, OperandTypes.family(SqlTypeFamily.INTEGER, SqlTypeFamily.INTEGER, SqlTypeFamily.INTEGER), OperandTypes.TIMESTAMP_NTZ, OperandTypes.TIMESTAMP_LTZ, OperandTypes.sequence("DATE(TIMESTAMP WITH LOCAL TIME ZONE, VARCHAR)", OperandTypes.TIMESTAMP_LTZ, OperandTypes.CHARACTER)), SqlFunctionCategory.TIMEDATE);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction DATETIME = SqlBasicFunction.create("DATETIME", ReturnTypes.TIMESTAMP_NULLABLE, OperandTypes.or(OperandTypes.family(SqlTypeFamily.INTEGER, SqlTypeFamily.INTEGER, SqlTypeFamily.INTEGER, SqlTypeFamily.INTEGER, SqlTypeFamily.INTEGER, SqlTypeFamily.INTEGER), OperandTypes.DATE, OperandTypes.DATE_TIME, OperandTypes.TIMESTAMP_LTZ, OperandTypes.sequence("DATETIME(TIMESTAMP WITH LOCAL TIME ZONE, VARCHAR)", OperandTypes.TIMESTAMP_LTZ, OperandTypes.CHARACTER)), SqlFunctionCategory.TIMEDATE);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction TIME = SqlBasicFunction.create("TIME", ReturnTypes.TIME_NULLABLE, OperandTypes.or(OperandTypes.family(SqlTypeFamily.INTEGER, SqlTypeFamily.INTEGER, SqlTypeFamily.INTEGER), OperandTypes.TIMESTAMP_NTZ, OperandTypes.TIMESTAMP_LTZ, OperandTypes.sequence("TIME(TIMESTAMP WITH LOCAL TIME ZONE, VARCHAR)", OperandTypes.TIMESTAMP_LTZ, OperandTypes.CHARACTER)), SqlFunctionCategory.TIMEDATE);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction TIMESTAMP = SqlBasicFunction.create("TIMESTAMP", ReturnTypes.TIMESTAMP_LTZ.andThen(SqlTypeTransforms.TO_NULLABLE), OperandTypes.or(OperandTypes.CHARACTER, OperandTypes.CHARACTER_CHARACTER, OperandTypes.DATE, OperandTypes.DATE_CHARACTER, OperandTypes.TIMESTAMP_NTZ, OperandTypes.sequence("TIMESTAMP(TIMESTAMP, VARCHAR)", OperandTypes.TIMESTAMP_NTZ, OperandTypes.CHARACTER)), SqlFunctionCategory.TIMEDATE);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction CURRENT_DATETIME = SqlBasicFunction.create("CURRENT_DATETIME", ReturnTypes.TIMESTAMP_NULLABLE, OperandTypes.NILADIC.or(OperandTypes.STRING), SqlFunctionCategory.TIMEDATE).withSyntax(SqlSyntax.FUNCTION_ID);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY, SqlLibrary.SPARK})
    public static final SqlFunction DATE_FROM_UNIX_DATE = SqlBasicFunction.create("DATE_FROM_UNIX_DATE", ReturnTypes.DATE_NULLABLE, OperandTypes.INTEGER, SqlFunctionCategory.TIMEDATE);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY, SqlLibrary.SPARK})
    public static final SqlFunction UNIX_DATE = SqlBasicFunction.create("UNIX_DATE", ReturnTypes.INTEGER_NULLABLE, OperandTypes.DATE, SqlFunctionCategory.TIMEDATE);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction CONTAINS_SUBSTR = SqlBasicFunction.create("CONTAINS_SUBSTR", ReturnTypes.BOOLEAN_NULLABLE, OperandTypes.ANY_STRING_OPTIONAL_STRING, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlFunction MONTHNAME = SqlBasicFunction.create("MONTHNAME", ReturnTypes.VARCHAR_2000, OperandTypes.DATETIME, SqlFunctionCategory.TIMEDATE);
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlFunction DAYNAME = SqlBasicFunction.create("DAYNAME", ReturnTypes.VARCHAR_2000, OperandTypes.DATETIME, SqlFunctionCategory.TIMEDATE);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY, SqlLibrary.MYSQL, SqlLibrary.POSTGRESQL, SqlLibrary.SPARK})
    public static final SqlFunction LEFT = SqlBasicFunction.create("LEFT", ReturnTypes.ARG0_NULLABLE_VARYING, OperandTypes.CBSTRING_INTEGER, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY, SqlLibrary.MYSQL, SqlLibrary.POSTGRESQL, SqlLibrary.SPARK})
    public static final SqlFunction REPEAT = SqlBasicFunction.create("REPEAT", ReturnTypes.VARCHAR_NULLABLE, OperandTypes.STRING_INTEGER, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY, SqlLibrary.MYSQL, SqlLibrary.POSTGRESQL, SqlLibrary.SPARK})
    public static final SqlFunction RIGHT = SqlBasicFunction.create("RIGHT", ReturnTypes.ARG0_NULLABLE_VARYING, OperandTypes.CBSTRING_INTEGER, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.MYSQL, SqlLibrary.SPARK})
    public static final SqlFunction SPACE = SqlBasicFunction.create("SPACE", ReturnTypes.VARCHAR_NULLABLE, OperandTypes.INTEGER, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlFunction STRCMP = SqlBasicFunction.create("STRCMP", ReturnTypes.INTEGER_NULLABLE, OperandTypes.STRING_STRING, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY, SqlLibrary.MYSQL, SqlLibrary.POSTGRESQL, SqlLibrary.ORACLE})
    public static final SqlFunction SOUNDEX = SqlBasicFunction.create("SOUNDEX", ReturnTypes.VARCHAR_4_NULLABLE, OperandTypes.CHARACTER, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.SPARK})
    public static final SqlFunction SOUNDEX_SPARK = ((SqlBasicFunction)SOUNDEX).withKind(SqlKind.SOUNDEX_SPARK).withReturnTypeInference(ReturnTypes.VARCHAR_NULLABLE);
    @LibraryOperator(libraries={SqlLibrary.POSTGRESQL})
    public static final SqlFunction DIFFERENCE = SqlBasicFunction.create("DIFFERENCE", ReturnTypes.INTEGER_NULLABLE, OperandTypes.STRING_STRING, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.POSTGRESQL})
    public static final SqlSpecialOperator ILIKE = new SqlLikeOperator("ILIKE", SqlKind.LIKE, false, false);
    @LibraryOperator(libraries={SqlLibrary.POSTGRESQL})
    public static final SqlSpecialOperator NOT_ILIKE = new SqlLikeOperator("NOT ILIKE", SqlKind.LIKE, true, false);
    @LibraryOperator(libraries={SqlLibrary.SPARK, SqlLibrary.HIVE})
    public static final SqlSpecialOperator RLIKE = new SqlLikeOperator("RLIKE", SqlKind.RLIKE, false, true);
    @LibraryOperator(libraries={SqlLibrary.SPARK, SqlLibrary.HIVE})
    public static final SqlSpecialOperator NOT_RLIKE = new SqlLikeOperator("NOT RLIKE", SqlKind.RLIKE, true, true);
    @LibraryOperator(libraries={SqlLibrary.MYSQL, SqlLibrary.BIG_QUERY})
    public static final SqlFunction CONCAT_FUNCTION = SqlBasicFunction.create("CONCAT", ReturnTypes.MULTIVALENT_STRING_SUM_PRECISION_NULLABLE, OperandTypes.repeat(SqlOperandCountRanges.from(1), OperandTypes.STRING), SqlFunctionCategory.STRING).withOperandTypeInference(InferTypes.RETURN_TYPE);
    @LibraryOperator(libraries={SqlLibrary.MSSQL, SqlLibrary.POSTGRESQL})
    public static final SqlFunction CONCAT_FUNCTION_WITH_NULL = SqlBasicFunction.create("CONCAT", ReturnTypes.MULTIVALENT_STRING_SUM_PRECISION_NOT_NULLABLE, OperandTypes.repeat(SqlOperandCountRanges.from(1), OperandTypes.STRING), SqlFunctionCategory.STRING).withOperandTypeInference(InferTypes.RETURN_TYPE).withKind(SqlKind.CONCAT_WITH_NULL);
    @LibraryOperator(libraries={SqlLibrary.ORACLE})
    public static final SqlFunction CONCAT2 = SqlBasicFunction.create("CONCAT", ReturnTypes.MULTIVALENT_STRING_SUM_PRECISION_NULLABLE_ALL, OperandTypes.STRING_SAME_SAME, SqlFunctionCategory.STRING).withOperandTypeInference(InferTypes.RETURN_TYPE).withKind(SqlKind.CONCAT2);
    @LibraryOperator(libraries={SqlLibrary.MYSQL, SqlLibrary.POSTGRESQL})
    public static final SqlFunction CONCAT_WS = SqlBasicFunction.create("CONCAT_WS", ReturnTypes.MULTIVALENT_STRING_WITH_SEP_SUM_PRECISION_ARG0_NULLABLE, OperandTypes.repeat(SqlOperandCountRanges.from(2), OperandTypes.STRING), SqlFunctionCategory.STRING).withOperandTypeInference(InferTypes.RETURN_TYPE);
    @LibraryOperator(libraries={SqlLibrary.MSSQL})
    public static final SqlFunction CONCAT_WS_MSSQL = SqlBasicFunction.create("CONCAT_WS", ReturnTypes.MULTIVALENT_STRING_WITH_SEP_SUM_PRECISION_NOT_NULLABLE, OperandTypes.repeat(SqlOperandCountRanges.between(3, 254), OperandTypes.STRING), SqlFunctionCategory.STRING).withOperandTypeInference(InferTypes.RETURN_TYPE).withKind(SqlKind.CONCAT_WS_MSSQL);
    @LibraryOperator(libraries={SqlLibrary.SPARK})
    public static final SqlFunction ARRAY = SqlBasicFunction.create("ARRAY", SqlLibraryOperators::arrayReturnType, OperandTypes.ARRAY_FUNCTION, SqlFunctionCategory.SYSTEM);
    @LibraryOperator(libraries={SqlLibrary.SPARK})
    public static final SqlFunction MAP = SqlBasicFunction.create("MAP", SqlLibraryOperators::mapReturnType, OperandTypes.MAP_FUNCTION, SqlFunctionCategory.SYSTEM);
    @LibraryOperator(libraries={SqlLibrary.SPARK})
    public static final SqlFunction ARRAY_APPEND = SqlBasicFunction.create(SqlKind.ARRAY_APPEND, SqlLibraryOperators::arrayAppendPrependReturnType, OperandTypes.ARRAY_ELEMENT_NONNULL);
    @LibraryOperator(libraries={SqlLibrary.SPARK})
    public static final SqlFunction EXISTS = SqlBasicFunction.create("EXISTS", ReturnTypes.BOOLEAN_NULLABLE, OperandTypes.EXISTS);
    @LibraryOperator(libraries={SqlLibrary.SPARK})
    public static final SqlFunction ARRAY_COMPACT = SqlBasicFunction.create(SqlKind.ARRAY_COMPACT, SqlLibraryOperators::arrayCompactReturnType, (SqlOperandTypeChecker)OperandTypes.ARRAY);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction ARRAY_CONCAT = SqlBasicFunction.create(SqlKind.ARRAY_CONCAT, ReturnTypes.LEAST_RESTRICTIVE, OperandTypes.AT_LEAST_ONE_SAME_VARIADIC);
    @LibraryOperator(libraries={SqlLibrary.SPARK})
    public static final SqlFunction ARRAY_CONTAINS = SqlBasicFunction.create(SqlKind.ARRAY_CONTAINS, ReturnTypes.BOOLEAN_NULLABLE, OperandTypes.ARRAY_ELEMENT_NONNULL);
    @LibraryOperator(libraries={SqlLibrary.SPARK})
    public static final SqlFunction ARRAY_DISTINCT = SqlBasicFunction.create(SqlKind.ARRAY_DISTINCT, ReturnTypes.ARG0_NULLABLE, (SqlOperandTypeChecker)OperandTypes.ARRAY);
    @LibraryOperator(libraries={SqlLibrary.SPARK})
    public static final SqlFunction ARRAY_EXCEPT = SqlBasicFunction.create(SqlKind.ARRAY_EXCEPT, ReturnTypes.LEAST_RESTRICTIVE, (SqlOperandTypeChecker)OperandTypes.and(OperandTypes.NONNULL_NONNULL, OperandTypes.SAME_SAME, OperandTypes.family(SqlTypeFamily.ARRAY, SqlTypeFamily.ARRAY)));
    @LibraryOperator(libraries={SqlLibrary.SPARK})
    public static final SqlFunction ARRAY_INSERT = SqlBasicFunction.create(SqlKind.ARRAY_INSERT, SqlLibraryOperators::arrayInsertReturnType, OperandTypes.ARRAY_INSERT);
    @LibraryOperator(libraries={SqlLibrary.SPARK})
    public static final SqlFunction ARRAY_INTERSECT = SqlBasicFunction.create(SqlKind.ARRAY_INTERSECT, ReturnTypes.LEAST_RESTRICTIVE, (SqlOperandTypeChecker)OperandTypes.and(OperandTypes.NONNULL_NONNULL, OperandTypes.SAME_SAME, OperandTypes.family(SqlTypeFamily.ARRAY, SqlTypeFamily.ARRAY)));
    @LibraryOperator(libraries={SqlLibrary.SPARK})
    public static final SqlFunction ARRAY_JOIN = SqlBasicFunction.create(SqlKind.ARRAY_JOIN, ReturnTypes.VARCHAR_NULLABLE, OperandTypes.STRING_ARRAY_CHARACTER_OPTIONAL_CHARACTER);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction ARRAY_LENGTH = SqlBasicFunction.create(SqlKind.ARRAY_LENGTH, ReturnTypes.INTEGER_NULLABLE, (SqlOperandTypeChecker)OperandTypes.ARRAY);
    @LibraryOperator(libraries={SqlLibrary.SPARK})
    public static final SqlFunction ARRAY_MAX = SqlBasicFunction.create(SqlKind.ARRAY_MAX, ReturnTypes.TO_COLLECTION_ELEMENT_FORCE_NULLABLE, OperandTypes.ARRAY_NONNULL);
    @LibraryOperator(libraries={SqlLibrary.SPARK})
    public static final SqlFunction ARRAY_MIN = SqlBasicFunction.create(SqlKind.ARRAY_MIN, ReturnTypes.TO_COLLECTION_ELEMENT_FORCE_NULLABLE, OperandTypes.ARRAY_NONNULL);
    @LibraryOperator(libraries={SqlLibrary.SPARK})
    public static final SqlFunction ARRAY_POSITION = SqlBasicFunction.create(SqlKind.ARRAY_POSITION, ReturnTypes.BIGINT_NULLABLE, OperandTypes.ARRAY_ELEMENT_NONNULL);
    @LibraryOperator(libraries={SqlLibrary.SPARK})
    public static final SqlFunction ARRAY_PREPEND = SqlBasicFunction.create(SqlKind.ARRAY_PREPEND, SqlLibraryOperators::arrayAppendPrependReturnType, OperandTypes.ARRAY_ELEMENT_NONNULL);
    @LibraryOperator(libraries={SqlLibrary.SPARK})
    public static final SqlFunction ARRAY_REMOVE = SqlBasicFunction.create(SqlKind.ARRAY_REMOVE, ReturnTypes.ARG0_NULLABLE, OperandTypes.ARRAY_ELEMENT_NONNULL);
    @LibraryOperator(libraries={SqlLibrary.SPARK})
    public static final SqlFunction ARRAY_REPEAT = SqlBasicFunction.create(SqlKind.ARRAY_REPEAT, ReturnTypes.TO_ARRAY.andThen(SqlTypeTransforms.TO_NULLABLE), OperandTypes.sequence("ARRAY_REPEAT(ANY, INTEGER)", OperandTypes.ANY, OperandTypes.typeName(SqlTypeName.INTEGER)));
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction ARRAY_REVERSE = SqlBasicFunction.create(SqlKind.ARRAY_REVERSE, ReturnTypes.ARG0_NULLABLE, (SqlOperandTypeChecker)OperandTypes.ARRAY);
    @LibraryOperator(libraries={SqlLibrary.SPARK})
    public static final SqlFunction ARRAY_SIZE = SqlBasicFunction.create(SqlKind.ARRAY_SIZE, ReturnTypes.INTEGER_NULLABLE, (SqlOperandTypeChecker)OperandTypes.ARRAY);
    @LibraryOperator(libraries={SqlLibrary.SPARK})
    public static final SqlFunction ARRAY_UNION = SqlBasicFunction.create(SqlKind.ARRAY_UNION, ReturnTypes.LEAST_RESTRICTIVE, (SqlOperandTypeChecker)OperandTypes.and(OperandTypes.SAME_SAME, OperandTypes.family(SqlTypeFamily.ARRAY, SqlTypeFamily.ARRAY)));
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction ARRAY_TO_STRING = SqlBasicFunction.create(SqlKind.ARRAY_TO_STRING, ReturnTypes.VARCHAR_NULLABLE, OperandTypes.STRING_ARRAY_CHARACTER_OPTIONAL_CHARACTER);
    @LibraryOperator(libraries={SqlLibrary.SPARK})
    public static final SqlFunction ARRAYS_OVERLAP = SqlBasicFunction.create(SqlKind.ARRAYS_OVERLAP, ReturnTypes.BOOLEAN_NULLABLE.andThen(SqlTypeTransforms.COLLECTION_ELEMENT_TYPE_NULLABLE), (SqlOperandTypeChecker)OperandTypes.and(OperandTypes.SAME_SAME, OperandTypes.family(SqlTypeFamily.ARRAY, SqlTypeFamily.ARRAY), OperandTypes.NONNULL_NONNULL));
    @LibraryOperator(libraries={SqlLibrary.SPARK})
    public static final SqlFunction ARRAYS_ZIP = SqlBasicFunction.create(SqlKind.ARRAYS_ZIP, ((SqlReturnTypeInference)SqlLibraryOperators::deriveTypeArraysZip).andThen(SqlTypeTransforms.TO_NULLABLE), OperandTypes.SAME_VARIADIC);
    @LibraryOperator(libraries={SqlLibrary.SPARK})
    public static final SqlFunction SORT_ARRAY = SqlBasicFunction.create(SqlKind.SORT_ARRAY, ReturnTypes.ARG0_NULLABLE, (SqlOperandTypeChecker)OperandTypes.ARRAY.or(OperandTypes.ARRAY_BOOLEAN_LITERAL));
    @LibraryOperator(libraries={SqlLibrary.SPARK})
    public static final SqlFunction MAP_CONCAT = SqlBasicFunction.create(SqlKind.MAP_CONCAT, SqlLibraryOperators::deriveTypeMapConcat, OperandTypes.SAME_VARIADIC);
    @LibraryOperator(libraries={SqlLibrary.SPARK})
    public static final SqlFunction MAP_ENTRIES = SqlBasicFunction.create(SqlKind.MAP_ENTRIES, ReturnTypes.TO_MAP_ENTRIES_NULLABLE, (SqlOperandTypeChecker)OperandTypes.MAP);
    @LibraryOperator(libraries={SqlLibrary.SPARK})
    public static final SqlFunction MAP_KEYS = SqlBasicFunction.create(SqlKind.MAP_KEYS, ReturnTypes.TO_MAP_KEYS_NULLABLE, (SqlOperandTypeChecker)OperandTypes.MAP);
    @LibraryOperator(libraries={SqlLibrary.SPARK})
    public static final SqlFunction MAP_VALUES = SqlBasicFunction.create(SqlKind.MAP_VALUES, ReturnTypes.TO_MAP_VALUES_NULLABLE, (SqlOperandTypeChecker)OperandTypes.MAP);
    @LibraryOperator(libraries={SqlLibrary.SPARK})
    public static final SqlFunction MAP_CONTAINS_KEY = SqlBasicFunction.create(SqlKind.MAP_CONTAINS_KEY, ReturnTypes.BOOLEAN_NULLABLE, OperandTypes.MAP_KEY);
    @LibraryOperator(libraries={SqlLibrary.SPARK})
    public static final SqlFunction MAP_FROM_ARRAYS = SqlBasicFunction.create(SqlKind.MAP_FROM_ARRAYS, SqlLibraryOperators::deriveTypeMapFromArrays, (SqlOperandTypeChecker)OperandTypes.ARRAY_ARRAY);
    @LibraryOperator(libraries={SqlLibrary.SPARK})
    public static final SqlFunction MAP_FROM_ENTRIES = SqlBasicFunction.create(SqlKind.MAP_FROM_ENTRIES, SqlLibraryOperators::deriveTypeMapFromEntries, (SqlOperandTypeChecker)OperandTypes.MAP_FROM_ENTRIES);
    @LibraryOperator(libraries={SqlLibrary.SPARK})
    public static final SqlFunction STR_TO_MAP = SqlBasicFunction.create(SqlKind.STR_TO_MAP, ReturnTypes.IDENTITY_TO_MAP_NULLABLE, (SqlOperandTypeChecker)OperandTypes.STRING_OPTIONAL_STRING_OPTIONAL_STRING);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY, SqlLibrary.MYSQL})
    public static final SqlFunction REVERSE = SqlBasicFunction.create(SqlKind.REVERSE, ReturnTypes.ARG0_NULLABLE_VARYING, (SqlOperandTypeChecker)OperandTypes.CHARACTER).withFunctionType(SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.HIVE, SqlLibrary.SPARK})
    public static final SqlFunction LEVENSHTEIN = SqlBasicFunction.create("LEVENSHTEIN", ReturnTypes.INTEGER_NULLABLE, OperandTypes.STRING_STRING, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY, SqlLibrary.MYSQL})
    public static final SqlFunction FROM_BASE64 = SqlBasicFunction.create("FROM_BASE64", ReturnTypes.VARBINARY_NULLABLE, OperandTypes.STRING, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlFunction TO_BASE64 = SqlBasicFunction.create("TO_BASE64", ReturnTypes.VARCHAR_NULLABLE, OperandTypes.STRING.or(OperandTypes.BINARY), SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction FROM_BASE32 = SqlBasicFunction.create("FROM_BASE32", ReturnTypes.VARBINARY_NULLABLE, OperandTypes.CHARACTER, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction TO_BASE32 = SqlBasicFunction.create("TO_BASE32", ReturnTypes.VARCHAR_NULLABLE, OperandTypes.STRING, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction FROM_HEX = SqlBasicFunction.create("FROM_HEX", ReturnTypes.VARBINARY_NULLABLE, OperandTypes.CHARACTER, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction TO_HEX = SqlBasicFunction.create("TO_HEX", ReturnTypes.VARCHAR_NULLABLE, OperandTypes.BINARY, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.HIVE, SqlLibrary.SPARK})
    public static final SqlFunction FORMAT_NUMBER = SqlBasicFunction.create("FORMAT_NUMBER", ReturnTypes.VARCHAR_NULLABLE, OperandTypes.or(OperandTypes.NUMERIC_NUMERIC, OperandTypes.NUMERIC_CHARACTER), SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.MYSQL, SqlLibrary.ORACLE, SqlLibrary.POSTGRESQL})
    public static final SqlFunction TO_CHAR = SqlBasicFunction.create("TO_CHAR", ReturnTypes.VARCHAR, OperandTypes.TIMESTAMP_STRING, SqlFunctionCategory.TIMEDATE);
    @LibraryOperator(libraries={SqlLibrary.POSTGRESQL, SqlLibrary.ORACLE})
    public static final SqlFunction TO_DATE = SqlBasicFunction.create("TO_DATE", ReturnTypes.DATE_NULLABLE, OperandTypes.STRING_STRING, SqlFunctionCategory.TIMEDATE);
    @LibraryOperator(libraries={SqlLibrary.POSTGRESQL, SqlLibrary.ORACLE})
    public static final SqlFunction TO_TIMESTAMP = SqlBasicFunction.create("TO_TIMESTAMP", ReturnTypes.TIMESTAMP_NULLABLE, OperandTypes.STRING_STRING, SqlFunctionCategory.TIMEDATE);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction PARSE_TIME = SqlBasicFunction.create("PARSE_TIME", ReturnTypes.TIME_NULLABLE, OperandTypes.STRING_STRING, SqlFunctionCategory.TIMEDATE);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction PARSE_DATE = SqlBasicFunction.create("PARSE_DATE", ReturnTypes.DATE_NULLABLE, OperandTypes.STRING_STRING, SqlFunctionCategory.TIMEDATE);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction PARSE_TIMESTAMP = SqlBasicFunction.create("PARSE_TIMESTAMP", ReturnTypes.TIMESTAMP_LTZ_NULLABLE, OperandTypes.STRING_STRING_OPTIONAL_STRING, SqlFunctionCategory.TIMEDATE);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction PARSE_DATETIME = SqlBasicFunction.create("PARSE_DATETIME", ReturnTypes.TIMESTAMP_NULLABLE, OperandTypes.STRING_STRING, SqlFunctionCategory.TIMEDATE);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction FORMAT_TIME = SqlBasicFunction.create("FORMAT_TIME", ReturnTypes.VARCHAR_NULLABLE, OperandTypes.CHARACTER_TIME, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction FORMAT_DATE = SqlBasicFunction.create("FORMAT_DATE", ReturnTypes.VARCHAR_NULLABLE, OperandTypes.CHARACTER_DATE, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction FORMAT_TIMESTAMP = SqlBasicFunction.create("FORMAT_TIMESTAMP", ReturnTypes.VARCHAR_2000_NULLABLE, OperandTypes.sequence("FORMAT_TIMESTAMP(<CHARACTER>, <TIMESTAMP WITH LOCAL TIME ZONE>)", OperandTypes.CHARACTER, OperandTypes.TIMESTAMP_LTZ).or(OperandTypes.sequence("FORMAT_TIMESTAMP(<CHARACTER>, <TIMESTAMP WITH LOCAL TIME ZONE>, <CHARACTER>)", OperandTypes.CHARACTER, OperandTypes.TIMESTAMP_LTZ, OperandTypes.CHARACTER)), SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction FORMAT_DATETIME = SqlBasicFunction.create("FORMAT_DATETIME", ReturnTypes.VARCHAR_2000_NULLABLE, OperandTypes.sequence("FORMAT_DATETIME(<CHARACTER>, <TIMESTAMP>)", OperandTypes.CHARACTER, OperandTypes.TIMESTAMP_NTZ).or(OperandTypes.sequence("FORMAT_DATETIME(<CHARACTER>, <TIMESTAMP>, <CHARACTER>)", OperandTypes.CHARACTER, OperandTypes.TIMESTAMP_NTZ, OperandTypes.CHARACTER)), SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlBasicFunction TIMESTAMP_ADD2 = SqlBasicFunction.create(SqlKind.TIMESTAMP_ADD, ReturnTypes.ARG0_NULLABLE, (SqlOperandTypeChecker)OperandTypes.TIMESTAMP_INTERVAL).withFunctionType(SqlFunctionCategory.TIMEDATE);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction TIMESTAMP_DIFF3 = new SqlTimestampDiffFunction("TIMESTAMP_DIFF", OperandTypes.family(SqlTypeFamily.TIMESTAMP, SqlTypeFamily.TIMESTAMP, SqlTypeFamily.ANY));
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction TIME_ADD = SqlBasicFunction.create(SqlKind.TIME_ADD, ReturnTypes.ARG0_NULLABLE, (SqlOperandTypeChecker)OperandTypes.TIME_INTERVAL).withFunctionType(SqlFunctionCategory.TIMEDATE);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction TIME_DIFF = new SqlTimestampDiffFunction("TIME_DIFF", OperandTypes.family(SqlTypeFamily.TIME, SqlTypeFamily.TIME, SqlTypeFamily.ANY));
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction DATE_TRUNC = SqlBasicFunction.create("DATE_TRUNC", ReturnTypes.ARG0_NULLABLE, OperandTypes.sequence("'DATE_TRUNC(<DATE>, <DATETIME_INTERVAL>)'", OperandTypes.DATE_OR_TIMESTAMP, OperandTypes.dateInterval()), SqlFunctionCategory.TIMEDATE).withOperandHandler(OperandHandlers.OPERAND_1_MIGHT_BE_TIME_FRAME).withKind(SqlKind.DATE_TRUNC);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction TIME_SUB = SqlBasicFunction.create(SqlKind.TIME_SUB, ReturnTypes.ARG0_NULLABLE, (SqlOperandTypeChecker)OperandTypes.TIME_INTERVAL).withFunctionType(SqlFunctionCategory.TIMEDATE);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction TIME_TRUNC = SqlBasicFunction.create("TIME_TRUNC", ReturnTypes.TIME_NULLABLE, OperandTypes.sequence("'TIME_TRUNC(<TIME>, <DATETIME_INTERVAL>)'", OperandTypes.TIME, OperandTypes.timeInterval()), SqlFunctionCategory.TIMEDATE);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlBasicFunction TIMESTAMP_SUB = SqlBasicFunction.create(SqlKind.TIMESTAMP_SUB, ReturnTypes.ARG0_NULLABLE, (SqlOperandTypeChecker)OperandTypes.TIMESTAMP_INTERVAL).withFunctionType(SqlFunctionCategory.TIMEDATE);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction DATETIME_SUB = TIMESTAMP_SUB.withName("DATETIME_SUB");
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction TIMESTAMP_TRUNC = SqlBasicFunction.create("TIMESTAMP_TRUNC", ReturnTypes.ARG0_EXCEPT_DATE_NULLABLE, OperandTypes.sequence("'TIMESTAMP_TRUNC(<TIMESTAMP>, <DATETIME_INTERVAL>)'", OperandTypes.DATE_OR_TIMESTAMP, OperandTypes.timestampInterval()), SqlFunctionCategory.TIMEDATE);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction DATETIME_TRUNC = SqlBasicFunction.create("DATETIME_TRUNC", ReturnTypes.ARG0_EXCEPT_DATE_NULLABLE, OperandTypes.sequence("'DATETIME_TRUNC(<TIMESTAMP>, <DATETIME_INTERVAL>)'", OperandTypes.DATE_OR_TIMESTAMP, OperandTypes.timestampInterval()), SqlFunctionCategory.TIMEDATE);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY, SqlLibrary.SPARK})
    public static final SqlFunction TIMESTAMP_SECONDS = SqlBasicFunction.create("TIMESTAMP_SECONDS", ReturnTypes.TIMESTAMP_NULLABLE, OperandTypes.INTEGER, SqlFunctionCategory.TIMEDATE);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY, SqlLibrary.SPARK})
    public static final SqlFunction TIMESTAMP_MILLIS = SqlBasicFunction.create("TIMESTAMP_MILLIS", ReturnTypes.TIMESTAMP_NULLABLE, OperandTypes.INTEGER, SqlFunctionCategory.TIMEDATE);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY, SqlLibrary.SPARK})
    public static final SqlFunction TIMESTAMP_MICROS = SqlBasicFunction.create("TIMESTAMP_MICROS", ReturnTypes.TIMESTAMP_NULLABLE, OperandTypes.INTEGER, SqlFunctionCategory.TIMEDATE);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY, SqlLibrary.SPARK})
    public static final SqlFunction UNIX_SECONDS = SqlBasicFunction.create("UNIX_SECONDS", ReturnTypes.BIGINT_NULLABLE, OperandTypes.TIMESTAMP, SqlFunctionCategory.TIMEDATE);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY, SqlLibrary.SPARK})
    public static final SqlFunction UNIX_MILLIS = SqlBasicFunction.create("UNIX_MILLIS", ReturnTypes.BIGINT_NULLABLE, OperandTypes.TIMESTAMP, SqlFunctionCategory.TIMEDATE);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY, SqlLibrary.SPARK})
    public static final SqlFunction UNIX_MICROS = SqlBasicFunction.create("UNIX_MICROS", ReturnTypes.BIGINT_NULLABLE, OperandTypes.TIMESTAMP, SqlFunctionCategory.TIMEDATE);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction DATETIME_ADD = TIMESTAMP_ADD2.withName("DATETIME_ADD");
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction DATETIME_DIFF = new SqlTimestampDiffFunction("DATETIME_DIFF", OperandTypes.family(SqlTypeFamily.TIMESTAMP, SqlTypeFamily.TIMESTAMP, SqlTypeFamily.ANY));
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction SAFE_ADD = SqlBasicFunction.create("SAFE_ADD", ReturnTypes.SUM_FORCE_NULLABLE, OperandTypes.NUMERIC_NUMERIC, SqlFunctionCategory.NUMERIC);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction SAFE_DIVIDE = SqlBasicFunction.create("SAFE_DIVIDE", ReturnTypes.DOUBLE_IF_INTEGERS.orElse(ReturnTypes.QUOTIENT_FORCE_NULLABLE), OperandTypes.NUMERIC_NUMERIC, SqlFunctionCategory.NUMERIC);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction SAFE_MULTIPLY = SqlBasicFunction.create("SAFE_MULTIPLY", ReturnTypes.PRODUCT_FORCE_NULLABLE, OperandTypes.NUMERIC_NUMERIC, SqlFunctionCategory.NUMERIC);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction SAFE_NEGATE = SqlBasicFunction.create("SAFE_NEGATE", ReturnTypes.ARG0_FORCE_NULLABLE, OperandTypes.NUMERIC, SqlFunctionCategory.NUMERIC);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction SAFE_SUBTRACT = SqlBasicFunction.create("SAFE_SUBTRACT", ReturnTypes.SUM_FORCE_NULLABLE, OperandTypes.NUMERIC_NUMERIC, SqlFunctionCategory.NUMERIC);
    @LibraryOperator(libraries={SqlLibrary.MYSQL, SqlLibrary.SPARK})
    public static final SqlFunction CHAR = SqlBasicFunction.create("CHAR", ReturnTypes.CHAR_FORCE_NULLABLE, OperandTypes.INTEGER, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY, SqlLibrary.ORACLE, SqlLibrary.POSTGRESQL})
    public static final SqlFunction CHR = SqlBasicFunction.create("CHR", ReturnTypes.CHAR, OperandTypes.INTEGER, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction CODE_POINTS_TO_BYTES = SqlBasicFunction.create("CODE_POINTS_TO_BYTES", ReturnTypes.VARBINARY_NULLABLE, OperandTypes.ARRAY_OF_INTEGER, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction CODE_POINTS_TO_STRING = SqlBasicFunction.create("CODE_POINTS_TO_STRING", ReturnTypes.VARCHAR_NULLABLE, OperandTypes.ARRAY_OF_INTEGER, SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction TO_CODE_POINTS = SqlBasicFunction.create("TO_CODE_POINTS", ReturnTypes.INTEGER.andThen(SqlTypeTransforms.TO_ARRAY_NULLABLE), OperandTypes.STRING.or(OperandTypes.BINARY), SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.ALL})
    public static final SqlFunction TANH = SqlBasicFunction.create("TANH", ReturnTypes.DOUBLE_NULLABLE, OperandTypes.NUMERIC, SqlFunctionCategory.NUMERIC);
    @LibraryOperator(libraries={SqlLibrary.ALL})
    public static final SqlFunction COTH = SqlBasicFunction.create("COTH", ReturnTypes.DOUBLE_NULLABLE, OperandTypes.NUMERIC, SqlFunctionCategory.NUMERIC);
    @LibraryOperator(libraries={SqlLibrary.ALL})
    public static final SqlFunction COSH = SqlBasicFunction.create("COSH", ReturnTypes.DOUBLE_NULLABLE, OperandTypes.NUMERIC, SqlFunctionCategory.NUMERIC);
    @LibraryOperator(libraries={SqlLibrary.ALL})
    public static final SqlFunction ACOSH = SqlBasicFunction.create("ACOSH", ReturnTypes.DOUBLE_NULLABLE, OperandTypes.NUMERIC, SqlFunctionCategory.NUMERIC);
    @LibraryOperator(libraries={SqlLibrary.ALL})
    public static final SqlFunction ASINH = SqlBasicFunction.create("ASINH", ReturnTypes.DOUBLE_NULLABLE, OperandTypes.NUMERIC, SqlFunctionCategory.NUMERIC);
    @LibraryOperator(libraries={SqlLibrary.ALL})
    public static final SqlFunction ATANH = SqlBasicFunction.create("ATANH", ReturnTypes.DOUBLE_NULLABLE, OperandTypes.NUMERIC, SqlFunctionCategory.NUMERIC);
    @LibraryOperator(libraries={SqlLibrary.ALL})
    public static final SqlFunction SECH = SqlBasicFunction.create("SECH", ReturnTypes.DOUBLE_NULLABLE, OperandTypes.NUMERIC, SqlFunctionCategory.NUMERIC);
    @LibraryOperator(libraries={SqlLibrary.ALL})
    public static final SqlFunction CSCH = SqlBasicFunction.create("CSCH", ReturnTypes.DOUBLE_NULLABLE, OperandTypes.NUMERIC, SqlFunctionCategory.NUMERIC);
    @LibraryOperator(libraries={SqlLibrary.ALL})
    public static final SqlFunction SINH = SqlBasicFunction.create("SINH", ReturnTypes.DOUBLE_NULLABLE, OperandTypes.NUMERIC, SqlFunctionCategory.NUMERIC);
    @LibraryOperator(libraries={SqlLibrary.ALL})
    public static final SqlFunction CSC = SqlBasicFunction.create("CSC", ReturnTypes.DOUBLE_NULLABLE, OperandTypes.NUMERIC, SqlFunctionCategory.NUMERIC);
    @LibraryOperator(libraries={SqlLibrary.ALL})
    public static final SqlFunction SEC = SqlBasicFunction.create("SEC", ReturnTypes.DOUBLE_NULLABLE, OperandTypes.NUMERIC, SqlFunctionCategory.NUMERIC);
    @LibraryOperator(libraries={SqlLibrary.HIVE, SqlLibrary.SPARK})
    public static final SqlFunction FACTORIAL = SqlBasicFunction.create("FACTORIAL", ReturnTypes.BIGINT_FORCE_NULLABLE, OperandTypes.INTEGER, SqlFunctionCategory.NUMERIC);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY, SqlLibrary.MYSQL, SqlLibrary.POSTGRESQL, SqlLibrary.SPARK})
    public static final SqlFunction MD5 = SqlBasicFunction.create("MD5", ReturnTypes.VARCHAR_NULLABLE, OperandTypes.STRING.or(OperandTypes.BINARY), SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY, SqlLibrary.MYSQL, SqlLibrary.POSTGRESQL, SqlLibrary.SPARK})
    public static final SqlFunction SHA1 = SqlBasicFunction.create("SHA1", ReturnTypes.VARCHAR_NULLABLE, OperandTypes.STRING.or(OperandTypes.BINARY), SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY, SqlLibrary.POSTGRESQL})
    public static final SqlFunction SHA256 = SqlBasicFunction.create("SHA256", ReturnTypes.VARCHAR_NULLABLE, OperandTypes.STRING.or(OperandTypes.BINARY), SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY, SqlLibrary.POSTGRESQL})
    public static final SqlFunction SHA512 = SqlBasicFunction.create("SHA512", ReturnTypes.VARCHAR_NULLABLE, OperandTypes.STRING.or(OperandTypes.BINARY), SqlFunctionCategory.STRING);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction IS_INF = SqlBasicFunction.create("IS_INF", ReturnTypes.BOOLEAN_NULLABLE, OperandTypes.NUMERIC, SqlFunctionCategory.NUMERIC);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction IS_NAN = SqlBasicFunction.create("IS_NAN", ReturnTypes.BOOLEAN_NULLABLE, OperandTypes.NUMERIC, SqlFunctionCategory.NUMERIC);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction LOG = SqlBasicFunction.create("LOG", ReturnTypes.DOUBLE_NULLABLE, OperandTypes.NUMERIC_OPTIONAL_NUMERIC, SqlFunctionCategory.NUMERIC);
    @LibraryOperator(libraries={SqlLibrary.MYSQL, SqlLibrary.SPARK})
    public static final SqlFunction LOG2 = SqlBasicFunction.create("LOG2", ReturnTypes.DOUBLE_FORCE_NULLABLE, OperandTypes.NUMERIC, SqlFunctionCategory.NUMERIC);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY, SqlLibrary.SPARK})
    public static final SqlFunction POW = SqlStdOperatorTable.POWER.withName("POW");
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction TRUNC_BIG_QUERY = SqlStdOperatorTable.TRUNCATE.withName("TRUNC").withReturnTypeInference(ReturnTypes.ARG0_EXCEPT_INTEGER_NULLABLE);
    @LibraryOperator(libraries={SqlLibrary.POSTGRESQL})
    public static final SqlOperator INFIX_CAST = new SqlCastOperator();
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlFunction SAFE_CAST = new SqlCastFunction("SAFE_CAST", SqlKind.SAFE_CAST);
    @LibraryOperator(libraries={SqlLibrary.MSSQL})
    public static final SqlFunction TRY_CAST = new SqlCastFunction("TRY_CAST", SqlKind.SAFE_CAST);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlOperator OFFSET = new SqlItemOperator("OFFSET", OperandTypes.ARRAY, 0, false);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlOperator ORDINAL = new SqlItemOperator("ORDINAL", OperandTypes.ARRAY, 1, false);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlOperator SAFE_OFFSET = new SqlItemOperator("SAFE_OFFSET", OperandTypes.ARRAY, 0, true);
    @LibraryOperator(libraries={SqlLibrary.BIG_QUERY})
    public static final SqlOperator SAFE_ORDINAL = new SqlItemOperator("SAFE_ORDINAL", OperandTypes.ARRAY, 1, true);
    @LibraryOperator(libraries={SqlLibrary.MYSQL})
    public static final SqlOperator NULL_SAFE_EQUAL = new SqlBinaryOperator("<=>", SqlKind.IS_NOT_DISTINCT_FROM, 30, true, ReturnTypes.BOOLEAN, InferTypes.FIRST_KNOWN, OperandTypes.COMPARABLE_UNORDERED_COMPARABLE_UNORDERED);
    @LibraryOperator(libraries={SqlLibrary.SNOWFLAKE})
    public static final SqlAggFunction BITAND_AGG = new SqlBitOpAggFunction("BITAND_AGG", SqlKind.BIT_AND);
    @LibraryOperator(libraries={SqlLibrary.SNOWFLAKE})
    public static final SqlAggFunction BITOR_AGG = new SqlBitOpAggFunction("BITOR_AGG", SqlKind.BIT_OR);
    @LibraryOperator(libraries={SqlLibrary.SPARK})
    public static final SqlFunction BIT_LENGTH = SqlBasicFunction.create("BIT_LENGTH", ReturnTypes.INTEGER_NULLABLE, OperandTypes.or(OperandTypes.CHARACTER, OperandTypes.BINARY), SqlFunctionCategory.NUMERIC);
    @LibraryOperator(libraries={SqlLibrary.SPARK})
    public static final SqlBasicFunction BIT_GET = SqlBasicFunction.create("BIT_GET", ReturnTypes.TINYINT_NULLABLE, OperandTypes.NUMERIC_INTEGER, SqlFunctionCategory.NUMERIC);
    @LibraryOperator(libraries={SqlLibrary.SPARK})
    public static final SqlFunction GETBIT = BIT_GET.withName("GETBIT");
    @LibraryOperator(libraries={SqlLibrary.POSTGRESQL})
    public static final SqlFunction RANDOM = SqlStdOperatorTable.RAND.withName("RANDOM").withOperandTypeChecker(OperandTypes.NILADIC);

    private SqlLibraryOperators() {
    }

    private static SqlCallBinding transformConvert(SqlOperatorBinding opBinding) {
        SqlCallBinding binding = (SqlCallBinding)opBinding;
        return new SqlCallBinding(binding.getValidator(), binding.getScope(), SqlLibraryOperators.transformConvert(binding.getValidator(), binding.getCall()));
    }

    private static SqlCall transformConvert(SqlValidator validator, SqlCall call) {
        return SqlStdOperatorTable.CAST.createCall(call.getParserPosition(), new SqlNode[]{call.operand(1), call.operand(0)});
    }

    private static @Nullable RelDataType inferIfReturnType(SqlOperatorBinding opBinding) {
        return opBinding.getTypeFactory().leastRestrictive(opBinding.collectOperandTypes().subList(1, 3));
    }

    private static RelDataType deriveTypePad(SqlOperatorBinding binding, RelDataType type) {
        SqlTypeName result = SqlTypeUtil.isBinary(type) ? SqlTypeName.VARBINARY : SqlTypeName.VARCHAR;
        return binding.getTypeFactory().createSqlType(result);
    }

    static RelDataType deriveTypeSplit(SqlOperatorBinding operatorBinding, RelDataType type) {
        if (SqlTypeUtil.isBinary(type) && operatorBinding.getOperandCount() == 1) {
            throw operatorBinding.newError(Static.RESOURCE.delimiterIsRequired(operatorBinding.getOperator().getName(), type.toString()));
        }
        SqlTypeName typeName = SqlTypeUtil.isBinary(type) ? SqlTypeName.VARBINARY : SqlTypeName.VARCHAR;
        return operatorBinding.getTypeFactory().createSqlType(typeName);
    }

    private static RelDataType arrayReturnType(SqlOperatorBinding opBinding) {
        RelDataType type;
        boolean useCharacterTypes;
        List<RelDataType> operandTypes = opBinding.collectOperandTypes();
        boolean hasNumeric = false;
        boolean hasCharacter = false;
        boolean hasOthers = false;
        block4: for (RelDataType type2 : operandTypes) {
            SqlTypeFamily family = type2.getSqlTypeName().getFamily();
            if (family == null) {
                hasOthers = true;
                break;
            }
            if (SqlTypeUtil.isNull(type2)) continue;
            switch (family) {
                case NUMERIC: {
                    hasNumeric = true;
                    continue block4;
                }
                case CHARACTER: {
                    hasCharacter = true;
                    continue block4;
                }
            }
            hasOthers = true;
        }
        boolean bl = useCharacterTypes = hasNumeric && hasCharacter && !hasOthers;
        if (useCharacterTypes) {
            List<RelDataType> characterTypes = operandTypes.stream().filter(t -> t.getSqlTypeName().getFamily() != SqlTypeFamily.NUMERIC).collect(Collectors.toList());
            type = opBinding.getTypeFactory().leastRestrictive(characterTypes);
        } else {
            type = opBinding.getOperandCount() > 0 ? ReturnTypes.LEAST_RESTRICTIVE.inferReturnType(opBinding) : opBinding.getTypeFactory().createUnknownType();
        }
        Objects.requireNonNull(type, "inferred array element type");
        SqlValidatorUtil.adjustTypeForArrayConstructor(type, opBinding);
        return SqlTypeUtil.createArrayType(opBinding.getTypeFactory(), type, false);
    }

    private static RelDataType mapReturnType(SqlOperatorBinding opBinding) {
        Pair<@Nullable RelDataType, @Nullable RelDataType> type = SqlLibraryOperators.getComponentTypes(opBinding.getTypeFactory(), opBinding.collectOperandTypes());
        return SqlTypeUtil.createMapType(opBinding.getTypeFactory(), (RelDataType)Objects.requireNonNull(type.left, "inferred key type"), (RelDataType)Objects.requireNonNull(type.right, "inferred value type"), false);
    }

    private static Pair<@Nullable RelDataType, @Nullable RelDataType> getComponentTypes(RelDataTypeFactory typeFactory, List<RelDataType> argTypes) {
        if (argTypes.isEmpty()) {
            return Pair.of(typeFactory.createUnknownType(), typeFactory.createUnknownType());
        }
        return Pair.of(typeFactory.leastRestrictive(Util.quotientList(argTypes, 2, 0)), typeFactory.leastRestrictive(Util.quotientList(argTypes, 2, 1)));
    }

    private static RelDataType arrayAppendPrependReturnType(SqlOperatorBinding opBinding) {
        RelDataType arrayType = opBinding.collectOperandTypes().get(0);
        RelDataType componentType = arrayType.getComponentType();
        if (componentType == null) {
            return arrayType;
        }
        RelDataType elementType = opBinding.collectOperandTypes().get(1);
        Objects.requireNonNull(componentType, () -> "componentType of " + arrayType);
        RelDataType type = opBinding.getTypeFactory().leastRestrictive((List<RelDataType>)ImmutableList.of((Object)componentType, (Object)elementType));
        Objects.requireNonNull(type, "inferred array element type");
        if (elementType.isNullable()) {
            type = opBinding.getTypeFactory().createTypeWithNullability(type, true);
        }
        if (!componentType.equalsSansFieldNames(elementType)) {
            if (componentType.equalsSansFieldNames(type)) {
                SqlValidatorUtil.adjustTypeForArrayFunctions(type, opBinding, 1);
            } else {
                SqlValidatorUtil.adjustTypeForArrayFunctions(type, opBinding, 0);
            }
        }
        return SqlTypeUtil.createArrayType(opBinding.getTypeFactory(), type, arrayType.isNullable());
    }

    private static RelDataType arrayCompactReturnType(SqlOperatorBinding opBinding) {
        RelDataType arrayType = opBinding.collectOperandTypes().get(0);
        if (arrayType.getSqlTypeName() == SqlTypeName.NULL) {
            return arrayType;
        }
        RelDataType type = arrayType.getComponentType();
        if (type != null && type.isNullable()) {
            type = opBinding.getTypeFactory().createTypeWithNullability(type, false);
        }
        Objects.requireNonNull(type, "inferred array element type");
        return SqlTypeUtil.createArrayType(opBinding.getTypeFactory(), type, arrayType.isNullable());
    }

    private static RelDataType arrayInsertReturnType(SqlOperatorBinding opBinding) {
        RelDataType arrayType = opBinding.collectOperandTypes().get(0);
        RelDataType componentType = arrayType.getComponentType();
        RelDataType elementType = opBinding.collectOperandTypes().get(2);
        Objects.requireNonNull(componentType, () -> "componentType of " + arrayType);
        RelDataType type = opBinding.getTypeFactory().leastRestrictive((List<RelDataType>)ImmutableList.of((Object)componentType, (Object)elementType));
        Objects.requireNonNull(type, "inferred array element type");
        if (elementType.isNullable()) {
            type = opBinding.getTypeFactory().createTypeWithNullability(type, true);
        }
        if (!componentType.equalsSansFieldNames(elementType)) {
            if (componentType.equalsSansFieldNames(type)) {
                SqlValidatorUtil.adjustTypeForArrayFunctions(type, opBinding, 2);
            } else {
                SqlValidatorUtil.adjustTypeForArrayFunctions(type, opBinding, 0);
            }
        }
        return SqlTypeUtil.createArrayType(opBinding.getTypeFactory(), type, arrayType.isNullable());
    }

    private static RelDataType deriveTypeArraysZip(SqlOperatorBinding opBinding) {
        ArrayList<RelDataType> argComponentTypes = new ArrayList<RelDataType>();
        for (RelDataType arrayType : opBinding.collectOperandTypes()) {
            RelDataType componentType = Objects.requireNonNull(arrayType.getComponentType());
            argComponentTypes.add(componentType);
        }
        List<String> indexes = IntStream.range(0, argComponentTypes.size()).mapToObj(i -> String.valueOf(i)).collect(Collectors.toList());
        RelDataType structType = opBinding.getTypeFactory().createStructType(argComponentTypes, indexes);
        return SqlTypeUtil.createArrayType(opBinding.getTypeFactory(), Objects.requireNonNull(structType, "inferred value type"), false);
    }

    private static RelDataType deriveTypeMapConcat(SqlOperatorBinding opBinding) {
        if (opBinding.getOperandCount() == 0) {
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            RelDataType type = typeFactory.createSqlType(SqlTypeName.VARCHAR);
            Objects.requireNonNull(type, "type");
            return SqlTypeUtil.createMapType(typeFactory, type, type, true);
        }
        List<RelDataType> operandTypes = opBinding.collectOperandTypes();
        for (RelDataType operandType : operandTypes) {
            if (SqlTypeUtil.isMap(operandType)) continue;
            throw opBinding.newError(Static.RESOURCE.typesShouldAllBeMap(opBinding.getOperator().getName(), operandType.getFullTypeString()));
        }
        return Objects.requireNonNull(opBinding.getTypeFactory().leastRestrictive(operandTypes));
    }

    private static RelDataType deriveTypeMapFromArrays(SqlOperatorBinding opBinding) {
        RelDataType keysArrayType = opBinding.getOperandType(0);
        RelDataType valuesArrayType = opBinding.getOperandType(1);
        boolean nullable = keysArrayType.isNullable() || valuesArrayType.isNullable();
        return SqlTypeUtil.createMapType(opBinding.getTypeFactory(), Objects.requireNonNull(keysArrayType.getComponentType(), "inferred key type"), Objects.requireNonNull(valuesArrayType.getComponentType(), "inferred value type"), nullable);
    }

    private static RelDataType deriveTypeMapFromEntries(SqlOperatorBinding opBinding) {
        RelDataType entriesType = opBinding.collectOperandTypes().get(0);
        RelDataType entryType = entriesType.getComponentType();
        Objects.requireNonNull(entryType, () -> "componentType of " + entriesType);
        return SqlTypeUtil.createMapType(opBinding.getTypeFactory(), Objects.requireNonNull(entryType.getFieldList().get(0).getType(), "inferred key type"), Objects.requireNonNull(entryType.getFieldList().get(1).getType(), "inferred value type"), entriesType.isNullable() || entryType.isNullable());
    }
}

