/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.schema.management;

import java.util.LinkedHashMap;
import org.apache.ignite.internal.cache.query.index.Order;
import org.apache.ignite.internal.cache.query.index.SortOrder;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyDefinition;
import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyType;
import org.apache.ignite.internal.processors.query.GridQueryIndexDescriptor;
import org.apache.ignite.internal.processors.query.GridQueryProperty;
import org.apache.ignite.internal.processors.query.GridQueryTypeDescriptor;
import org.apache.ignite.internal.processors.query.schema.management.IndexDescriptorFactory;
import org.apache.ignite.internal.util.typedef.F;

public abstract class AbstractIndexDescriptorFactory
implements IndexDescriptorFactory {
    protected static LinkedHashMap<String, IndexKeyDefinition> indexDescriptorToKeysDefinition(GridQueryIndexDescriptor idxDesc, GridQueryTypeDescriptor typeDesc) {
        LinkedHashMap<String, IndexKeyDefinition> keyDefs = new LinkedHashMap<String, IndexKeyDefinition>(idxDesc.fields().size());
        for (String field : idxDesc.fields()) {
            keyDefs.put(field, AbstractIndexDescriptorFactory.keyDefinition(typeDesc, field, !idxDesc.descending(field)));
        }
        return keyDefs;
    }

    protected static IndexKeyDefinition keyDefinition(GridQueryTypeDescriptor typeDesc, String field, boolean ascOrder) {
        Order order = new Order(ascOrder ? SortOrder.ASC : SortOrder.DESC, null);
        GridQueryProperty prop = typeDesc.property(field);
        if (prop == null && F.eq(field, "_KEY") && !F.isEmpty(typeDesc.keyFieldName())) {
            prop = typeDesc.property(typeDesc.keyFieldName());
        }
        Class<?> fieldType = F.eq(field, "_KEY") ? typeDesc.keyClass() : (F.eq(field, "_VAL") ? typeDesc.valueClass() : prop.type());
        int fieldPrecision = prop != null ? prop.precision() : -1;
        return new IndexKeyDefinition(IndexKeyType.forClass(fieldType).code(), order, fieldPrecision);
    }
}

