/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ignite.internal.processors.closure.GridClosureProcessor;
import org.apache.ignite.internal.processors.timeout.GridTimeoutObject;
import org.apache.ignite.internal.processors.timeout.GridTimeoutProcessor;
import org.apache.ignite.internal.util.lang.GridPlainRunnable;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.util.deque.FastSizeDeque;

public abstract class GridDeferredAckMessageSender<T> {
    private ConcurrentMap<UUID, DeferredAckMessageBuffer> deferredAckMsgBuffers = new ConcurrentHashMap<UUID, DeferredAckMessageBuffer>();
    private GridTimeoutProcessor time;
    public GridClosureProcessor c;

    public GridDeferredAckMessageSender(GridTimeoutProcessor time, GridClosureProcessor c) {
        this.time = time;
        this.c = c;
    }

    public abstract int getTimeout();

    public abstract int getBufferSize();

    public abstract void finish(UUID var1, Collection<T> var2);

    public void stop() {
        for (DeferredAckMessageBuffer buf : this.deferredAckMsgBuffers.values()) {
            buf.finish0();
        }
    }

    public void sendDeferredAckMessage(UUID nodeId, T ver) {
        while (true) {
            DeferredAckMessageBuffer buf;
            if ((buf = (DeferredAckMessageBuffer)this.deferredAckMsgBuffers.get(nodeId)) == null) {
                buf = new DeferredAckMessageBuffer(nodeId);
                DeferredAckMessageBuffer old = this.deferredAckMsgBuffers.putIfAbsent(nodeId, buf);
                if (old == null) {
                    this.time.addTimeoutObject(buf);
                } else {
                    buf = old;
                }
            }
            if (buf.add(ver)) break;
            this.deferredAckMsgBuffers.remove(nodeId, buf);
        }
    }

    private class DeferredAckMessageBuffer
    extends ReentrantReadWriteLock
    implements GridTimeoutObject {
        private static final long serialVersionUID = 0L;
        private AtomicBoolean guard = new AtomicBoolean(false);
        private FastSizeDeque<T> vers = new FastSizeDeque(new ConcurrentLinkedDeque());
        private final UUID nodeId;
        private final IgniteUuid timeoutId;
        private final long endTime;

        private DeferredAckMessageBuffer(UUID nodeId) {
            this.nodeId = nodeId;
            this.timeoutId = IgniteUuid.fromUuid(nodeId);
            this.endTime = U.currentTimeMillis() + (long)GridDeferredAckMessageSender.this.getTimeout();
        }

        @Override
        public IgniteUuid timeoutId() {
            return this.timeoutId;
        }

        @Override
        public long endTime() {
            return this.endTime;
        }

        @Override
        public void onTimeout() {
            if (this.guard.compareAndSet(false, true)) {
                GridDeferredAckMessageSender.this.c.runLocalSafe(new GridPlainRunnable(){

                    @Override
                    public void run() {
                        DeferredAckMessageBuffer.this.writeLock().lock();
                        try {
                            DeferredAckMessageBuffer.this.finish0();
                        }
                        finally {
                            DeferredAckMessageBuffer.this.writeLock().unlock();
                        }
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean add(T ver) {
            if (!this.readLock().tryLock()) {
                return false;
            }
            boolean snd = false;
            try {
                if (this.guard.get()) {
                    boolean bl = false;
                    return bl;
                }
                this.vers.add(ver);
                if (this.vers.sizex() > GridDeferredAckMessageSender.this.getBufferSize() && this.guard.compareAndSet(false, true)) {
                    snd = true;
                }
            }
            finally {
                this.readLock().unlock();
            }
            if (snd) {
                this.writeLock().lock();
                try {
                    this.finish0();
                    GridDeferredAckMessageSender.this.time.removeTimeoutObject(this);
                }
                finally {
                    this.writeLock().unlock();
                }
            }
            return true;
        }

        private void finish0() {
            GridDeferredAckMessageSender.this.finish(this.nodeId, this.vers);
            GridDeferredAckMessageSender.this.deferredAckMsgBuffers.remove(this.nodeId, this);
        }
    }
}

