/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.cache;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.ignite.internal.client.GridClientNode;
import org.apache.ignite.internal.commandline.cache.check_indexes_inline_size.CheckIndexInlineSizesResult;
import org.apache.ignite.internal.commandline.cache.check_indexes_inline_size.CheckIndexInlineSizesTask;
import org.apache.ignite.internal.management.api.CommandUtils;
import org.apache.ignite.internal.management.api.ComputeCommand;
import org.apache.ignite.internal.management.api.NoArg;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.SB;

public class CacheCheckIndexInlineSizesCommand
implements ComputeCommand<NoArg, CheckIndexInlineSizesResult> {
    public static final String INDEXES_INLINE_SIZE_ARE_THE_SAME = "All secondary indexes have the same effective inline size on all cluster nodes.";

    @Override
    public String description() {
        return "Checks that secondary indexes inline size are same on the cluster nodes";
    }

    @Override
    public Class<NoArg> argClass() {
        return NoArg.class;
    }

    @Override
    public Class<CheckIndexInlineSizesTask> taskClass() {
        return CheckIndexInlineSizesTask.class;
    }

    @Override
    public Collection<GridClientNode> nodes(Collection<GridClientNode> nodes, NoArg arg) {
        return CommandUtils.servers(nodes);
    }

    @Override
    public void printResult(NoArg arg, CheckIndexInlineSizesResult res, Consumer<String> printer) {
        HashMap<String, Map> idxToSizeNode = new HashMap<String, Map>();
        for (Map.Entry<UUID, Map<String, Integer>> nodeRes : res.inlineSizes().entrySet()) {
            for (Map.Entry<String, Integer> idx : nodeRes.getValue().entrySet()) {
                Map sizeToNodes = idxToSizeNode.computeIfAbsent(idx.getKey(), x -> new HashMap());
                sizeToNodes.computeIfAbsent(idx.getValue(), x -> new HashSet()).add(nodeRes.getKey());
            }
        }
        printer.accept("Found " + idxToSizeNode.size() + " secondary indexes.");
        Map<String, Map<Integer, Set<UUID>>> problems = idxToSizeNode.entrySet().stream().filter(e -> ((Map)e.getValue()).size() > 1).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        if (F.isEmpty(problems)) {
            printer.accept(INDEXES_INLINE_SIZE_ARE_THE_SAME);
        } else {
            this.printProblemsAndShowRecommendations(problems, printer);
        }
    }

    private void printProblemsAndShowRecommendations(Map<String, Map<Integer, Set<UUID>>> problems, Consumer<String> printer) {
        printer.accept(problems.size() + " index(es) have different effective inline size on nodes. It can lead to performance degradation in SQL queries.");
        printer.accept("Index(es):");
        for (Map.Entry<String, Map<Integer, Set<UUID>>> entry : problems.entrySet()) {
            SB sb = new SB();
            sb.a("Full index name: ").a(entry.getKey());
            for (Integer size : entry.getValue().keySet()) {
                sb.a(" nodes: ").a(entry.getValue().get(size)).a(" inline size: ").a(size).a(",");
            }
            sb.setLength(sb.length() - 1);
            printer.accept("  " + sb);
        }
        printer.accept("");
        printer.accept("Recommendations:");
        printer.accept("  Check that value of property IGNITE_MAX_INDEX_PAYLOAD_SIZE are the same on all nodes.");
        printer.accept("  Recreate indexes (execute DROP INDEX, CREATE INDEX commands) with different inline size.");
    }
}

