/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.eviction.fifo;

import java.util.Collection;
import java.util.Collections;
import org.apache.ignite.cache.eviction.AbstractEvictionPolicy;
import org.apache.ignite.cache.eviction.EvictableEntry;
import org.apache.ignite.cache.eviction.fifo.FifoEvictionPolicyMBean;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.mxbean.IgniteMBeanAware;
import org.jsr166.ConcurrentLinkedDeque8;

public class FifoEvictionPolicy<K, V>
extends AbstractEvictionPolicy<K, V>
implements IgniteMBeanAware {
    private static final long serialVersionUID = 0L;
    private final ConcurrentLinkedDeque8<EvictableEntry<K, V>> queue = new ConcurrentLinkedDeque8();

    public FifoEvictionPolicy() {
    }

    public FifoEvictionPolicy(int max) {
        this.setMaxSize(max);
    }

    public FifoEvictionPolicy(int max, int batchSize) {
        this.setMaxSize(max);
        this.setBatchSize(batchSize);
    }

    @Override
    public int getCurrentSize() {
        return this.queue.sizex();
    }

    @Override
    public FifoEvictionPolicy<K, V> setMaxMemorySize(long maxMemSize) {
        super.setMaxMemorySize(maxMemSize);
        return this;
    }

    @Override
    public FifoEvictionPolicy<K, V> setMaxSize(int max) {
        super.setMaxSize(max);
        return this;
    }

    @Override
    public FifoEvictionPolicy<K, V> setBatchSize(int batchSize) {
        super.setBatchSize(batchSize);
        return this;
    }

    public Collection<EvictableEntry<K, V>> queue() {
        return Collections.unmodifiableCollection(this.queue);
    }

    @Override
    protected boolean removeMeta(Object meta) {
        return this.queue.unlinkx((ConcurrentLinkedDeque8.Node)meta);
    }

    @Override
    protected boolean touch(EvictableEntry<K, V> entry) {
        ConcurrentLinkedDeque8.Node<EvictableEntry<K, V>> node = (ConcurrentLinkedDeque8.Node<EvictableEntry<K, V>>)entry.meta();
        if (node == null) {
            do {
                if (entry.putMetaIfAbsent(node = this.queue.offerLastx(entry)) != null) {
                    this.queue.unlinkx(node);
                    return false;
                }
                if (node.item() == null) continue;
                if (!entry.isCached()) {
                    this.queue.unlinkx(node);
                    return false;
                }
                this.memSize.add(entry.size());
                return true;
            } while (entry.removeMeta(node));
            return false;
        }
        return false;
    }

    @Override
    protected int shrink0() {
        EvictableEntry<K, V> entry = this.queue.poll();
        if (entry == null) {
            return -1;
        }
        int size = 0;
        ConcurrentLinkedDeque8.Node meta = (ConcurrentLinkedDeque8.Node)entry.removeMeta();
        if (meta != null) {
            size = entry.size();
            this.memSize.add(-size);
            if (!entry.evict()) {
                this.touch(entry);
            }
        }
        return size;
    }

    @Override
    public Object getMBean() {
        return new FifoEvictionPolicyMBeanImpl();
    }

    public String toString() {
        return S.toString(FifoEvictionPolicy.class, this);
    }

    private class FifoEvictionPolicyMBeanImpl
    implements FifoEvictionPolicyMBean {
        private FifoEvictionPolicyMBeanImpl() {
        }

        @Override
        public long getCurrentMemorySize() {
            return FifoEvictionPolicy.this.getCurrentMemorySize();
        }

        @Override
        public int getCurrentSize() {
            return FifoEvictionPolicy.this.getCurrentSize();
        }

        @Override
        public int getMaxSize() {
            return FifoEvictionPolicy.this.getMaxSize();
        }

        @Override
        public void setMaxSize(int max) {
            FifoEvictionPolicy.this.setMaxSize(max);
        }

        @Override
        public int getBatchSize() {
            return FifoEvictionPolicy.this.getBatchSize();
        }

        @Override
        public void setBatchSize(int batchSize) {
            FifoEvictionPolicy.this.setBatchSize(batchSize);
        }

        @Override
        public long getMaxMemorySize() {
            return FifoEvictionPolicy.this.getMaxMemorySize();
        }

        @Override
        public void setMaxMemorySize(long maxMemSize) {
            FifoEvictionPolicy.this.setMaxMemorySize(maxMemSize);
        }
    }
}

