/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence;

import org.apache.ignite.DataRegionMetrics;

public class DataRegionMetricsSnapshot
implements DataRegionMetrics {
    private final String name;
    private final long totalAllocatedPages;
    private final long totalAllocatedSize;
    private final long totalUsedPages;
    private final long totalUsedSize;
    private final float allocationRate;
    private final float evictionRate;
    private final float largeEntriesPagesPercentage;
    private final float pagesFillFactor;
    private final long dirtyPages;
    private final float pageReplaceRate;
    private final float pageReplaceAge;
    private final long physicalMemoryPages;
    private final long physicalMemorySize;
    private final long usedCheckpointBufferPages;
    private final long usedCheckpointBufferSize;
    private final long checkpointBufferSize;
    private final int pageSize;
    private final long readPages;
    private final long writtenPages;
    private final long replacedPage;
    private final long offHeapSize;
    private final long offHeapUsedSize;

    public DataRegionMetricsSnapshot(DataRegionMetrics metrics) {
        this.name = metrics.getName();
        this.totalAllocatedPages = metrics.getTotalAllocatedPages();
        this.totalAllocatedSize = metrics.getTotalAllocatedSize();
        this.totalUsedPages = metrics.getTotalUsedPages();
        this.totalUsedSize = metrics.getTotalUsedSize();
        this.allocationRate = metrics.getAllocationRate();
        this.evictionRate = metrics.getEvictionRate();
        this.largeEntriesPagesPercentage = metrics.getLargeEntriesPagesPercentage();
        this.pagesFillFactor = metrics.getPagesFillFactor();
        this.dirtyPages = metrics.getDirtyPages();
        this.pageReplaceRate = metrics.getPagesReplaceRate();
        this.pageReplaceAge = metrics.getPagesReplaceAge();
        this.physicalMemoryPages = metrics.getPhysicalMemoryPages();
        this.physicalMemorySize = metrics.getPhysicalMemorySize();
        this.usedCheckpointBufferPages = metrics.getUsedCheckpointBufferPages();
        this.usedCheckpointBufferSize = metrics.getUsedCheckpointBufferSize();
        this.checkpointBufferSize = metrics.getCheckpointBufferSize();
        this.pageSize = metrics.getPageSize();
        this.readPages = metrics.getPagesRead();
        this.writtenPages = metrics.getPagesWritten();
        this.replacedPage = metrics.getPagesReplaced();
        this.offHeapSize = metrics.getOffHeapSize();
        this.offHeapUsedSize = metrics.getOffheapUsedSize();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getTotalAllocatedPages() {
        return this.totalAllocatedPages;
    }

    @Override
    public long getTotalAllocatedSize() {
        return this.totalAllocatedSize;
    }

    @Override
    public long getTotalUsedPages() {
        return this.totalUsedPages;
    }

    @Override
    public long getTotalUsedSize() {
        return this.totalUsedSize;
    }

    @Override
    public float getAllocationRate() {
        return this.allocationRate;
    }

    @Override
    public float getEvictionRate() {
        return this.evictionRate;
    }

    @Override
    public float getLargeEntriesPagesPercentage() {
        return this.largeEntriesPagesPercentage;
    }

    @Override
    public float getPagesFillFactor() {
        return this.pagesFillFactor;
    }

    @Override
    public long getDirtyPages() {
        return this.dirtyPages;
    }

    @Override
    public float getPagesReplaceRate() {
        return this.pageReplaceRate;
    }

    @Override
    public float getPagesReplaceAge() {
        return this.pageReplaceAge;
    }

    @Override
    public long getPhysicalMemoryPages() {
        return this.physicalMemoryPages;
    }

    @Override
    public long getPhysicalMemorySize() {
        return this.physicalMemorySize;
    }

    @Override
    public long getUsedCheckpointBufferPages() {
        return this.usedCheckpointBufferPages;
    }

    @Override
    public long getUsedCheckpointBufferSize() {
        return this.usedCheckpointBufferSize;
    }

    @Override
    public long getCheckpointBufferSize() {
        return this.checkpointBufferSize;
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public long getPagesRead() {
        return this.readPages;
    }

    @Override
    public long getPagesWritten() {
        return this.writtenPages;
    }

    @Override
    public long getPagesReplaced() {
        return this.replacedPage;
    }

    @Override
    public long getOffHeapSize() {
        return this.offHeapSize;
    }

    @Override
    public long getOffheapUsedSize() {
        return this.offHeapUsedSize;
    }
}

