/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.mem;

import org.apache.ignite.internal.mem.DirectMemoryRegion;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;

public class UnsafeChunk
implements DirectMemoryRegion {
    private long ptr;
    private long len;

    public UnsafeChunk(long ptr, long len) {
        this.ptr = ptr;
        this.len = len;
    }

    @Override
    public long address() {
        return this.ptr;
    }

    @Override
    public long size() {
        return this.len;
    }

    @Override
    public DirectMemoryRegion slice(long offset) {
        if (offset < 0L || offset >= this.len) {
            throw new IllegalArgumentException("Failed to create a memory region slice [ptr=" + U.hexLong(this.ptr) + ", len=" + this.len + ", offset=" + offset + "]");
        }
        return new UnsafeChunk(this.ptr + offset, this.len - offset);
    }

    public String toString() {
        return S.toString(UnsafeChunk.class, this);
    }
}

