/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Objects;
import org.apache.ignite.cache.affinity.AffinityKeyMapped;
import org.apache.ignite.internal.util.typedef.internal.S;

public class CacheKeyConfiguration
implements Serializable {
    private static final long serialVersionUID = 0L;
    private String typeName;
    private String affKeyFieldName;

    public CacheKeyConfiguration() {
    }

    public CacheKeyConfiguration(Class keyCls) {
        this.typeName = keyCls.getName();
        while (keyCls != Object.class && keyCls != null) {
            for (Field f : keyCls.getDeclaredFields()) {
                if (f.getAnnotation(AffinityKeyMapped.class) == null) continue;
                this.affKeyFieldName = f.getName();
                return;
            }
            keyCls = keyCls.getSuperclass();
        }
    }

    public CacheKeyConfiguration(String typeName, String affKeyFieldName) {
        this.typeName = typeName;
        this.affKeyFieldName = affKeyFieldName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public CacheKeyConfiguration setTypeName(String typeName) {
        this.typeName = typeName;
        return this;
    }

    public String getAffinityKeyFieldName() {
        return this.affKeyFieldName;
    }

    public CacheKeyConfiguration setAffinityKeyFieldName(String affKeyFieldName) {
        this.affKeyFieldName = affKeyFieldName;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CacheKeyConfiguration that = (CacheKeyConfiguration)o;
        if (!Objects.equals(this.typeName, that.typeName)) {
            return false;
        }
        return Objects.equals(this.affKeyFieldName, that.affKeyFieldName);
    }

    public int hashCode() {
        int result = this.typeName != null ? this.typeName.hashCode() : 0;
        result = 31 * result + (this.affKeyFieldName != null ? this.affKeyFieldName.hashCode() : 0);
        return result;
    }

    public String toString() {
        return S.toString(CacheKeyConfiguration.class, this);
    }
}

