/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.rule;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.PhysicalNode;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.ignite.internal.processors.query.calcite.prepare.BaseQueryContext;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteConvention;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteIndexScan;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteTableScan;
import org.apache.ignite.internal.processors.query.calcite.rel.ProjectableFilterableTableScan;
import org.apache.ignite.internal.processors.query.calcite.rel.logical.IgniteLogicalIndexScan;
import org.apache.ignite.internal.processors.query.calcite.rel.logical.IgniteLogicalTableScan;
import org.apache.ignite.internal.processors.query.calcite.rule.AbstractIgniteConverterRule;
import org.apache.ignite.internal.processors.query.calcite.schema.IgniteIndex;
import org.apache.ignite.internal.processors.query.calcite.schema.IgniteTable;
import org.apache.ignite.internal.processors.query.calcite.trait.CorrelationTrait;
import org.apache.ignite.internal.processors.query.calcite.trait.IgniteDistribution;
import org.apache.ignite.internal.processors.query.calcite.trait.IgniteDistributions;
import org.apache.ignite.internal.processors.query.calcite.trait.RewindabilityTrait;
import org.apache.ignite.internal.processors.query.calcite.util.RexUtils;
import org.apache.ignite.internal.util.typedef.F;

public abstract class LogicalScanConverterRule<T extends ProjectableFilterableTableScan>
extends AbstractIgniteConverterRule<T> {
    public static final LogicalScanConverterRule<IgniteLogicalIndexScan> INDEX_SCAN = new LogicalScanConverterRule<IgniteLogicalIndexScan>(IgniteLogicalIndexScan.class, "LogicalIndexScanConverterRule"){

        @Override
        protected PhysicalNode convert(RelOptPlanner planner, RelMetadataQuery mq, IgniteLogicalIndexScan rel) {
            RelOptCluster cluster = rel.getCluster();
            IgniteTable table = (IgniteTable)rel.getTable().unwrap(IgniteTable.class);
            IgniteIndex idx = table.getIndex(rel.indexName());
            if (table.isIndexRebuildInProgress()) {
                cluster.getPlanner().prune((RelNode)rel);
                return null;
            }
            BaseQueryContext baseQryCtx = (BaseQueryContext)planner.getContext().unwrap(BaseQueryContext.class);
            IgniteDistribution distribution = baseQryCtx.isLocal() ? IgniteDistributions.single() : table.distribution();
            RelCollation collation = idx.collation();
            if (rel.projects() != null || rel.requiredColumns() != null) {
                Mappings.TargetMapping mapping = 1.createMapping(rel.projects(), rel.requiredColumns(), table.getRowType(cluster.getTypeFactory()).getFieldCount());
                distribution = distribution.apply(mapping);
                collation = (RelCollation)collation.apply(mapping);
            }
            RelTraitSet traits = rel.getCluster().traitSetOf((RelTrait)IgniteConvention.INSTANCE).replace((RelTrait)RewindabilityTrait.REWINDABLE).replace((RelTrait)distribution).replace((RelTrait)collation);
            Set<CorrelationId> corrIds = RexUtils.extractCorrelationIds(rel.condition());
            if (!F.isEmpty(rel.projects())) {
                corrIds = new HashSet<CorrelationId>(corrIds);
                corrIds.addAll(RexUtils.extractCorrelationIds(rel.projects()));
            }
            if (!corrIds.isEmpty()) {
                traits = traits.replace((RelTrait)CorrelationTrait.correlations(corrIds));
            }
            return new IgniteIndexScan(cluster, traits, rel.getTable(), rel.indexName(), rel.projects(), rel.condition(), rel.searchBounds(), rel.requiredColumns(), idx.collation());
        }
    };
    public static final LogicalScanConverterRule<IgniteLogicalTableScan> TABLE_SCAN = new LogicalScanConverterRule<IgniteLogicalTableScan>(IgniteLogicalTableScan.class, "LogicalTableScanConverterRule"){

        @Override
        protected PhysicalNode convert(RelOptPlanner planner, RelMetadataQuery mq, IgniteLogicalTableScan rel) {
            RelOptCluster cluster = rel.getCluster();
            IgniteTable table = (IgniteTable)rel.getTable().unwrap(IgniteTable.class);
            BaseQueryContext baseQryCtx = (BaseQueryContext)planner.getContext().unwrap(BaseQueryContext.class);
            IgniteDistribution distribution = baseQryCtx.isLocal() ? IgniteDistributions.single() : table.distribution();
            if (rel.requiredColumns() != null) {
                Mappings.TargetMapping mapping = 2.createMapping(rel.projects(), rel.requiredColumns(), table.getRowType(cluster.getTypeFactory()).getFieldCount());
                distribution = distribution.apply(mapping);
            }
            RelTraitSet traits = cluster.traitSetOf((RelTrait)IgniteConvention.INSTANCE).replace((RelTrait)RewindabilityTrait.REWINDABLE).replace((RelTrait)distribution);
            Set<CorrelationId> corrIds = RexUtils.extractCorrelationIds(rel.condition());
            if (!F.isEmpty(rel.projects())) {
                corrIds = new HashSet<CorrelationId>(corrIds);
                corrIds.addAll(RexUtils.extractCorrelationIds(rel.projects()));
            }
            if (!corrIds.isEmpty()) {
                traits = traits.replace((RelTrait)CorrelationTrait.correlations(corrIds));
            }
            return new IgniteTableScan(rel.getCluster(), traits, rel.getTable(), rel.projects(), rel.condition(), rel.requiredColumns());
        }
    };

    private LogicalScanConverterRule(Class<T> clazz, String descPrefix) {
        super(clazz, descPrefix);
    }

    public static Mappings.TargetMapping createMapping(List<RexNode> projects, ImmutableBitSet requiredColumns, int tableRowSize) {
        if (projects != null) {
            Mappings.IdentityMapping trimmingMapping = requiredColumns != null ? Mappings.invert((Mapping)Mappings.source((List)requiredColumns.asList(), (int)tableRowSize)) : Mappings.createIdentity((int)tableRowSize);
            HashMap<Integer, Integer> mappingMap = new HashMap<Integer, Integer>();
            for (int i = 0; i < projects.size(); ++i) {
                RexNode rex = projects.get(i);
                if (!(rex instanceof RexLocalRef)) continue;
                RexLocalRef ref = (RexLocalRef)rex;
                mappingMap.put(trimmingMapping.getSource(ref.getIndex()), i);
            }
            return Mappings.target(mappingMap, (int)tableRowSize, (int)projects.size());
        }
        if (requiredColumns != null) {
            return Mappings.target((List)requiredColumns.asList(), (int)tableRowSize);
        }
        return Mappings.createIdentity((int)tableRowSize);
    }
}

