/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.exporter.trace;

import com.google.common.util.concurrent.SimpleTimeLimiter;
import com.google.errorprone.annotations.MustBeClosed;
import io.opencensus.common.Duration;
import io.opencensus.common.Scope;
import io.opencensus.trace.Sampler;
import io.opencensus.trace.Status;
import io.opencensus.trace.Tracer;
import io.opencensus.trace.export.SpanData;
import io.opencensus.trace.export.SpanExporter;
import io.opencensus.trace.samplers.Samplers;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class TimeLimitedHandler
extends SpanExporter.Handler {
    private static final Logger logger = Logger.getLogger(TimeLimitedHandler.class.getName());
    private static final Sampler lowProbabilitySampler = Samplers.probabilitySampler((double)1.0E-4);
    private final Tracer tracer;
    private final Duration deadline;
    private final String exportSpanName;

    protected TimeLimitedHandler(Tracer tracer, Duration deadline, String exportSpanName) {
        this.tracer = tracer;
        this.deadline = deadline;
        this.exportSpanName = exportSpanName;
    }

    public abstract void timeLimitedExport(Collection<SpanData> var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(final Collection<SpanData> spanDataList) {
        try (Scope exportScope = this.newExportScope();){
            SimpleTimeLimiter timeLimiter = SimpleTimeLimiter.create((ExecutorService)Executors.newSingleThreadExecutor());
            timeLimiter.callWithTimeout((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    TimeLimitedHandler.this.timeLimitedExport(spanDataList);
                    return null;
                }
            }, this.deadline.toMillis(), TimeUnit.MILLISECONDS);
        }
    }

    @MustBeClosed
    private Scope newExportScope() {
        return this.tracer.spanBuilder(this.exportSpanName).setSampler(lowProbabilitySampler).startScopedSpan();
    }

    private void handleException(Exception e, String logMessage) {
        Status status = e instanceof TimeoutException ? Status.DEADLINE_EXCEEDED : Status.UNKNOWN;
        this.tracer.getCurrentSpan().setStatus(status.withDescription(e.getMessage() == null ? e.getClass().getSimpleName() : e.getMessage()));
        logger.log(Level.WARNING, logMessage);
    }
}

