/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.dumpprocessors;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.SharedPageLockTrackerDump;
import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.dumpprocessors.ToStringDumpHelper;

public class ToFileDumpProcessor {
    public static final DateTimeFormatter DATE_FMT = DateTimeFormatter.ofPattern("yyyy_MM_dd_HH_mm_ss_SSS").withZone(ZoneId.systemDefault());
    public static final String PREFIX_NAME = "page_lock_dump_";

    public static String toFileDump(SharedPageLockTrackerDump pageLockDump, Path dir, String name) throws IgniteCheckedException {
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
            String dumpName = PREFIX_NAME + name + "_" + DATE_FMT.format(Instant.ofEpochMilli(pageLockDump.time));
            Path file = dir.resolve(dumpName);
            Files.write(file, ToStringDumpHelper.toStringDump(pageLockDump).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            return file.toAbsolutePath().toString();
        }
        catch (IOException e) {
            throw new IgniteCheckedException(e);
        }
    }
}

