/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.consistency;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.internal.management.api.NoArg;
import org.apache.ignite.internal.management.consistency.AbstractConsistencyTask;
import org.apache.ignite.internal.management.consistency.ConsistencyTaskResult;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.resources.LoggerResource;

public class ConsistencyStatusTask
extends AbstractConsistencyTask<NoArg, String> {
    private static final long serialVersionUID = 0L;
    public static final String NOTHING_FOUND = "Consistency check/repair operations were NOT found.";
    public static final ConcurrentHashMap<String, String> MAP = new ConcurrentHashMap();

    @Override
    protected VisorJob<NoArg, String> job(NoArg arg) {
        return new ConsistencyStatusJob(arg, this.debug);
    }

    @Override
    protected ConsistencyTaskResult reduce0(List<ComputeJobResult> results) throws IgniteException {
        Object taskRes = super.reduce0((List)results);
        if (((ConsistencyTaskResult)taskRes).message() == null) {
            ((ConsistencyTaskResult)taskRes).message(NOTHING_FOUND);
        }
        return taskRes;
    }

    private static class ConsistencyStatusJob
    extends VisorJob<NoArg, String> {
        private static final long serialVersionUID = 0L;
        @LoggerResource
        protected IgniteLogger log;

        protected ConsistencyStatusJob(NoArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected String run(NoArg arg) throws IgniteException {
            if (MAP.isEmpty()) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, String> entry : MAP.entrySet()) {
                sb.append("\n    Job: ").append(entry.getKey()).append("\n").append("    Status: ").append(entry.getValue()).append("\n");
            }
            return sb.toString();
        }
    }
}

