/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.cache.load.model;

import java.util.UUID;
import org.apache.ignite.yardstick.cache.load.model.key.Identifier;
import org.apache.ignite.yardstick.cache.load.model.key.Mark;
import org.apache.ignite.yardstick.cache.load.model.value.Car;
import org.apache.ignite.yardstick.cache.load.model.value.Color;
import org.apache.ignite.yardstick.cache.load.model.value.Truck;
import org.apache.ignite.yardstick.cache.model.Account;
import org.apache.ignite.yardstick.cache.model.Organization;
import org.apache.ignite.yardstick.cache.model.Person;
import org.apache.ignite.yardstick.cache.model.Person1;
import org.apache.ignite.yardstick.cache.model.Person2;
import org.apache.ignite.yardstick.cache.model.Person8;

public class ModelUtil {
    private static Class[] keyClasses = new Class[]{Integer.class, Double.class, Identifier.class, Mark.class, Integer.class, UUID.class, String.class};
    private static Class[] valClasses = new Class[]{Person.class, Organization.class, Account.class, Person1.class, Person2.class, Person8.class};
    private static Class[] simpleClasses = new Class[]{Account.class, Person1.class, Person2.class};
    private static Class[] fatClasses = new Class[]{Person.class, Person8.class, Organization.class};

    public static boolean canCreateInstance(Class clazz) {
        for (Class c : keyClasses) {
            if (!c.equals(clazz)) continue;
            return true;
        }
        for (Class c : valClasses) {
            if (!c.equals(clazz)) continue;
            return true;
        }
        return false;
    }

    public static Object create(Class c, int id) {
        Object res;
        switch (c.getSimpleName()) {
            case "Double": {
                res = id;
                break;
            }
            case "Identifier": {
                res = new Identifier(id, "id " + id);
                break;
            }
            case "Mark": {
                res = new Mark(id, UUID.nameUUIDFromBytes(Integer.toString(id).getBytes()));
                break;
            }
            case "Integer": {
                res = id;
                break;
            }
            case "UUID": {
                res = UUID.nameUUIDFromBytes(Integer.toString(id).getBytes());
                break;
            }
            case "Car": {
                int colorCnt = Color.values().length;
                res = new Car(id, "Mark " + id, (double)id / 2.123 * 100.0, Color.values()[id % colorCnt]);
                break;
            }
            case "Truck": {
                int colors = Color.values().length;
                res = new Truck(id, "Mark " + id, (double)id / 2.123 * 100.0, Color.values()[id % colors], (double)id / 4.123 * 100.0);
                break;
            }
            case "Person": {
                res = new Person(id, id + 1, "First Name " + id, "Last Name " + id, (double)id / 2.123 * 100.0);
                break;
            }
            case "Organization": {
                res = new Organization(id, "Organization " + id);
                break;
            }
            case "Account": {
                res = new Account(id);
                break;
            }
            case "Person1": {
                res = new Person1(id);
                break;
            }
            case "Person2": {
                res = new Person2(id);
                break;
            }
            case "Person8": {
                res = new Person8(id);
                break;
            }
            case "String": {
                res = String.valueOf(id);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported class: " + c.getSimpleName());
            }
        }
        return res;
    }

    public static Class[] keyClasses() {
        return keyClasses;
    }

    public static Class[] valueClasses() {
        return valClasses;
    }

    public static Class[] simpleValueClasses() {
        return simpleClasses;
    }

    public static Class[] fatValueClasses() {
        return fatClasses;
    }
}

