/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.ignite.client.ClientCache;
import org.apache.ignite.client.IgniteClient;
import org.apache.ignite.yardstick.IgniteBenchmarkArguments;
import org.apache.ignite.yardstick.IgniteThinClient;
import org.apache.ignite.yardstick.thin.cache.IgniteThinBenchmarkUtils;
import org.yardstickframework.BenchmarkConfiguration;
import org.yardstickframework.BenchmarkDriver;
import org.yardstickframework.BenchmarkDriverAdapter;
import org.yardstickframework.BenchmarkUtils;

public abstract class IgniteThinAbstractBenchmark
extends BenchmarkDriverAdapter {
    protected final IgniteBenchmarkArguments args = new IgniteBenchmarkArguments();
    private ThreadLocal<IgniteClient> client;
    private ConcurrentLinkedDeque<String> servHosts;

    public void setUp(final BenchmarkConfiguration cfg) throws Exception {
        super.setUp(cfg);
        BenchmarkUtils.jcommander((String[])cfg.commandLineArguments(), (Object)this.args, (String)"<ignite-driver>");
        String locIp = IgniteThinBenchmarkUtils.getLocalIp(cfg);
        this.client = new ThreadLocal<IgniteClient>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected IgniteClient initialValue() {
                Class<IgniteThinAbstractBenchmark> clazz = IgniteThinAbstractBenchmark.class;
                synchronized (IgniteThinAbstractBenchmark.class) {
                    try {
                        if (IgniteThinAbstractBenchmark.this.servHosts == null || IgniteThinAbstractBenchmark.this.servHosts.isEmpty()) {
                            IgniteThinAbstractBenchmark.this.setServHosts(cfg);
                        }
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return new IgniteThinClient().start(cfg, IgniteThinAbstractBenchmark.this.servHosts.poll());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return null;
                    }
                }
            }
        };
        BenchmarkUtils.println((String)"Custom properties:");
        for (String prop : cfg.customProperties().keySet()) {
            BenchmarkUtils.println((String)String.format("%s=%s", prop, cfg.customProperties().get(prop)));
        }
        ClientCache utilCache = this.client().getOrCreateCache("start-util-cache");
        utilCache.put((Object)locIp, (Object)"started");
        List<String> hostList = IgniteThinBenchmarkUtils.drvHostList(cfg);
        int cnt = 0;
        while (!this.checkIfAllClientsStarted(hostList) && cnt++ < 600) {
            Thread.sleep(500L);
        }
    }

    private synchronized void setServHosts(BenchmarkConfiguration cfg) {
        BenchmarkUtils.println((String)"Setting serv host queue");
        String[] servHostArr = IgniteThinBenchmarkUtils.servHostArr(cfg);
        this.servHosts = new ConcurrentLinkedDeque<String>(Arrays.asList(servHostArr));
    }

    private boolean checkIfAllClientsStarted(List<String> hostList) {
        ClientCache utilCache = this.client().getOrCreateCache("start-util-cache");
        for (String host : hostList) {
            String res;
            if (host.equals("localhost")) {
                host = "127.0.0.1";
            }
            if ((res = (String)utilCache.get((Object)host)) != null && res.equals("started")) continue;
            return false;
        }
        return true;
    }

    public void tearDown() throws Exception {
        if (this.client.get() != null) {
            this.client.get().close();
        }
    }

    public String description() {
        String desc = BenchmarkUtils.description((BenchmarkConfiguration)this.cfg, (BenchmarkDriver)this);
        return desc.isEmpty() ? ((Object)((Object)this)).getClass().getSimpleName() + this.args.description() + this.cfg.defaultDescription() : desc;
    }

    protected IgniteClient client() {
        return this.client.get();
    }

    public static int nextRandom(int max) {
        return ThreadLocalRandom.current().nextInt(max);
    }

    protected int nextRandom(int min, int max) {
        return ThreadLocalRandom.current().nextInt(max - min) + min;
    }
}

