/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.kafka.clients.admin.ClassicGroupDescription;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.annotation.InterfaceStability;

@InterfaceStability.Evolving
public class DescribeClassicGroupsResult {
    private final Map<String, KafkaFuture<ClassicGroupDescription>> futures;

    public DescribeClassicGroupsResult(Map<String, KafkaFuture<ClassicGroupDescription>> futures) {
        this.futures = futures;
    }

    public Map<String, KafkaFuture<ClassicGroupDescription>> describedGroups() {
        return new HashMap<String, KafkaFuture<ClassicGroupDescription>>(this.futures);
    }

    public KafkaFuture<Map<String, ClassicGroupDescription>> all() {
        return KafkaFuture.allOf(this.futures.values().toArray(new KafkaFuture[0])).thenApply(nil -> {
            HashMap descriptions = new HashMap(this.futures.size());
            this.futures.forEach((key, future) -> {
                try {
                    descriptions.put(key, (ClassicGroupDescription)future.get());
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
            });
            return descriptions;
        });
    }
}

