/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.websocket.jakarta.server;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.websocket.ClientEndpoint;
import jakarta.websocket.DeploymentException;
import jakarta.websocket.Endpoint;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.server.ServerContainer;
import jakarta.websocket.server.ServerEndpoint;
import jakarta.websocket.server.ServerEndpointConfig;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Function;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.servlet.ServletContextRequest;
import org.eclipse.jetty.ee10.servlet.ServletContextResponse;
import org.eclipse.jetty.ee10.websocket.jakarta.client.JakartaWebSocketClientContainer;
import org.eclipse.jetty.ee10.websocket.jakarta.server.JakartaWebSocketServerFrameHandlerFactory;
import org.eclipse.jetty.ee10.websocket.jakarta.server.config.ContainerDefaultConfigurator;
import org.eclipse.jetty.ee10.websocket.jakarta.server.internal.AnnotatedServerEndpointConfig;
import org.eclipse.jetty.ee10.websocket.jakarta.server.internal.JakartaWebSocketCreator;
import org.eclipse.jetty.http.pathmap.UriTemplatePathSpec;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.FutureCallback;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.websocket.core.WebSocketComponents;
import org.eclipse.jetty.websocket.core.client.WebSocketCoreClient;
import org.eclipse.jetty.websocket.core.exception.InvalidSignatureException;
import org.eclipse.jetty.websocket.core.server.Handshaker;
import org.eclipse.jetty.websocket.core.server.WebSocketMappings;
import org.eclipse.jetty.websocket.core.server.WebSocketNegotiator;
import org.eclipse.jetty.websocket.core.server.WebSocketServerComponents;
import org.eclipse.jetty.websocket.core.util.ReflectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedObject(value="JSR356 Server Container")
public class JakartaWebSocketServerContainer
extends JakartaWebSocketClientContainer
implements ServerContainer,
LifeCycle.Listener {
    public static final String PATH_PARAM_ATTRIBUTE = "jakarta.websocket.server.pathParams";
    public static final String JAKARTA_WEBSOCKET_CONTAINER_ATTRIBUTE = ServerContainer.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger(JakartaWebSocketServerContainer.class);
    private final WebSocketMappings webSocketMappings;
    private final JakartaWebSocketServerFrameHandlerFactory frameHandlerFactory;
    private List<Class<?>> deferredEndpointClasses;
    private List<ServerEndpointConfig> deferredEndpointConfigs;

    public static JakartaWebSocketServerContainer getContainer(ServletContext servletContext) {
        return (JakartaWebSocketServerContainer)servletContext.getAttribute(JAKARTA_WEBSOCKET_CONTAINER_ATTRIBUTE);
    }

    public static JakartaWebSocketServerContainer ensureContainer(final ServletContext servletContext) {
        final ServletContextHandler contextHandler = ServletContextHandler.getServletContextHandler(servletContext, "Jakarta Websocket");
        if (contextHandler.getServer() == null) {
            throw new IllegalStateException("Server has not been set on the ServletContextHandler");
        }
        JakartaWebSocketServerContainer containerFromServletContext = JakartaWebSocketServerContainer.getContainer(servletContext);
        if (containerFromServletContext != null) {
            return containerFromServletContext;
        }
        Function<WebSocketComponents, WebSocketCoreClient> coreClientSupplier = wsComponents -> {
            WebSocketCoreClient coreClient = (WebSocketCoreClient)servletContext.getAttribute(WebSocketCoreClient.WEBSOCKET_CORECLIENT_ATTRIBUTE);
            if (coreClient == null) {
                HttpClient httpClient = (HttpClient)servletContext.getAttribute("org.eclipse.jetty.websocket.jakarta.HttpClient");
                if (httpClient == null) {
                    httpClient = (HttpClient)contextHandler.getServer().getAttribute("org.eclipse.jetty.websocket.jakarta.HttpClient");
                }
                Executor executor = wsComponents.getExecutor();
                if (httpClient != null && httpClient.getExecutor() == null) {
                    httpClient.setExecutor(executor);
                }
                coreClient = new WebSocketCoreClient(httpClient, (WebSocketComponents)wsComponents);
                coreClient.getHttpClient().setName("Jakarta-WebSocketClient@" + Integer.toHexString(coreClient.getHttpClient().hashCode()));
                if (executor != null && httpClient == null) {
                    coreClient.getHttpClient().setExecutor(executor);
                }
                servletContext.setAttribute(WebSocketCoreClient.WEBSOCKET_CORECLIENT_ATTRIBUTE, (Object)coreClient);
            }
            return coreClient;
        };
        final JakartaWebSocketServerContainer container = new JakartaWebSocketServerContainer(WebSocketMappings.ensureMappings(contextHandler), WebSocketServerComponents.getWebSocketComponents(contextHandler), coreClientSupplier);
        contextHandler.addManaged(container);
        ((ContextHandler)contextHandler).addEventListener(container);
        ((ContextHandler)contextHandler).addEventListener(new LifeCycle.Listener(){

            @Override
            public void lifeCycleStopping(LifeCycle event) {
                servletContext.removeAttribute(JAKARTA_WEBSOCKET_CONTAINER_ATTRIBUTE);
                contextHandler.removeBean(container);
                contextHandler.removeEventListener(container);
                contextHandler.removeEventListener(this);
            }

            public String toString() {
                return String.format("%sCleanupListener", JakartaWebSocketServerContainer.class.getSimpleName());
            }
        });
        servletContext.setAttribute(JAKARTA_WEBSOCKET_CONTAINER_ATTRIBUTE, (Object)container);
        return container;
    }

    JakartaWebSocketServerContainer(WebSocketMappings webSocketMappings, WebSocketComponents components, Function<WebSocketComponents, WebSocketCoreClient> coreClientSupplier) {
        super(components, coreClientSupplier);
        this.webSocketMappings = webSocketMappings;
        this.frameHandlerFactory = new JakartaWebSocketServerFrameHandlerFactory(this);
    }

    @Override
    public JakartaWebSocketServerFrameHandlerFactory getFrameHandlerFactory() {
        return this.frameHandlerFactory;
    }

    private void validateEndpointConfig(ServerEndpointConfig config) throws DeploymentException {
        if (config == null) {
            throw new DeploymentException("Unable to deploy null ServerEndpointConfig");
        }
        ServerEndpointConfig.Configurator configurator = config.getConfigurator();
        if (configurator == null) {
            throw new DeploymentException("Unable to deploy with null ServerEndpointConfig.Configurator");
        }
        Class endpointClass = config.getEndpointClass();
        if (endpointClass == null) {
            throw new DeploymentException("Unable to deploy null endpoint class from ServerEndpointConfig: " + config.getClass().getName());
        }
        if (!Endpoint.class.isAssignableFrom(endpointClass) && endpointClass.getAnnotation(ServerEndpoint.class) == null && endpointClass.getAnnotation(ClientEndpoint.class) == null) {
            throw new DeploymentException("Unable to deploy unknown endpoint class: " + endpointClass.getName());
        }
        if (!Modifier.isPublic(endpointClass.getModifiers())) {
            throw new DeploymentException("Class is not public: " + endpointClass.getName());
        }
        if (configurator.getClass() == ContainerDefaultConfigurator.class && !ReflectUtils.isDefaultConstructable(endpointClass)) {
            throw new DeploymentException("Cannot access default constructor for the class: " + endpointClass.getName());
        }
    }

    public void addEndpoint(Class<?> endpointClass) throws DeploymentException {
        if (endpointClass == null) {
            throw new DeploymentException("Unable to deploy null endpoint class");
        }
        if (this.isStarted() || this.isStarting()) {
            ServerEndpoint anno = endpointClass.getAnnotation(ServerEndpoint.class);
            if (anno == null) {
                throw new DeploymentException(String.format("Class must be @%s annotated: %s", ServerEndpoint.class.getName(), endpointClass.getName()));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("addEndpoint({})", endpointClass);
            }
            AnnotatedServerEndpointConfig config = new AnnotatedServerEndpointConfig(this, endpointClass, anno);
            this.validateEndpointConfig(config);
            this.addEndpointMapping(config);
        } else {
            if (this.deferredEndpointClasses == null) {
                this.deferredEndpointClasses = new ArrayList();
            }
            this.deferredEndpointClasses.add(endpointClass);
        }
    }

    public void addEndpoint(ServerEndpointConfig providedConfig) throws DeploymentException {
        if (providedConfig == null) {
            throw new DeploymentException("ServerEndpointConfig is null");
        }
        if (this.isStarted() || this.isStarting()) {
            ServerEndpointConfig config;
            this.components.getObjectFactory().decorate(providedConfig.getConfigurator());
            Class endpointClass = providedConfig.getEndpointClass();
            ServerEndpoint anno = endpointClass.getAnnotation(ServerEndpoint.class);
            Object object = config = anno == null ? providedConfig : new AnnotatedServerEndpointConfig(this, endpointClass, anno, (EndpointConfig)providedConfig);
            if (LOG.isDebugEnabled()) {
                LOG.debug("addEndpoint({}) path={} endpoint={}", new Object[]{config, config.getPath(), endpointClass});
            }
            this.validateEndpointConfig(config);
            this.addEndpointMapping(config);
        } else {
            if (this.deferredEndpointConfigs == null) {
                this.deferredEndpointConfigs = new ArrayList<ServerEndpointConfig>();
            }
            this.deferredEndpointConfigs.add(providedConfig);
        }
    }

    private void addEndpointMapping(ServerEndpointConfig config) throws DeploymentException {
        try {
            this.frameHandlerFactory.getMetadata(config.getEndpointClass(), (EndpointConfig)config);
            JakartaWebSocketCreator creator = new JakartaWebSocketCreator(this, config, this.getExtensionRegistry());
            UriTemplatePathSpec pathSpec = new UriTemplatePathSpec(config.getPath());
            this.webSocketMappings.addMapping(pathSpec, creator, this.frameHandlerFactory, this.defaultCustomizer);
        }
        catch (InvalidSignatureException e) {
            throw new DeploymentException(e.getMessage(), (Throwable)e);
        }
        catch (Throwable t) {
            throw new DeploymentException("Unable to deploy: " + config.getEndpointClass().getName(), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upgradeHttpToWebSocket(Object httpServletRequest, Object httpServletResponse, ServerEndpointConfig sec, Map<String, String> pathParameters) throws IOException, DeploymentException {
        block5: {
            ServerEndpointConfig config;
            HttpServletRequest request = (HttpServletRequest)httpServletRequest;
            HttpServletResponse response = (HttpServletResponse)httpServletResponse;
            this.components.getObjectFactory().decorate(sec.getConfigurator());
            Class endpointClass = sec.getEndpointClass();
            ServerEndpoint anno = endpointClass.getAnnotation(ServerEndpoint.class);
            Object object = config = anno == null ? sec : new AnnotatedServerEndpointConfig(this, endpointClass, anno, (EndpointConfig)sec);
            if (LOG.isDebugEnabled()) {
                LOG.debug("addEndpoint({}) path={} endpoint={}", new Object[]{config, config.getPath(), endpointClass});
            }
            this.validateEndpointConfig(config);
            this.frameHandlerFactory.getMetadata(config.getEndpointClass(), (EndpointConfig)config);
            request.setAttribute(PATH_PARAM_ATTRIBUTE, pathParameters);
            JakartaWebSocketCreator creator = new JakartaWebSocketCreator(this, config, this.getExtensionRegistry());
            WebSocketNegotiator negotiator = WebSocketNegotiator.from(creator, this.frameHandlerFactory);
            Handshaker handshaker = this.webSocketMappings.getHandshaker();
            ServletContextRequest servletContextRequest = ServletContextRequest.getServletContextRequest((ServletRequest)request);
            ServletContextResponse servletContextResponse = servletContextRequest.getServletContextResponse();
            FutureCallback callback = new FutureCallback();
            try {
                servletContextRequest.setAttribute("org.eclipse.jetty.websocket.wrappedRequest", request);
                servletContextRequest.setAttribute("org.eclipse.jetty.websocket.wrappedResponse", response);
                if (handshaker.upgradeRequest(negotiator, servletContextRequest, servletContextResponse, callback, this.components, this.defaultCustomizer)) {
                    callback.block();
                    break block5;
                }
                throw new IllegalStateException("Invalid WebSocket Upgrade Request");
            }
            finally {
                servletContextRequest.removeAttribute("org.eclipse.jetty.websocket.wrappedRequest");
                servletContextRequest.removeAttribute("org.eclipse.jetty.websocket.wrappedResponse");
            }
        }
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        if (this.deferredEndpointClasses != null) {
            for (Class<?> endpointClass : this.deferredEndpointClasses) {
                this.addEndpoint(endpointClass);
            }
            this.deferredEndpointClasses.clear();
        }
        if (this.deferredEndpointConfigs != null) {
            for (ServerEndpointConfig config : this.deferredEndpointConfigs) {
                this.addEndpoint(config);
            }
            this.deferredEndpointConfigs.clear();
        }
    }

    @Override
    protected void doClientStart() {
    }

    @Override
    protected void doClientStop() {
    }
}

